// $ANTLR 3.5 org\\antlr\\v4\\parse\\GrammarTreeVisitor.g 2014-02-04 17:22:47

/*
 [The "BSD license"]
 Copyright (c) 2011 Terence Parr
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.antlr.v4.parse;
import org.antlr.v4.tool.*;
import org.antlr.v4.tool.ast.*;
import java.lang.reflect.Method;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/** The definitive ANTLR v3 tree grammar to walk/visit ANTLR v4 grammars.
 *  Parses trees created by ANTLRParser.g.
 *
 *  Rather than have multiple tree grammars, one for each visit, I'm
 *  creating this generic visitor that knows about context. All of the
 *  boilerplate pattern recognition is done here. Then, subclasses can
 *  override the methods they care about. This prevents a lot of the same
 *  context tracking stuff like "set current alternative for current
 *  rule node" that is repeated in lots of tree filters.
 */
@SuppressWarnings("all")
public class GrammarTreeVisitor extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTION", "ACTION_CHAR_LITERAL", 
		"ACTION_ESC", "ACTION_STRING_LITERAL", "ARG_ACTION", "ARG_OR_CHARSET", 
		"ASSIGN", "AT", "CATCH", "COLON", "COLONCOLON", "COMMA", "COMMENT", "DOC_COMMENT", 
		"DOLLAR", "DOT", "ERRCHAR", "ESC_SEQ", "FINALLY", "FRAGMENT", "GRAMMAR", 
		"GT", "HEX_DIGIT", "ID", "IMPORT", "INT", "LEXER", "LEXER_CHAR_SET", "LOCALS", 
		"LPAREN", "LT", "MODE", "NESTED_ACTION", "NLCHARS", "NOT", "NameChar", 
		"NameStartChar", "OPTIONS", "OR", "PARSER", "PLUS", "PLUS_ASSIGN", "POUND", 
		"PRIVATE", "PROTECTED", "PUBLIC", "QUESTION", "RANGE", "RARROW", "RBRACE", 
		"RETURNS", "RPAREN", "RULE_REF", "SEMI", "SEMPRED", "SRC", "STAR", "STRING_LITERAL", 
		"SYNPRED", "THROWS", "TOKENS_SPEC", "TOKEN_REF", "TREE_GRAMMAR", "UNICODE_ESC", 
		"UnicodeBOM", "WS", "WSCHARS", "WSNLCHARS", "ALT", "ALTLIST", "ARG", "ARGLIST", 
		"BLOCK", "CHAR_RANGE", "CLOSURE", "COMBINED", "ELEMENT_OPTIONS", "EPSILON", 
		"INITACTION", "LABEL", "LEXER_ACTION_CALL", "LEXER_ALT_ACTION", "LIST", 
		"OPTIONAL", "POSITIVE_CLOSURE", "PREC_RULE", "RESULT", "RET", "RULE", 
		"RULEACTIONS", "RULEMODIFIERS", "RULES", "SET", "TEMPLATE", "WILDCARD"
	};
	public static final int EOF=-1;
	public static final int ACTION=4;
	public static final int ACTION_CHAR_LITERAL=5;
	public static final int ACTION_ESC=6;
	public static final int ACTION_STRING_LITERAL=7;
	public static final int ARG_ACTION=8;
	public static final int ARG_OR_CHARSET=9;
	public static final int ASSIGN=10;
	public static final int AT=11;
	public static final int CATCH=12;
	public static final int COLON=13;
	public static final int COLONCOLON=14;
	public static final int COMMA=15;
	public static final int COMMENT=16;
	public static final int DOC_COMMENT=17;
	public static final int DOLLAR=18;
	public static final int DOT=19;
	public static final int ERRCHAR=20;
	public static final int ESC_SEQ=21;
	public static final int FINALLY=22;
	public static final int FRAGMENT=23;
	public static final int GRAMMAR=24;
	public static final int GT=25;
	public static final int HEX_DIGIT=26;
	public static final int ID=27;
	public static final int IMPORT=28;
	public static final int INT=29;
	public static final int LEXER=30;
	public static final int LEXER_CHAR_SET=31;
	public static final int LOCALS=32;
	public static final int LPAREN=33;
	public static final int LT=34;
	public static final int MODE=35;
	public static final int NESTED_ACTION=36;
	public static final int NLCHARS=37;
	public static final int NOT=38;
	public static final int NameChar=39;
	public static final int NameStartChar=40;
	public static final int OPTIONS=41;
	public static final int OR=42;
	public static final int PARSER=43;
	public static final int PLUS=44;
	public static final int PLUS_ASSIGN=45;
	public static final int POUND=46;
	public static final int PRIVATE=47;
	public static final int PROTECTED=48;
	public static final int PUBLIC=49;
	public static final int QUESTION=50;
	public static final int RANGE=51;
	public static final int RARROW=52;
	public static final int RBRACE=53;
	public static final int RETURNS=54;
	public static final int RPAREN=55;
	public static final int RULE_REF=56;
	public static final int SEMI=57;
	public static final int SEMPRED=58;
	public static final int SRC=59;
	public static final int STAR=60;
	public static final int STRING_LITERAL=61;
	public static final int SYNPRED=62;
	public static final int THROWS=63;
	public static final int TOKENS_SPEC=64;
	public static final int TOKEN_REF=65;
	public static final int TREE_GRAMMAR=66;
	public static final int UNICODE_ESC=67;
	public static final int UnicodeBOM=68;
	public static final int WS=69;
	public static final int WSCHARS=70;
	public static final int WSNLCHARS=71;
	public static final int ALT=72;
	public static final int ALTLIST=73;
	public static final int ARG=74;
	public static final int ARGLIST=75;
	public static final int BLOCK=76;
	public static final int CHAR_RANGE=77;
	public static final int CLOSURE=78;
	public static final int COMBINED=79;
	public static final int ELEMENT_OPTIONS=80;
	public static final int EPSILON=81;
	public static final int INITACTION=82;
	public static final int LABEL=83;
	public static final int LEXER_ACTION_CALL=84;
	public static final int LEXER_ALT_ACTION=85;
	public static final int LIST=86;
	public static final int OPTIONAL=87;
	public static final int POSITIVE_CLOSURE=88;
	public static final int PREC_RULE=89;
	public static final int RESULT=90;
	public static final int RET=91;
	public static final int RULE=92;
	public static final int RULEACTIONS=93;
	public static final int RULEMODIFIERS=94;
	public static final int RULES=95;
	public static final int SET=96;
	public static final int TEMPLATE=97;
	public static final int WILDCARD=98;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public GrammarTreeVisitor(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public GrammarTreeVisitor(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return GrammarTreeVisitor.tokenNames; }
	@Override public String getGrammarFileName() { return "org\\antlr\\v4\\parse\\GrammarTreeVisitor.g"; }


	public String grammarName;
	public GrammarAST currentRuleAST;
	public String currentModeName = LexerGrammar.DEFAULT_MODE_NAME;
	public String currentRuleName;
	//public GrammarAST currentRuleBlock;
	public GrammarAST currentOuterAltRoot;
	public int currentOuterAltNumber = 1; // 1..n
	public int rewriteEBNFLevel = 0;

	public GrammarTreeVisitor() { this(null); }

	public ErrorManager getErrorManager() { return null; }

	public void visitGrammar(GrammarAST t) { visit(t, "grammarSpec"); }
	public void visit(GrammarAST t, String ruleName) {
		CommonTreeNodeStream nodes = new CommonTreeNodeStream(new GrammarASTAdaptor(), t);
		setTreeNodeStream(nodes);
		try {
			Method m = getClass().getMethod(ruleName);
			m.invoke(this);
		}
		catch (Exception e) {
			ErrorManager errMgr = getErrorManager();
			if ( errMgr==null ) {
				System.err.println("can't find rule "+ruleName+
								   " or tree structure error: "+t.toStringTree()
								   );
				e.printStackTrace(System.err);
			}
			else errMgr.toolError(ErrorType.INTERNAL_ERROR, e);
		}
	}

	public void discoverGrammar(GrammarRootAST root, GrammarAST ID) { }
	public void finishPrequels(GrammarAST firstPrequel) { }
	public void finishGrammar(GrammarRootAST root, GrammarAST ID) { }

	public void grammarOption(GrammarAST ID, GrammarAST valueAST) { }
	public void ruleOption(GrammarAST ID, GrammarAST valueAST) { }
	public void blockOption(GrammarAST ID, GrammarAST valueAST) { }
	public void defineToken(GrammarAST ID) { }
	public void globalNamedAction(GrammarAST scope, GrammarAST ID, ActionAST action) { }
	public void importGrammar(GrammarAST label, GrammarAST ID) { }

	public void modeDef(GrammarAST m, GrammarAST ID) { }

	public void discoverRules(GrammarAST rules) { }
	public void finishRules(GrammarAST rule) { }
	public void discoverRule(RuleAST rule, GrammarAST ID, List<GrammarAST> modifiers,
							 ActionAST arg, ActionAST returns, GrammarAST thrws,
							 GrammarAST options, ActionAST locals,
							 List<GrammarAST> actions,
							 GrammarAST block) { }
	public void finishRule(RuleAST rule, GrammarAST ID, GrammarAST block) { }
	public void discoverLexerRule(RuleAST rule, GrammarAST ID, List<GrammarAST> modifiers,
	                              GrammarAST block) { }
	public void finishLexerRule(RuleAST rule, GrammarAST ID, GrammarAST block) { }
	public void ruleCatch(GrammarAST arg, ActionAST action) { }
	public void finallyAction(ActionAST action) { }
	public void discoverOuterAlt(AltAST alt) { }
	public void finishOuterAlt(AltAST alt) { }
	public void discoverAlt(AltAST alt) { }
	public void finishAlt(AltAST alt) { }

	public void ruleRef(GrammarAST ref, ActionAST arg) { }
	public void tokenRef(TerminalAST ref) { }
	public void elementOption(GrammarASTWithOptions t, GrammarAST ID, GrammarAST valueAST) { }
	public void stringRef(TerminalAST ref) { }
	public void wildcardRef(GrammarAST ref) { }
	public void actionInAlt(ActionAST action) { }
	public void sempredInAlt(PredAST pred) { }
	public void label(GrammarAST op, GrammarAST ID, GrammarAST element) { }
	public void lexerCallCommand(int outerAltNumber, GrammarAST ID, GrammarAST arg) { }
	public void lexerCommand(int outerAltNumber, GrammarAST ID) { }

	protected void enterGrammarSpec(GrammarAST tree) { }
	protected void exitGrammarSpec(GrammarAST tree) { }

	protected void enterPrequelConstructs(GrammarAST tree) { }
	protected void exitPrequelConstructs(GrammarAST tree) { }

	protected void enterPrequelConstruct(GrammarAST tree) { }
	protected void exitPrequelConstruct(GrammarAST tree) { }

	protected void enterOptionsSpec(GrammarAST tree) { }
	protected void exitOptionsSpec(GrammarAST tree) { }

	protected void enterOption(GrammarAST tree) { }
	protected void exitOption(GrammarAST tree) { }

	protected void enterOptionValue(GrammarAST tree) { }
	protected void exitOptionValue(GrammarAST tree) { }

	protected void enterDelegateGrammars(GrammarAST tree) { }
	protected void exitDelegateGrammars(GrammarAST tree) { }

	protected void enterDelegateGrammar(GrammarAST tree) { }
	protected void exitDelegateGrammar(GrammarAST tree) { }

	protected void enterTokensSpec(GrammarAST tree) { }
	protected void exitTokensSpec(GrammarAST tree) { }

	protected void enterTokenSpec(GrammarAST tree) { }
	protected void exitTokenSpec(GrammarAST tree) { }

	protected void enterAction(GrammarAST tree) { }
	protected void exitAction(GrammarAST tree) { }

	protected void enterRules(GrammarAST tree) { }
	protected void exitRules(GrammarAST tree) { }

	protected void enterMode(GrammarAST tree) { }
	protected void exitMode(GrammarAST tree) { }

	protected void enterLexerRule(GrammarAST tree) { }
	protected void exitLexerRule(GrammarAST tree) { }

	protected void enterRule(GrammarAST tree) { }
	protected void exitRule(GrammarAST tree) { }

	protected void enterExceptionGroup(GrammarAST tree) { }
	protected void exitExceptionGroup(GrammarAST tree) { }

	protected void enterExceptionHandler(GrammarAST tree) { }
	protected void exitExceptionHandler(GrammarAST tree) { }

	protected void enterFinallyClause(GrammarAST tree) { }
	protected void exitFinallyClause(GrammarAST tree) { }

	protected void enterLocals(GrammarAST tree) { }
	protected void exitLocals(GrammarAST tree) { }

	protected void enterRuleReturns(GrammarAST tree) { }
	protected void exitRuleReturns(GrammarAST tree) { }

	protected void enterThrowsSpec(GrammarAST tree) { }
	protected void exitThrowsSpec(GrammarAST tree) { }

	protected void enterRuleAction(GrammarAST tree) { }
	protected void exitRuleAction(GrammarAST tree) { }

	protected void enterRuleModifier(GrammarAST tree) { }
	protected void exitRuleModifier(GrammarAST tree) { }

	protected void enterLexerRuleBlock(GrammarAST tree) { }
	protected void exitLexerRuleBlock(GrammarAST tree) { }

	protected void enterRuleBlock(GrammarAST tree) { }
	protected void exitRuleBlock(GrammarAST tree) { }

	protected void enterLexerOuterAlternative(AltAST tree) { }
	protected void exitLexerOuterAlternative(AltAST tree) { }

	protected void enterOuterAlternative(AltAST tree) { }
	protected void exitOuterAlternative(AltAST tree) { }

	protected void enterLexerAlternative(GrammarAST tree) { }
	protected void exitLexerAlternative(GrammarAST tree) { }

	protected void enterLexerElements(GrammarAST tree) { }
	protected void exitLexerElements(GrammarAST tree) { }

	protected void enterLexerElement(GrammarAST tree) { }
	protected void exitLexerElement(GrammarAST tree) { }

	protected void enterLabeledLexerElement(GrammarAST tree) { }
	protected void exitLabeledLexerElement(GrammarAST tree) { }

	protected void enterLexerBlock(GrammarAST tree) { }
	protected void exitLexerBlock(GrammarAST tree) { }

	protected void enterLexerAtom(GrammarAST tree) { }
	protected void exitLexerAtom(GrammarAST tree) { }

	protected void enterActionElement(GrammarAST tree) { }
	protected void exitActionElement(GrammarAST tree) { }

	protected void enterAlternative(AltAST tree) { }
	protected void exitAlternative(AltAST tree) { }

	protected void enterLexerCommand(GrammarAST tree) { }
	protected void exitLexerCommand(GrammarAST tree) { }

	protected void enterLexerCommandExpr(GrammarAST tree) { }
	protected void exitLexerCommandExpr(GrammarAST tree) { }

	protected void enterElement(GrammarAST tree) { }
	protected void exitElement(GrammarAST tree) { }

	protected void enterAstOperand(GrammarAST tree) { }
	protected void exitAstOperand(GrammarAST tree) { }

	protected void enterLabeledElement(GrammarAST tree) { }
	protected void exitLabeledElement(GrammarAST tree) { }

	protected void enterSubrule(GrammarAST tree) { }
	protected void exitSubrule(GrammarAST tree) { }

	protected void enterLexerSubrule(GrammarAST tree) { }
	protected void exitLexerSubrule(GrammarAST tree) { }

	protected void enterBlockSuffix(GrammarAST tree) { }
	protected void exitBlockSuffix(GrammarAST tree) { }

	protected void enterEbnfSuffix(GrammarAST tree) { }
	protected void exitEbnfSuffix(GrammarAST tree) { }

	protected void enterAtom(GrammarAST tree) { }
	protected void exitAtom(GrammarAST tree) { }

	protected void enterBlockSet(GrammarAST tree) { }
	protected void exitBlockSet(GrammarAST tree) { }

	protected void enterSetElement(GrammarAST tree) { }
	protected void exitSetElement(GrammarAST tree) { }

	protected void enterBlock(GrammarAST tree) { }
	protected void exitBlock(GrammarAST tree) { }

	protected void enterRuleref(GrammarAST tree) { }
	protected void exitRuleref(GrammarAST tree) { }

	protected void enterRange(GrammarAST tree) { }
	protected void exitRange(GrammarAST tree) { }

	protected void enterTerminal(GrammarAST tree) { }
	protected void exitTerminal(GrammarAST tree) { }

	protected void enterElementOptions(GrammarAST tree) { }
	protected void exitElementOptions(GrammarAST tree) { }

	protected void enterElementOption(GrammarAST tree) { }
	protected void exitElementOption(GrammarAST tree) { }

		@Override
		public void traceIn(String ruleName, int ruleIndex)  {
			System.err.println("enter "+ruleName+": "+input.LT(1));
		}

		@Override
		public void traceOut(String ruleName, int ruleIndex)  {
			System.err.println("exit "+ruleName+": "+input.LT(1));
		}


	public static class grammarSpec_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "grammarSpec"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:330:1: grammarSpec : ^( GRAMMAR ID ( DOC_COMMENT )? prequelConstructs rules ( mode )* ) ;
	public final GrammarTreeVisitor.grammarSpec_return grammarSpec() throws RecognitionException {
		GrammarTreeVisitor.grammarSpec_return retval = new GrammarTreeVisitor.grammarSpec_return();
		retval.start = input.LT(1);

		GrammarAST ID1=null;
		GrammarAST GRAMMAR2=null;
		TreeRuleReturnScope prequelConstructs3 =null;


			enterGrammarSpec(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:337:5: ( ^( GRAMMAR ID ( DOC_COMMENT )? prequelConstructs rules ( mode )* ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:337:9: ^( GRAMMAR ID ( DOC_COMMENT )? prequelConstructs rules ( mode )* )
			{
			GRAMMAR2=(GrammarAST)match(input,GRAMMAR,FOLLOW_GRAMMAR_in_grammarSpec85); 
			match(input, Token.DOWN, null); 
			ID1=(GrammarAST)match(input,ID,FOLLOW_ID_in_grammarSpec87); 
			grammarName=(ID1!=null?ID1.getText():null);
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:337:47: ( DOC_COMMENT )?
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==DOC_COMMENT) ) {
				alt1=1;
			}
			switch (alt1) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:337:47: DOC_COMMENT
					{
					match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_grammarSpec91); 
					}
					break;

			}

			discoverGrammar((GrammarRootAST)GRAMMAR2, ID1);
			pushFollow(FOLLOW_prequelConstructs_in_grammarSpec109);
			prequelConstructs3=prequelConstructs();
			state._fsp--;

			finishPrequels((prequelConstructs3!=null?((GrammarTreeVisitor.prequelConstructs_return)prequelConstructs3).firstOne:null));
			pushFollow(FOLLOW_rules_in_grammarSpec126);
			rules();
			state._fsp--;

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:341:14: ( mode )*
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( (LA2_0==MODE) ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:341:14: mode
					{
					pushFollow(FOLLOW_mode_in_grammarSpec128);
					mode();
					state._fsp--;

					}
					break;

				default :
					break loop2;
				}
			}

			finishGrammar((GrammarRootAST)GRAMMAR2, ID1);
			match(input, Token.UP, null); 

			}


				exitGrammarSpec(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "grammarSpec"


	public static class prequelConstructs_return extends TreeRuleReturnScope {
		public GrammarAST firstOne=null;
	};


	// $ANTLR start "prequelConstructs"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:346:1: prequelConstructs returns [GrammarAST firstOne=null] : ( ( prequelConstruct )+ |);
	public final GrammarTreeVisitor.prequelConstructs_return prequelConstructs() throws RecognitionException {
		GrammarTreeVisitor.prequelConstructs_return retval = new GrammarTreeVisitor.prequelConstructs_return();
		retval.start = input.LT(1);


			enterPrequelConstructs(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:353:2: ( ( prequelConstruct )+ |)
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==AT||LA4_0==IMPORT||LA4_0==OPTIONS||LA4_0==TOKENS_SPEC) ) {
				alt4=1;
			}
			else if ( (LA4_0==RULES) ) {
				alt4=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}

			switch (alt4) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:353:4: ( prequelConstruct )+
					{
					retval.firstOne =((GrammarAST)retval.start);
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:353:24: ( prequelConstruct )+
					int cnt3=0;
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==AT||LA3_0==IMPORT||LA3_0==OPTIONS||LA3_0==TOKENS_SPEC) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:353:24: prequelConstruct
							{
							pushFollow(FOLLOW_prequelConstruct_in_prequelConstructs170);
							prequelConstruct();
							state._fsp--;

							}
							break;

						default :
							if ( cnt3 >= 1 ) break loop3;
							EarlyExitException eee = new EarlyExitException(3, input);
							throw eee;
						}
						cnt3++;
					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:355:2: 
					{
					}
					break;

			}

				exitPrequelConstructs(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prequelConstructs"


	public static class prequelConstruct_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "prequelConstruct"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:357:1: prequelConstruct : ( optionsSpec | delegateGrammars | tokensSpec | action );
	public final GrammarTreeVisitor.prequelConstruct_return prequelConstruct() throws RecognitionException {
		GrammarTreeVisitor.prequelConstruct_return retval = new GrammarTreeVisitor.prequelConstruct_return();
		retval.start = input.LT(1);


			enterPrequelConstructs(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:364:2: ( optionsSpec | delegateGrammars | tokensSpec | action )
			int alt5=4;
			switch ( input.LA(1) ) {
			case OPTIONS:
				{
				alt5=1;
				}
				break;
			case IMPORT:
				{
				alt5=2;
				}
				break;
			case TOKENS_SPEC:
				{
				alt5=3;
				}
				break;
			case AT:
				{
				alt5=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}
			switch (alt5) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:364:6: optionsSpec
					{
					pushFollow(FOLLOW_optionsSpec_in_prequelConstruct197);
					optionsSpec();
					state._fsp--;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:365:9: delegateGrammars
					{
					pushFollow(FOLLOW_delegateGrammars_in_prequelConstruct207);
					delegateGrammars();
					state._fsp--;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:366:9: tokensSpec
					{
					pushFollow(FOLLOW_tokensSpec_in_prequelConstruct217);
					tokensSpec();
					state._fsp--;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:367:9: action
					{
					pushFollow(FOLLOW_action_in_prequelConstruct227);
					action();
					state._fsp--;

					}
					break;

			}

				exitPrequelConstructs(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prequelConstruct"


	public static class optionsSpec_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "optionsSpec"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:370:1: optionsSpec : ^( OPTIONS ( option )* ) ;
	public final GrammarTreeVisitor.optionsSpec_return optionsSpec() throws RecognitionException {
		GrammarTreeVisitor.optionsSpec_return retval = new GrammarTreeVisitor.optionsSpec_return();
		retval.start = input.LT(1);


			enterOptionsSpec(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:377:2: ( ^( OPTIONS ( option )* ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:377:4: ^( OPTIONS ( option )* )
			{
			match(input,OPTIONS,FOLLOW_OPTIONS_in_optionsSpec252); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:377:14: ( option )*
				loop6:
				while (true) {
					int alt6=2;
					int LA6_0 = input.LA(1);
					if ( (LA6_0==ASSIGN) ) {
						alt6=1;
					}

					switch (alt6) {
					case 1 :
						// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:377:14: option
						{
						pushFollow(FOLLOW_option_in_optionsSpec254);
						option();
						state._fsp--;

						}
						break;

					default :
						break loop6;
					}
				}

				match(input, Token.UP, null); 
			}

			}


				exitOptionsSpec(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionsSpec"


	public static class option_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "option"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:380:1: option : ^(a= ASSIGN ID v= optionValue ) ;
	public final GrammarTreeVisitor.option_return option() throws RecognitionException {
		GrammarTreeVisitor.option_return retval = new GrammarTreeVisitor.option_return();
		retval.start = input.LT(1);

		GrammarAST a=null;
		GrammarAST ID4=null;
		TreeRuleReturnScope v =null;


			enterOption(((GrammarAST)retval.start));
			boolean rule = inContext("RULE ...");
			boolean block = inContext("BLOCK ...");

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:389:5: ( ^(a= ASSIGN ID v= optionValue ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:389:9: ^(a= ASSIGN ID v= optionValue )
			{
			a=(GrammarAST)match(input,ASSIGN,FOLLOW_ASSIGN_in_option288); 
			match(input, Token.DOWN, null); 
			ID4=(GrammarAST)match(input,ID,FOLLOW_ID_in_option290); 
			pushFollow(FOLLOW_optionValue_in_option294);
			v=optionValue();
			state._fsp--;

			match(input, Token.UP, null); 


			    	if ( block ) blockOption(ID4, (v!=null?((GrammarAST)v.start):null)); // most specific first
			    	else if ( rule ) ruleOption(ID4, (v!=null?((GrammarAST)v.start):null));
			    	else grammarOption(ID4, (v!=null?((GrammarAST)v.start):null));
			    	
			}


				exitOption(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "option"


	public static class optionValue_return extends TreeRuleReturnScope {
		public String v;
	};


	// $ANTLR start "optionValue"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:397:1: optionValue returns [String v] : ( ID | STRING_LITERAL | INT );
	public final GrammarTreeVisitor.optionValue_return optionValue() throws RecognitionException {
		GrammarTreeVisitor.optionValue_return retval = new GrammarTreeVisitor.optionValue_return();
		retval.start = input.LT(1);


			enterOptionValue(((GrammarAST)retval.start));
			retval.v = ((GrammarAST)retval.start).token.getText();

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:405:5: ( ID | STRING_LITERAL | INT )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:
			{
			if ( input.LA(1)==ID||input.LA(1)==INT||input.LA(1)==STRING_LITERAL ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}


				exitOptionValue(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionValue"


	public static class delegateGrammars_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "delegateGrammars"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:410:1: delegateGrammars : ^( IMPORT ( delegateGrammar )+ ) ;
	public final GrammarTreeVisitor.delegateGrammars_return delegateGrammars() throws RecognitionException {
		GrammarTreeVisitor.delegateGrammars_return retval = new GrammarTreeVisitor.delegateGrammars_return();
		retval.start = input.LT(1);


			enterDelegateGrammars(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:417:2: ( ^( IMPORT ( delegateGrammar )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:417:6: ^( IMPORT ( delegateGrammar )+ )
			{
			match(input,IMPORT,FOLLOW_IMPORT_in_delegateGrammars382); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:417:15: ( delegateGrammar )+
			int cnt7=0;
			loop7:
			while (true) {
				int alt7=2;
				int LA7_0 = input.LA(1);
				if ( (LA7_0==ASSIGN||LA7_0==ID) ) {
					alt7=1;
				}

				switch (alt7) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:417:15: delegateGrammar
					{
					pushFollow(FOLLOW_delegateGrammar_in_delegateGrammars384);
					delegateGrammar();
					state._fsp--;

					}
					break;

				default :
					if ( cnt7 >= 1 ) break loop7;
					EarlyExitException eee = new EarlyExitException(7, input);
					throw eee;
				}
				cnt7++;
			}

			match(input, Token.UP, null); 

			}


				exitDelegateGrammars(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delegateGrammars"


	public static class delegateGrammar_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "delegateGrammar"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:420:1: delegateGrammar : ( ^( ASSIGN label= ID id= ID ) |id= ID );
	public final GrammarTreeVisitor.delegateGrammar_return delegateGrammar() throws RecognitionException {
		GrammarTreeVisitor.delegateGrammar_return retval = new GrammarTreeVisitor.delegateGrammar_return();
		retval.start = input.LT(1);

		GrammarAST label=null;
		GrammarAST id=null;


			enterDelegateGrammar(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:427:5: ( ^( ASSIGN label= ID id= ID ) |id= ID )
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==ASSIGN) ) {
				alt8=1;
			}
			else if ( (LA8_0==ID) ) {
				alt8=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}

			switch (alt8) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:427:9: ^( ASSIGN label= ID id= ID )
					{
					match(input,ASSIGN,FOLLOW_ASSIGN_in_delegateGrammar413); 
					match(input, Token.DOWN, null); 
					label=(GrammarAST)match(input,ID,FOLLOW_ID_in_delegateGrammar417); 
					id=(GrammarAST)match(input,ID,FOLLOW_ID_in_delegateGrammar421); 
					match(input, Token.UP, null); 

					importGrammar(label, id);
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:428:9: id= ID
					{
					id=(GrammarAST)match(input,ID,FOLLOW_ID_in_delegateGrammar436); 
					importGrammar(null, id);
					}
					break;

			}

				exitDelegateGrammar(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delegateGrammar"


	public static class tokensSpec_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "tokensSpec"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:431:1: tokensSpec : ^( TOKENS_SPEC ( tokenSpec )+ ) ;
	public final GrammarTreeVisitor.tokensSpec_return tokensSpec() throws RecognitionException {
		GrammarTreeVisitor.tokensSpec_return retval = new GrammarTreeVisitor.tokensSpec_return();
		retval.start = input.LT(1);


			enterTokensSpec(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:438:2: ( ^( TOKENS_SPEC ( tokenSpec )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:438:6: ^( TOKENS_SPEC ( tokenSpec )+ )
			{
			match(input,TOKENS_SPEC,FOLLOW_TOKENS_SPEC_in_tokensSpec470); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:438:20: ( tokenSpec )+
			int cnt9=0;
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( (LA9_0==ID) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:438:20: tokenSpec
					{
					pushFollow(FOLLOW_tokenSpec_in_tokensSpec472);
					tokenSpec();
					state._fsp--;

					}
					break;

				default :
					if ( cnt9 >= 1 ) break loop9;
					EarlyExitException eee = new EarlyExitException(9, input);
					throw eee;
				}
				cnt9++;
			}

			match(input, Token.UP, null); 

			}


				exitTokensSpec(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "tokensSpec"


	public static class tokenSpec_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "tokenSpec"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:441:1: tokenSpec : ID ;
	public final GrammarTreeVisitor.tokenSpec_return tokenSpec() throws RecognitionException {
		GrammarTreeVisitor.tokenSpec_return retval = new GrammarTreeVisitor.tokenSpec_return();
		retval.start = input.LT(1);

		GrammarAST ID5=null;


			enterTokenSpec(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:448:2: ( ID )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:448:4: ID
			{
			ID5=(GrammarAST)match(input,ID,FOLLOW_ID_in_tokenSpec495); 
			defineToken(ID5);
			}


				exitTokenSpec(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "tokenSpec"


	public static class action_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "action"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:451:1: action : ^( AT (sc= ID )? name= ID ACTION ) ;
	public final GrammarTreeVisitor.action_return action() throws RecognitionException {
		GrammarTreeVisitor.action_return retval = new GrammarTreeVisitor.action_return();
		retval.start = input.LT(1);

		GrammarAST sc=null;
		GrammarAST name=null;
		GrammarAST ACTION6=null;


			enterAction(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:458:2: ( ^( AT (sc= ID )? name= ID ACTION ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:458:4: ^( AT (sc= ID )? name= ID ACTION )
			{
			match(input,AT,FOLLOW_AT_in_action523); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:458:11: (sc= ID )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==ID) ) {
				int LA10_1 = input.LA(2);
				if ( (LA10_1==ID) ) {
					alt10=1;
				}
			}
			switch (alt10) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:458:11: sc= ID
					{
					sc=(GrammarAST)match(input,ID,FOLLOW_ID_in_action527); 
					}
					break;

			}

			name=(GrammarAST)match(input,ID,FOLLOW_ID_in_action532); 
			ACTION6=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_action534); 
			match(input, Token.UP, null); 

			globalNamedAction(sc, name, (ActionAST)ACTION6);
			}


				exitAction(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "action"


	public static class rules_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "rules"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:461:1: rules : ^( RULES ( rule | lexerRule )* ) ;
	public final GrammarTreeVisitor.rules_return rules() throws RecognitionException {
		GrammarTreeVisitor.rules_return retval = new GrammarTreeVisitor.rules_return();
		retval.start = input.LT(1);

		GrammarAST RULES7=null;


			enterRules(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:468:5: ( ^( RULES ( rule | lexerRule )* ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:468:7: ^( RULES ( rule | lexerRule )* )
			{
			RULES7=(GrammarAST)match(input,RULES,FOLLOW_RULES_in_rules562); 
			discoverRules(RULES7);
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:468:40: ( rule | lexerRule )*
				loop11:
				while (true) {
					int alt11=3;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==RULE) ) {
						int LA11_2 = input.LA(2);
						if ( (LA11_2==DOWN) ) {
							int LA11_3 = input.LA(3);
							if ( (LA11_3==RULE_REF) ) {
								alt11=1;
							}
							else if ( (LA11_3==TOKEN_REF) ) {
								alt11=2;
							}

						}

					}

					switch (alt11) {
					case 1 :
						// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:468:41: rule
						{
						pushFollow(FOLLOW_rule_in_rules567);
						rule();
						state._fsp--;

						}
						break;
					case 2 :
						// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:468:46: lexerRule
						{
						pushFollow(FOLLOW_lexerRule_in_rules569);
						lexerRule();
						state._fsp--;

						}
						break;

					default :
						break loop11;
					}
				}

				finishRules(RULES7);
				match(input, Token.UP, null); 
			}

			}


				exitRules(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rules"


	public static class mode_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "mode"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:471:1: mode : ^( MODE ID ( lexerRule )* ) ;
	public final GrammarTreeVisitor.mode_return mode() throws RecognitionException {
		GrammarTreeVisitor.mode_return retval = new GrammarTreeVisitor.mode_return();
		retval.start = input.LT(1);

		GrammarAST ID8=null;
		GrammarAST MODE9=null;


			enterMode(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:478:2: ( ^( MODE ID ( lexerRule )* ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:478:4: ^( MODE ID ( lexerRule )* )
			{
			MODE9=(GrammarAST)match(input,MODE,FOLLOW_MODE_in_mode600); 
			match(input, Token.DOWN, null); 
			ID8=(GrammarAST)match(input,ID,FOLLOW_ID_in_mode602); 
			currentModeName=(ID8!=null?ID8.getText():null); modeDef(MODE9, ID8);
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:478:64: ( lexerRule )*
			loop12:
			while (true) {
				int alt12=2;
				int LA12_0 = input.LA(1);
				if ( (LA12_0==RULE) ) {
					alt12=1;
				}

				switch (alt12) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:478:64: lexerRule
					{
					pushFollow(FOLLOW_lexerRule_in_mode606);
					lexerRule();
					state._fsp--;

					}
					break;

				default :
					break loop12;
				}
			}

			match(input, Token.UP, null); 

			}


				exitMode(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mode"


	public static class lexerRule_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerRule"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:481:1: lexerRule : ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS m= FRAGMENT ) )? lexerRuleBlock ) ;
	public final GrammarTreeVisitor.lexerRule_return lexerRule() throws RecognitionException {
		GrammarTreeVisitor.lexerRule_return retval = new GrammarTreeVisitor.lexerRule_return();
		retval.start = input.LT(1);

		GrammarAST m=null;
		GrammarAST TOKEN_REF10=null;
		GrammarAST RULE11=null;
		TreeRuleReturnScope lexerRuleBlock12 =null;


			enterLexerRule(((GrammarAST)retval.start));
			List<GrammarAST> mods = new ArrayList<GrammarAST>();
			currentOuterAltNumber=0;

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:490:2: ( ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS m= FRAGMENT ) )? lexerRuleBlock ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:490:4: ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS m= FRAGMENT ) )? lexerRuleBlock )
			{
			RULE11=(GrammarAST)match(input,RULE,FOLLOW_RULE_in_lexerRule632); 
			match(input, Token.DOWN, null); 
			TOKEN_REF10=(GrammarAST)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_lexerRule634); 
			currentRuleName=(TOKEN_REF10!=null?TOKEN_REF10.getText():null); currentRuleAST=RULE11;
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:492:4: ( DOC_COMMENT )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==DOC_COMMENT) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:492:4: DOC_COMMENT
					{
					match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_lexerRule644); 
					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:492:17: ( ^( RULEMODIFIERS m= FRAGMENT ) )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==RULEMODIFIERS) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:492:18: ^( RULEMODIFIERS m= FRAGMENT )
					{
					match(input,RULEMODIFIERS,FOLLOW_RULEMODIFIERS_in_lexerRule649); 
					match(input, Token.DOWN, null); 
					m=(GrammarAST)match(input,FRAGMENT,FOLLOW_FRAGMENT_in_lexerRule653); 
					mods.add(m);
					match(input, Token.UP, null); 

					}
					break;

			}

			discoverLexerRule((RuleAST)RULE11, TOKEN_REF10, mods, (GrammarAST)input.LT(1));
			pushFollow(FOLLOW_lexerRuleBlock_in_lexerRule678);
			lexerRuleBlock12=lexerRuleBlock();
			state._fsp--;


			      		finishLexerRule((RuleAST)RULE11, TOKEN_REF10, (lexerRuleBlock12!=null?((GrammarAST)lexerRuleBlock12.start):null));
			      		currentRuleName=null; currentRuleAST=null;
			      		
			match(input, Token.UP, null); 

			}


				exitLexerRule(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerRule"


	public static class rule_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "rule"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:502:1: rule : ^( RULE RULE_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS (m= ruleModifier )+ ) )? ( ARG_ACTION )? (ret= ruleReturns )? (thr= throwsSpec )? (loc= locals )? (opts= optionsSpec |a= ruleAction )* ruleBlock exceptionGroup ) ;
	public final GrammarTreeVisitor.rule_return rule() throws RecognitionException {
		GrammarTreeVisitor.rule_return retval = new GrammarTreeVisitor.rule_return();
		retval.start = input.LT(1);

		GrammarAST RULE_REF13=null;
		GrammarAST RULE14=null;
		GrammarAST ARG_ACTION15=null;
		TreeRuleReturnScope m =null;
		TreeRuleReturnScope ret =null;
		TreeRuleReturnScope thr =null;
		TreeRuleReturnScope loc =null;
		TreeRuleReturnScope opts =null;
		TreeRuleReturnScope a =null;
		TreeRuleReturnScope ruleBlock16 =null;


			enterRule(((GrammarAST)retval.start));
			List<GrammarAST> mods = new ArrayList<GrammarAST>();
			List<GrammarAST> actions = new ArrayList<GrammarAST>(); // track roots
			currentOuterAltNumber=0;

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:512:2: ( ^( RULE RULE_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS (m= ruleModifier )+ ) )? ( ARG_ACTION )? (ret= ruleReturns )? (thr= throwsSpec )? (loc= locals )? (opts= optionsSpec |a= ruleAction )* ruleBlock exceptionGroup ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:512:6: ^( RULE RULE_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS (m= ruleModifier )+ ) )? ( ARG_ACTION )? (ret= ruleReturns )? (thr= throwsSpec )? (loc= locals )? (opts= optionsSpec |a= ruleAction )* ruleBlock exceptionGroup )
			{
			RULE14=(GrammarAST)match(input,RULE,FOLLOW_RULE_in_rule723); 
			match(input, Token.DOWN, null); 
			RULE_REF13=(GrammarAST)match(input,RULE_REF,FOLLOW_RULE_REF_in_rule725); 
			currentRuleName=(RULE_REF13!=null?RULE_REF13.getText():null); currentRuleAST=RULE14;
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:513:4: ( DOC_COMMENT )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==DOC_COMMENT) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:513:4: DOC_COMMENT
					{
					match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_rule732); 
					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:513:17: ( ^( RULEMODIFIERS (m= ruleModifier )+ ) )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==RULEMODIFIERS) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:513:18: ^( RULEMODIFIERS (m= ruleModifier )+ )
					{
					match(input,RULEMODIFIERS,FOLLOW_RULEMODIFIERS_in_rule737); 
					match(input, Token.DOWN, null); 
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:513:34: (m= ruleModifier )+
					int cnt16=0;
					loop16:
					while (true) {
						int alt16=2;
						int LA16_0 = input.LA(1);
						if ( (LA16_0==FRAGMENT||(LA16_0 >= PRIVATE && LA16_0 <= PUBLIC)) ) {
							alt16=1;
						}

						switch (alt16) {
						case 1 :
							// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:513:35: m= ruleModifier
							{
							pushFollow(FOLLOW_ruleModifier_in_rule742);
							m=ruleModifier();
							state._fsp--;

							mods.add((m!=null?((GrammarAST)m.start):null));
							}
							break;

						default :
							if ( cnt16 >= 1 ) break loop16;
							EarlyExitException eee = new EarlyExitException(16, input);
							throw eee;
						}
						cnt16++;
					}

					match(input, Token.UP, null); 

					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:514:4: ( ARG_ACTION )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==ARG_ACTION) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:514:4: ARG_ACTION
					{
					ARG_ACTION15=(GrammarAST)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_rule753); 
					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:515:12: (ret= ruleReturns )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==RETURNS) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:515:12: ret= ruleReturns
					{
					pushFollow(FOLLOW_ruleReturns_in_rule766);
					ret=ruleReturns();
					state._fsp--;

					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:516:12: (thr= throwsSpec )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==THROWS) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:516:12: thr= throwsSpec
					{
					pushFollow(FOLLOW_throwsSpec_in_rule779);
					thr=throwsSpec();
					state._fsp--;

					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:517:12: (loc= locals )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==LOCALS) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:517:12: loc= locals
					{
					pushFollow(FOLLOW_locals_in_rule792);
					loc=locals();
					state._fsp--;

					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:518:9: (opts= optionsSpec |a= ruleAction )*
			loop22:
			while (true) {
				int alt22=3;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==OPTIONS) ) {
					alt22=1;
				}
				else if ( (LA22_0==AT) ) {
					alt22=2;
				}

				switch (alt22) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:518:11: opts= optionsSpec
					{
					pushFollow(FOLLOW_optionsSpec_in_rule807);
					opts=optionsSpec();
					state._fsp--;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:519:11: a= ruleAction
					{
					pushFollow(FOLLOW_ruleAction_in_rule821);
					a=ruleAction();
					state._fsp--;

					actions.add((a!=null?((GrammarAST)a.start):null));
					}
					break;

				default :
					break loop22;
				}
			}

			discoverRule((RuleAST)RULE14, RULE_REF13, mods, (ActionAST)ARG_ACTION15,
			      					  (ret!=null?((GrammarAST)ret.start):null)!=null?(ActionAST)(ret!=null?((GrammarAST)ret.start):null).getChild(0):null,
			      					  (thr!=null?((GrammarAST)thr.start):null), (opts!=null?((GrammarAST)opts.start):null),
			      					  (loc!=null?((GrammarAST)loc.start):null)!=null?(ActionAST)(loc!=null?((GrammarAST)loc.start):null).getChild(0):null,
			      					  actions, (GrammarAST)input.LT(1));
			pushFollow(FOLLOW_ruleBlock_in_rule852);
			ruleBlock16=ruleBlock();
			state._fsp--;

			pushFollow(FOLLOW_exceptionGroup_in_rule854);
			exceptionGroup();
			state._fsp--;

			finishRule((RuleAST)RULE14, RULE_REF13, (ruleBlock16!=null?((GrammarAST)ruleBlock16.start):null)); currentRuleName=null; currentRuleAST=null;
			match(input, Token.UP, null); 

			}


				exitRule(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rule"


	public static class exceptionGroup_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "exceptionGroup"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:531:1: exceptionGroup : ( exceptionHandler )* ( finallyClause )? ;
	public final GrammarTreeVisitor.exceptionGroup_return exceptionGroup() throws RecognitionException {
		GrammarTreeVisitor.exceptionGroup_return retval = new GrammarTreeVisitor.exceptionGroup_return();
		retval.start = input.LT(1);


			enterExceptionGroup(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:538:5: ( ( exceptionHandler )* ( finallyClause )? )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:538:7: ( exceptionHandler )* ( finallyClause )?
			{
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:538:7: ( exceptionHandler )*
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0==CATCH) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:538:7: exceptionHandler
					{
					pushFollow(FOLLOW_exceptionHandler_in_exceptionGroup901);
					exceptionHandler();
					state._fsp--;

					}
					break;

				default :
					break loop23;
				}
			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:538:25: ( finallyClause )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==FINALLY) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:538:25: finallyClause
					{
					pushFollow(FOLLOW_finallyClause_in_exceptionGroup904);
					finallyClause();
					state._fsp--;

					}
					break;

			}

			}


				exitExceptionGroup(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exceptionGroup"


	public static class exceptionHandler_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "exceptionHandler"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:541:1: exceptionHandler : ^( CATCH ARG_ACTION ACTION ) ;
	public final GrammarTreeVisitor.exceptionHandler_return exceptionHandler() throws RecognitionException {
		GrammarTreeVisitor.exceptionHandler_return retval = new GrammarTreeVisitor.exceptionHandler_return();
		retval.start = input.LT(1);

		GrammarAST ARG_ACTION17=null;
		GrammarAST ACTION18=null;


			enterExceptionHandler(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:548:2: ( ^( CATCH ARG_ACTION ACTION ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:548:4: ^( CATCH ARG_ACTION ACTION )
			{
			match(input,CATCH,FOLLOW_CATCH_in_exceptionHandler930); 
			match(input, Token.DOWN, null); 
			ARG_ACTION17=(GrammarAST)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_exceptionHandler932); 
			ACTION18=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_exceptionHandler934); 
			match(input, Token.UP, null); 

			ruleCatch(ARG_ACTION17, (ActionAST)ACTION18);
			}


				exitExceptionHandler(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exceptionHandler"


	public static class finallyClause_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "finallyClause"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:551:1: finallyClause : ^( FINALLY ACTION ) ;
	public final GrammarTreeVisitor.finallyClause_return finallyClause() throws RecognitionException {
		GrammarTreeVisitor.finallyClause_return retval = new GrammarTreeVisitor.finallyClause_return();
		retval.start = input.LT(1);

		GrammarAST ACTION19=null;


			enterFinallyClause(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:558:2: ( ^( FINALLY ACTION ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:558:4: ^( FINALLY ACTION )
			{
			match(input,FINALLY,FOLLOW_FINALLY_in_finallyClause959); 
			match(input, Token.DOWN, null); 
			ACTION19=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_finallyClause961); 
			match(input, Token.UP, null); 

			finallyAction((ActionAST)ACTION19);
			}


				exitFinallyClause(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "finallyClause"


	public static class locals_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "locals"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:561:1: locals : ^( LOCALS ARG_ACTION ) ;
	public final GrammarTreeVisitor.locals_return locals() throws RecognitionException {
		GrammarTreeVisitor.locals_return retval = new GrammarTreeVisitor.locals_return();
		retval.start = input.LT(1);


			enterLocals(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:568:2: ( ^( LOCALS ARG_ACTION ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:568:4: ^( LOCALS ARG_ACTION )
			{
			match(input,LOCALS,FOLLOW_LOCALS_in_locals989); 
			match(input, Token.DOWN, null); 
			match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_locals991); 
			match(input, Token.UP, null); 

			}


				exitLocals(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "locals"


	public static class ruleReturns_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ruleReturns"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:571:1: ruleReturns : ^( RETURNS ARG_ACTION ) ;
	public final GrammarTreeVisitor.ruleReturns_return ruleReturns() throws RecognitionException {
		GrammarTreeVisitor.ruleReturns_return retval = new GrammarTreeVisitor.ruleReturns_return();
		retval.start = input.LT(1);


			enterRuleReturns(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:578:2: ( ^( RETURNS ARG_ACTION ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:578:4: ^( RETURNS ARG_ACTION )
			{
			match(input,RETURNS,FOLLOW_RETURNS_in_ruleReturns1014); 
			match(input, Token.DOWN, null); 
			match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_ruleReturns1016); 
			match(input, Token.UP, null); 

			}


				exitRuleReturns(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleReturns"


	public static class throwsSpec_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "throwsSpec"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:581:1: throwsSpec : ^( THROWS ( ID )+ ) ;
	public final GrammarTreeVisitor.throwsSpec_return throwsSpec() throws RecognitionException {
		GrammarTreeVisitor.throwsSpec_return retval = new GrammarTreeVisitor.throwsSpec_return();
		retval.start = input.LT(1);


			enterThrowsSpec(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:588:5: ( ^( THROWS ( ID )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:588:7: ^( THROWS ( ID )+ )
			{
			match(input,THROWS,FOLLOW_THROWS_in_throwsSpec1042); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:588:16: ( ID )+
			int cnt25=0;
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( (LA25_0==ID) ) {
					alt25=1;
				}

				switch (alt25) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:588:16: ID
					{
					match(input,ID,FOLLOW_ID_in_throwsSpec1044); 
					}
					break;

				default :
					if ( cnt25 >= 1 ) break loop25;
					EarlyExitException eee = new EarlyExitException(25, input);
					throw eee;
				}
				cnt25++;
			}

			match(input, Token.UP, null); 

			}


				exitThrowsSpec(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "throwsSpec"


	public static class ruleAction_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ruleAction"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:591:1: ruleAction : ^( AT ID ACTION ) ;
	public final GrammarTreeVisitor.ruleAction_return ruleAction() throws RecognitionException {
		GrammarTreeVisitor.ruleAction_return retval = new GrammarTreeVisitor.ruleAction_return();
		retval.start = input.LT(1);


			enterRuleAction(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:598:2: ( ^( AT ID ACTION ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:598:4: ^( AT ID ACTION )
			{
			match(input,AT,FOLLOW_AT_in_ruleAction1071); 
			match(input, Token.DOWN, null); 
			match(input,ID,FOLLOW_ID_in_ruleAction1073); 
			match(input,ACTION,FOLLOW_ACTION_in_ruleAction1075); 
			match(input, Token.UP, null); 

			}


				exitRuleAction(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleAction"


	public static class ruleModifier_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ruleModifier"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:601:1: ruleModifier : ( PUBLIC | PRIVATE | PROTECTED | FRAGMENT );
	public final GrammarTreeVisitor.ruleModifier_return ruleModifier() throws RecognitionException {
		GrammarTreeVisitor.ruleModifier_return retval = new GrammarTreeVisitor.ruleModifier_return();
		retval.start = input.LT(1);


			enterRuleModifier(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:608:5: ( PUBLIC | PRIVATE | PROTECTED | FRAGMENT )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:
			{
			if ( input.LA(1)==FRAGMENT||(input.LA(1) >= PRIVATE && input.LA(1) <= PUBLIC) ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}


				exitRuleModifier(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleModifier"


	public static class lexerRuleBlock_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerRuleBlock"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:614:1: lexerRuleBlock : ^( BLOCK ( lexerOuterAlternative )+ ) ;
	public final GrammarTreeVisitor.lexerRuleBlock_return lexerRuleBlock() throws RecognitionException {
		GrammarTreeVisitor.lexerRuleBlock_return retval = new GrammarTreeVisitor.lexerRuleBlock_return();
		retval.start = input.LT(1);


			enterLexerRuleBlock(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:621:5: ( ^( BLOCK ( lexerOuterAlternative )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:621:7: ^( BLOCK ( lexerOuterAlternative )+ )
			{
			match(input,BLOCK,FOLLOW_BLOCK_in_lexerRuleBlock1153); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:622:7: ( lexerOuterAlternative )+
			int cnt26=0;
			loop26:
			while (true) {
				int alt26=2;
				int LA26_0 = input.LA(1);
				if ( (LA26_0==ALT||LA26_0==LEXER_ALT_ACTION) ) {
					alt26=1;
				}

				switch (alt26) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:622:9: lexerOuterAlternative
					{

					    			currentOuterAltRoot = (GrammarAST)input.LT(1);
									currentOuterAltNumber++;
									
					pushFollow(FOLLOW_lexerOuterAlternative_in_lexerRuleBlock1172);
					lexerOuterAlternative();
					state._fsp--;

					}
					break;

				default :
					if ( cnt26 >= 1 ) break loop26;
					EarlyExitException eee = new EarlyExitException(26, input);
					throw eee;
				}
				cnt26++;
			}

			match(input, Token.UP, null); 

			}


				exitLexerRuleBlock(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerRuleBlock"


	public static class ruleBlock_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ruleBlock"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:631:1: ruleBlock : ^( BLOCK ( outerAlternative )+ ) ;
	public final GrammarTreeVisitor.ruleBlock_return ruleBlock() throws RecognitionException {
		GrammarTreeVisitor.ruleBlock_return retval = new GrammarTreeVisitor.ruleBlock_return();
		retval.start = input.LT(1);


			enterRuleBlock(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:638:5: ( ^( BLOCK ( outerAlternative )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:638:7: ^( BLOCK ( outerAlternative )+ )
			{
			match(input,BLOCK,FOLLOW_BLOCK_in_ruleBlock1217); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:639:7: ( outerAlternative )+
			int cnt27=0;
			loop27:
			while (true) {
				int alt27=2;
				int LA27_0 = input.LA(1);
				if ( (LA27_0==ALT) ) {
					alt27=1;
				}

				switch (alt27) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:639:9: outerAlternative
					{

					    			currentOuterAltRoot = (GrammarAST)input.LT(1);
									currentOuterAltNumber++;
									
					pushFollow(FOLLOW_outerAlternative_in_ruleBlock1236);
					outerAlternative();
					state._fsp--;

					}
					break;

				default :
					if ( cnt27 >= 1 ) break loop27;
					EarlyExitException eee = new EarlyExitException(27, input);
					throw eee;
				}
				cnt27++;
			}

			match(input, Token.UP, null); 

			}


				exitRuleBlock(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleBlock"


	public static class lexerOuterAlternative_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerOuterAlternative"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:648:1: lexerOuterAlternative : lexerAlternative ;
	public final GrammarTreeVisitor.lexerOuterAlternative_return lexerOuterAlternative() throws RecognitionException {
		GrammarTreeVisitor.lexerOuterAlternative_return retval = new GrammarTreeVisitor.lexerOuterAlternative_return();
		retval.start = input.LT(1);


			enterLexerOuterAlternative((AltAST)((GrammarAST)retval.start));
			discoverOuterAlt((AltAST)((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:657:2: ( lexerAlternative )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:657:4: lexerAlternative
			{
			pushFollow(FOLLOW_lexerAlternative_in_lexerOuterAlternative1276);
			lexerAlternative();
			state._fsp--;

			}


				finishOuterAlt((AltAST)((GrammarAST)retval.start));
				exitLexerOuterAlternative((AltAST)((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerOuterAlternative"


	public static class outerAlternative_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "outerAlternative"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:661:1: outerAlternative : alternative ;
	public final GrammarTreeVisitor.outerAlternative_return outerAlternative() throws RecognitionException {
		GrammarTreeVisitor.outerAlternative_return retval = new GrammarTreeVisitor.outerAlternative_return();
		retval.start = input.LT(1);


			enterOuterAlternative((AltAST)((GrammarAST)retval.start));
			discoverOuterAlt((AltAST)((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:670:2: ( alternative )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:670:4: alternative
			{
			pushFollow(FOLLOW_alternative_in_outerAlternative1298);
			alternative();
			state._fsp--;

			}


				finishOuterAlt((AltAST)((GrammarAST)retval.start));
				exitOuterAlternative((AltAST)((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "outerAlternative"


	public static class lexerAlternative_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerAlternative"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:673:1: lexerAlternative : ( ^( LEXER_ALT_ACTION lexerElements ( lexerCommand )+ ) | lexerElements );
	public final GrammarTreeVisitor.lexerAlternative_return lexerAlternative() throws RecognitionException {
		GrammarTreeVisitor.lexerAlternative_return retval = new GrammarTreeVisitor.lexerAlternative_return();
		retval.start = input.LT(1);


			enterLexerAlternative(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:680:2: ( ^( LEXER_ALT_ACTION lexerElements ( lexerCommand )+ ) | lexerElements )
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==LEXER_ALT_ACTION) ) {
				alt29=1;
			}
			else if ( (LA29_0==ALT) ) {
				alt29=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 29, 0, input);
				throw nvae;
			}

			switch (alt29) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:680:4: ^( LEXER_ALT_ACTION lexerElements ( lexerCommand )+ )
					{
					match(input,LEXER_ALT_ACTION,FOLLOW_LEXER_ALT_ACTION_in_lexerAlternative1320); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_lexerElements_in_lexerAlternative1322);
					lexerElements();
					state._fsp--;

					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:680:37: ( lexerCommand )+
					int cnt28=0;
					loop28:
					while (true) {
						int alt28=2;
						int LA28_0 = input.LA(1);
						if ( (LA28_0==ID||LA28_0==LEXER_ACTION_CALL) ) {
							alt28=1;
						}

						switch (alt28) {
						case 1 :
							// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:680:37: lexerCommand
							{
							pushFollow(FOLLOW_lexerCommand_in_lexerAlternative1324);
							lexerCommand();
							state._fsp--;

							}
							break;

						default :
							if ( cnt28 >= 1 ) break loop28;
							EarlyExitException eee = new EarlyExitException(28, input);
							throw eee;
						}
						cnt28++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:681:9: lexerElements
					{
					pushFollow(FOLLOW_lexerElements_in_lexerAlternative1336);
					lexerElements();
					state._fsp--;

					}
					break;

			}

				exitLexerAlternative(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAlternative"


	public static class lexerElements_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerElements"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:684:1: lexerElements : ^( ALT ( lexerElement )+ ) ;
	public final GrammarTreeVisitor.lexerElements_return lexerElements() throws RecognitionException {
		GrammarTreeVisitor.lexerElements_return retval = new GrammarTreeVisitor.lexerElements_return();
		retval.start = input.LT(1);


			enterLexerElements(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:691:5: ( ^( ALT ( lexerElement )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:691:7: ^( ALT ( lexerElement )+ )
			{
			match(input,ALT,FOLLOW_ALT_in_lexerElements1364); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:691:13: ( lexerElement )+
			int cnt30=0;
			loop30:
			while (true) {
				int alt30=2;
				int LA30_0 = input.LA(1);
				if ( (LA30_0==ACTION||LA30_0==ASSIGN||LA30_0==LEXER_CHAR_SET||LA30_0==NOT||LA30_0==PLUS_ASSIGN||LA30_0==RANGE||LA30_0==SEMPRED||LA30_0==STRING_LITERAL||LA30_0==TOKEN_REF||LA30_0==BLOCK||LA30_0==CLOSURE||LA30_0==EPSILON||(LA30_0 >= OPTIONAL && LA30_0 <= POSITIVE_CLOSURE)||LA30_0==SET||LA30_0==WILDCARD) ) {
					alt30=1;
				}

				switch (alt30) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:691:13: lexerElement
					{
					pushFollow(FOLLOW_lexerElement_in_lexerElements1366);
					lexerElement();
					state._fsp--;

					}
					break;

				default :
					if ( cnt30 >= 1 ) break loop30;
					EarlyExitException eee = new EarlyExitException(30, input);
					throw eee;
				}
				cnt30++;
			}

			match(input, Token.UP, null); 

			}


				exitLexerElements(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerElements"


	public static class lexerElement_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerElement"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:694:1: lexerElement : ( labeledLexerElement | lexerAtom | lexerSubrule | ACTION | SEMPRED | ^( ACTION elementOptions ) | ^( SEMPRED elementOptions ) | EPSILON );
	public final GrammarTreeVisitor.lexerElement_return lexerElement() throws RecognitionException {
		GrammarTreeVisitor.lexerElement_return retval = new GrammarTreeVisitor.lexerElement_return();
		retval.start = input.LT(1);

		GrammarAST ACTION20=null;
		GrammarAST SEMPRED21=null;
		GrammarAST ACTION22=null;
		GrammarAST SEMPRED23=null;


			enterLexerElement(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:701:2: ( labeledLexerElement | lexerAtom | lexerSubrule | ACTION | SEMPRED | ^( ACTION elementOptions ) | ^( SEMPRED elementOptions ) | EPSILON )
			int alt31=8;
			switch ( input.LA(1) ) {
			case ASSIGN:
			case PLUS_ASSIGN:
				{
				alt31=1;
				}
				break;
			case LEXER_CHAR_SET:
			case NOT:
			case RANGE:
			case STRING_LITERAL:
			case TOKEN_REF:
			case SET:
			case WILDCARD:
				{
				alt31=2;
				}
				break;
			case BLOCK:
			case CLOSURE:
			case OPTIONAL:
			case POSITIVE_CLOSURE:
				{
				alt31=3;
				}
				break;
			case ACTION:
				{
				int LA31_4 = input.LA(2);
				if ( (LA31_4==DOWN) ) {
					alt31=6;
				}
				else if ( ((LA31_4 >= UP && LA31_4 <= ACTION)||LA31_4==ASSIGN||LA31_4==LEXER_CHAR_SET||LA31_4==NOT||LA31_4==PLUS_ASSIGN||LA31_4==RANGE||LA31_4==SEMPRED||LA31_4==STRING_LITERAL||LA31_4==TOKEN_REF||LA31_4==BLOCK||LA31_4==CLOSURE||LA31_4==EPSILON||(LA31_4 >= OPTIONAL && LA31_4 <= POSITIVE_CLOSURE)||LA31_4==SET||LA31_4==WILDCARD) ) {
					alt31=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 31, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case SEMPRED:
				{
				int LA31_5 = input.LA(2);
				if ( (LA31_5==DOWN) ) {
					alt31=7;
				}
				else if ( ((LA31_5 >= UP && LA31_5 <= ACTION)||LA31_5==ASSIGN||LA31_5==LEXER_CHAR_SET||LA31_5==NOT||LA31_5==PLUS_ASSIGN||LA31_5==RANGE||LA31_5==SEMPRED||LA31_5==STRING_LITERAL||LA31_5==TOKEN_REF||LA31_5==BLOCK||LA31_5==CLOSURE||LA31_5==EPSILON||(LA31_5 >= OPTIONAL && LA31_5 <= POSITIVE_CLOSURE)||LA31_5==SET||LA31_5==WILDCARD) ) {
					alt31=5;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 31, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case EPSILON:
				{
				alt31=8;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}
			switch (alt31) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:701:4: labeledLexerElement
					{
					pushFollow(FOLLOW_labeledLexerElement_in_lexerElement1392);
					labeledLexerElement();
					state._fsp--;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:702:4: lexerAtom
					{
					pushFollow(FOLLOW_lexerAtom_in_lexerElement1397);
					lexerAtom();
					state._fsp--;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:703:4: lexerSubrule
					{
					pushFollow(FOLLOW_lexerSubrule_in_lexerElement1402);
					lexerSubrule();
					state._fsp--;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:704:6: ACTION
					{
					ACTION20=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_lexerElement1409); 
					actionInAlt((ActionAST)ACTION20);
					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:705:6: SEMPRED
					{
					SEMPRED21=(GrammarAST)match(input,SEMPRED,FOLLOW_SEMPRED_in_lexerElement1423); 
					sempredInAlt((PredAST)SEMPRED21);
					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:706:6: ^( ACTION elementOptions )
					{
					ACTION22=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_lexerElement1438); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_lexerElement1440);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					actionInAlt((ActionAST)ACTION22);
					}
					break;
				case 7 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:707:6: ^( SEMPRED elementOptions )
					{
					SEMPRED23=(GrammarAST)match(input,SEMPRED,FOLLOW_SEMPRED_in_lexerElement1451); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_lexerElement1453);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					sempredInAlt((PredAST)SEMPRED23);
					}
					break;
				case 8 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:708:4: EPSILON
					{
					match(input,EPSILON,FOLLOW_EPSILON_in_lexerElement1461); 
					}
					break;

			}

				exitLexerElement(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerElement"


	public static class labeledLexerElement_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "labeledLexerElement"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:711:1: labeledLexerElement : ^( ( ASSIGN | PLUS_ASSIGN ) ID ( lexerAtom | block ) ) ;
	public final GrammarTreeVisitor.labeledLexerElement_return labeledLexerElement() throws RecognitionException {
		GrammarTreeVisitor.labeledLexerElement_return retval = new GrammarTreeVisitor.labeledLexerElement_return();
		retval.start = input.LT(1);


			enterLabeledLexerElement(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:718:5: ( ^( ( ASSIGN | PLUS_ASSIGN ) ID ( lexerAtom | block ) ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:718:9: ^( ( ASSIGN | PLUS_ASSIGN ) ID ( lexerAtom | block ) )
			{
			if ( input.LA(1)==ASSIGN||input.LA(1)==PLUS_ASSIGN ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			match(input, Token.DOWN, null); 
			match(input,ID,FOLLOW_ID_in_labeledLexerElement1494); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:718:35: ( lexerAtom | block )
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==LEXER_CHAR_SET||LA32_0==NOT||LA32_0==RANGE||LA32_0==STRING_LITERAL||LA32_0==TOKEN_REF||LA32_0==SET||LA32_0==WILDCARD) ) {
				alt32=1;
			}
			else if ( (LA32_0==BLOCK) ) {
				alt32=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 32, 0, input);
				throw nvae;
			}

			switch (alt32) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:718:36: lexerAtom
					{
					pushFollow(FOLLOW_lexerAtom_in_labeledLexerElement1497);
					lexerAtom();
					state._fsp--;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:718:46: block
					{
					pushFollow(FOLLOW_block_in_labeledLexerElement1499);
					block();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			}


				exitLabeledLexerElement(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledLexerElement"


	public static class lexerBlock_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerBlock"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:721:1: lexerBlock : ^( BLOCK ( optionsSpec )? ( lexerAlternative )+ ) ;
	public final GrammarTreeVisitor.lexerBlock_return lexerBlock() throws RecognitionException {
		GrammarTreeVisitor.lexerBlock_return retval = new GrammarTreeVisitor.lexerBlock_return();
		retval.start = input.LT(1);


			enterLexerBlock(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:728:3: ( ^( BLOCK ( optionsSpec )? ( lexerAlternative )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:728:5: ^( BLOCK ( optionsSpec )? ( lexerAlternative )+ )
			{
			match(input,BLOCK,FOLLOW_BLOCK_in_lexerBlock1524); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:728:13: ( optionsSpec )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==OPTIONS) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:728:13: optionsSpec
					{
					pushFollow(FOLLOW_optionsSpec_in_lexerBlock1526);
					optionsSpec();
					state._fsp--;

					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:728:26: ( lexerAlternative )+
			int cnt34=0;
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==ALT||LA34_0==LEXER_ALT_ACTION) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:728:26: lexerAlternative
					{
					pushFollow(FOLLOW_lexerAlternative_in_lexerBlock1529);
					lexerAlternative();
					state._fsp--;

					}
					break;

				default :
					if ( cnt34 >= 1 ) break loop34;
					EarlyExitException eee = new EarlyExitException(34, input);
					throw eee;
				}
				cnt34++;
			}

			match(input, Token.UP, null); 

			}


				exitLexerBlock(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerBlock"


	public static class lexerAtom_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerAtom"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:731:1: lexerAtom : ( terminal | ^( NOT blockSet ) | blockSet | ^( WILDCARD elementOptions ) | WILDCARD | LEXER_CHAR_SET | range );
	public final GrammarTreeVisitor.lexerAtom_return lexerAtom() throws RecognitionException {
		GrammarTreeVisitor.lexerAtom_return retval = new GrammarTreeVisitor.lexerAtom_return();
		retval.start = input.LT(1);


			enterLexerAtom(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:738:5: ( terminal | ^( NOT blockSet ) | blockSet | ^( WILDCARD elementOptions ) | WILDCARD | LEXER_CHAR_SET | range )
			int alt35=7;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
			case TOKEN_REF:
				{
				alt35=1;
				}
				break;
			case NOT:
				{
				alt35=2;
				}
				break;
			case SET:
				{
				alt35=3;
				}
				break;
			case WILDCARD:
				{
				int LA35_4 = input.LA(2);
				if ( (LA35_4==DOWN) ) {
					alt35=4;
				}
				else if ( ((LA35_4 >= UP && LA35_4 <= ACTION)||LA35_4==ASSIGN||LA35_4==LEXER_CHAR_SET||LA35_4==NOT||LA35_4==PLUS_ASSIGN||LA35_4==RANGE||LA35_4==SEMPRED||LA35_4==STRING_LITERAL||LA35_4==TOKEN_REF||LA35_4==BLOCK||LA35_4==CLOSURE||LA35_4==EPSILON||(LA35_4 >= OPTIONAL && LA35_4 <= POSITIVE_CLOSURE)||LA35_4==SET||LA35_4==WILDCARD) ) {
					alt35=5;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 35, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case LEXER_CHAR_SET:
				{
				alt35=6;
				}
				break;
			case RANGE:
				{
				alt35=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 35, 0, input);
				throw nvae;
			}
			switch (alt35) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:738:9: terminal
					{
					pushFollow(FOLLOW_terminal_in_lexerAtom1560);
					terminal();
					state._fsp--;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:739:9: ^( NOT blockSet )
					{
					match(input,NOT,FOLLOW_NOT_in_lexerAtom1571); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_blockSet_in_lexerAtom1573);
					blockSet();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:740:9: blockSet
					{
					pushFollow(FOLLOW_blockSet_in_lexerAtom1584);
					blockSet();
					state._fsp--;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:741:9: ^( WILDCARD elementOptions )
					{
					match(input,WILDCARD,FOLLOW_WILDCARD_in_lexerAtom1595); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_lexerAtom1597);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:742:9: WILDCARD
					{
					match(input,WILDCARD,FOLLOW_WILDCARD_in_lexerAtom1608); 
					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:743:7: LEXER_CHAR_SET
					{
					match(input,LEXER_CHAR_SET,FOLLOW_LEXER_CHAR_SET_in_lexerAtom1616); 
					}
					break;
				case 7 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:744:9: range
					{
					pushFollow(FOLLOW_range_in_lexerAtom1626);
					range();
					state._fsp--;

					}
					break;

			}

				exitLexerAtom(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAtom"


	public static class actionElement_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "actionElement"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:747:1: actionElement : ( ACTION | ^( ACTION elementOptions ) | SEMPRED | ^( SEMPRED elementOptions ) );
	public final GrammarTreeVisitor.actionElement_return actionElement() throws RecognitionException {
		GrammarTreeVisitor.actionElement_return retval = new GrammarTreeVisitor.actionElement_return();
		retval.start = input.LT(1);


			enterActionElement(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:754:2: ( ACTION | ^( ACTION elementOptions ) | SEMPRED | ^( SEMPRED elementOptions ) )
			int alt36=4;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==ACTION) ) {
				int LA36_1 = input.LA(2);
				if ( (LA36_1==DOWN) ) {
					alt36=2;
				}
				else if ( (LA36_1==EOF) ) {
					alt36=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA36_0==SEMPRED) ) {
				int LA36_2 = input.LA(2);
				if ( (LA36_2==DOWN) ) {
					alt36=4;
				}
				else if ( (LA36_2==EOF) ) {
					alt36=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 36, 0, input);
				throw nvae;
			}

			switch (alt36) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:754:4: ACTION
					{
					match(input,ACTION,FOLLOW_ACTION_in_actionElement1650); 
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:755:6: ^( ACTION elementOptions )
					{
					match(input,ACTION,FOLLOW_ACTION_in_actionElement1658); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_actionElement1660);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:756:6: SEMPRED
					{
					match(input,SEMPRED,FOLLOW_SEMPRED_in_actionElement1668); 
					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:757:6: ^( SEMPRED elementOptions )
					{
					match(input,SEMPRED,FOLLOW_SEMPRED_in_actionElement1676); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_actionElement1678);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}

				exitActionElement(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "actionElement"


	public static class alternative_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "alternative"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:760:1: alternative : ( ^( ALT ( elementOptions )? ( element )+ ) | ^( ALT EPSILON ) );
	public final GrammarTreeVisitor.alternative_return alternative() throws RecognitionException {
		GrammarTreeVisitor.alternative_return retval = new GrammarTreeVisitor.alternative_return();
		retval.start = input.LT(1);


			enterAlternative((AltAST)((GrammarAST)retval.start));
			discoverAlt((AltAST)((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:769:2: ( ^( ALT ( elementOptions )? ( element )+ ) | ^( ALT EPSILON ) )
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==ALT) ) {
				int LA39_1 = input.LA(2);
				if ( (LA39_1==DOWN) ) {
					int LA39_2 = input.LA(3);
					if ( (LA39_2==EPSILON) ) {
						alt39=2;
					}
					else if ( (LA39_2==ACTION||LA39_2==ASSIGN||LA39_2==DOT||LA39_2==NOT||LA39_2==PLUS_ASSIGN||LA39_2==RULE_REF||LA39_2==SEMPRED||LA39_2==STRING_LITERAL||LA39_2==TOKEN_REF||LA39_2==BLOCK||LA39_2==CLOSURE||LA39_2==ELEMENT_OPTIONS||(LA39_2 >= OPTIONAL && LA39_2 <= POSITIVE_CLOSURE)||LA39_2==SET||LA39_2==WILDCARD) ) {
						alt39=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 39, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 39, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:769:4: ^( ALT ( elementOptions )? ( element )+ )
					{
					match(input,ALT,FOLLOW_ALT_in_alternative1701); 
					match(input, Token.DOWN, null); 
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:769:10: ( elementOptions )?
					int alt37=2;
					int LA37_0 = input.LA(1);
					if ( (LA37_0==ELEMENT_OPTIONS) ) {
						alt37=1;
					}
					switch (alt37) {
						case 1 :
							// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:769:10: elementOptions
							{
							pushFollow(FOLLOW_elementOptions_in_alternative1703);
							elementOptions();
							state._fsp--;

							}
							break;

					}

					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:769:26: ( element )+
					int cnt38=0;
					loop38:
					while (true) {
						int alt38=2;
						int LA38_0 = input.LA(1);
						if ( (LA38_0==ACTION||LA38_0==ASSIGN||LA38_0==DOT||LA38_0==NOT||LA38_0==PLUS_ASSIGN||LA38_0==RULE_REF||LA38_0==SEMPRED||LA38_0==STRING_LITERAL||LA38_0==TOKEN_REF||LA38_0==BLOCK||LA38_0==CLOSURE||(LA38_0 >= OPTIONAL && LA38_0 <= POSITIVE_CLOSURE)||LA38_0==SET||LA38_0==WILDCARD) ) {
							alt38=1;
						}

						switch (alt38) {
						case 1 :
							// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:769:26: element
							{
							pushFollow(FOLLOW_element_in_alternative1706);
							element();
							state._fsp--;

							}
							break;

						default :
							if ( cnt38 >= 1 ) break loop38;
							EarlyExitException eee = new EarlyExitException(38, input);
							throw eee;
						}
						cnt38++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:770:4: ^( ALT EPSILON )
					{
					match(input,ALT,FOLLOW_ALT_in_alternative1714); 
					match(input, Token.DOWN, null); 
					match(input,EPSILON,FOLLOW_EPSILON_in_alternative1716); 
					match(input, Token.UP, null); 

					}
					break;

			}

				finishAlt((AltAST)((GrammarAST)retval.start));
				exitAlternative((AltAST)((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "alternative"


	public static class lexerCommand_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerCommand"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:773:1: lexerCommand : ( ^( LEXER_ACTION_CALL ID lexerCommandExpr ) | ID );
	public final GrammarTreeVisitor.lexerCommand_return lexerCommand() throws RecognitionException {
		GrammarTreeVisitor.lexerCommand_return retval = new GrammarTreeVisitor.lexerCommand_return();
		retval.start = input.LT(1);

		GrammarAST ID24=null;
		GrammarAST ID26=null;
		TreeRuleReturnScope lexerCommandExpr25 =null;


			enterLexerCommand(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:780:2: ( ^( LEXER_ACTION_CALL ID lexerCommandExpr ) | ID )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==LEXER_ACTION_CALL) ) {
				alt40=1;
			}
			else if ( (LA40_0==ID) ) {
				alt40=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:780:4: ^( LEXER_ACTION_CALL ID lexerCommandExpr )
					{
					match(input,LEXER_ACTION_CALL,FOLLOW_LEXER_ACTION_CALL_in_lexerCommand1742); 
					match(input, Token.DOWN, null); 
					ID24=(GrammarAST)match(input,ID,FOLLOW_ID_in_lexerCommand1744); 
					pushFollow(FOLLOW_lexerCommandExpr_in_lexerCommand1746);
					lexerCommandExpr25=lexerCommandExpr();
					state._fsp--;

					match(input, Token.UP, null); 

					lexerCallCommand(currentOuterAltNumber, ID24, (lexerCommandExpr25!=null?((GrammarAST)lexerCommandExpr25.start):null));
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:782:4: ID
					{
					ID26=(GrammarAST)match(input,ID,FOLLOW_ID_in_lexerCommand1762); 
					lexerCommand(currentOuterAltNumber, ID26);
					}
					break;

			}

				exitLexerCommand(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommand"


	public static class lexerCommandExpr_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerCommandExpr"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:786:1: lexerCommandExpr : ( ID | INT );
	public final GrammarTreeVisitor.lexerCommandExpr_return lexerCommandExpr() throws RecognitionException {
		GrammarTreeVisitor.lexerCommandExpr_return retval = new GrammarTreeVisitor.lexerCommandExpr_return();
		retval.start = input.LT(1);


			enterLexerCommandExpr(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:793:2: ( ID | INT )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:
			{
			if ( input.LA(1)==ID||input.LA(1)==INT ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}


				exitLexerCommandExpr(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommandExpr"


	public static class element_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "element"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:797:1: element : ( labeledElement | atom | subrule | ACTION | SEMPRED | ^( ACTION elementOptions ) | ^( SEMPRED elementOptions ) | ^( NOT blockSet ) | ^( NOT block ) );
	public final GrammarTreeVisitor.element_return element() throws RecognitionException {
		GrammarTreeVisitor.element_return retval = new GrammarTreeVisitor.element_return();
		retval.start = input.LT(1);

		GrammarAST ACTION27=null;
		GrammarAST SEMPRED28=null;
		GrammarAST ACTION29=null;
		GrammarAST SEMPRED30=null;


			enterElement(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:804:2: ( labeledElement | atom | subrule | ACTION | SEMPRED | ^( ACTION elementOptions ) | ^( SEMPRED elementOptions ) | ^( NOT blockSet ) | ^( NOT block ) )
			int alt41=9;
			switch ( input.LA(1) ) {
			case ASSIGN:
			case PLUS_ASSIGN:
				{
				alt41=1;
				}
				break;
			case DOT:
			case RULE_REF:
			case STRING_LITERAL:
			case TOKEN_REF:
			case SET:
			case WILDCARD:
				{
				alt41=2;
				}
				break;
			case BLOCK:
			case CLOSURE:
			case OPTIONAL:
			case POSITIVE_CLOSURE:
				{
				alt41=3;
				}
				break;
			case ACTION:
				{
				int LA41_4 = input.LA(2);
				if ( (LA41_4==DOWN) ) {
					alt41=6;
				}
				else if ( ((LA41_4 >= UP && LA41_4 <= ACTION)||LA41_4==ASSIGN||LA41_4==DOT||LA41_4==NOT||LA41_4==PLUS_ASSIGN||LA41_4==RULE_REF||LA41_4==SEMPRED||LA41_4==STRING_LITERAL||LA41_4==TOKEN_REF||LA41_4==BLOCK||LA41_4==CLOSURE||(LA41_4 >= OPTIONAL && LA41_4 <= POSITIVE_CLOSURE)||LA41_4==SET||LA41_4==WILDCARD) ) {
					alt41=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 41, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case SEMPRED:
				{
				int LA41_5 = input.LA(2);
				if ( (LA41_5==DOWN) ) {
					alt41=7;
				}
				else if ( ((LA41_5 >= UP && LA41_5 <= ACTION)||LA41_5==ASSIGN||LA41_5==DOT||LA41_5==NOT||LA41_5==PLUS_ASSIGN||LA41_5==RULE_REF||LA41_5==SEMPRED||LA41_5==STRING_LITERAL||LA41_5==TOKEN_REF||LA41_5==BLOCK||LA41_5==CLOSURE||(LA41_5 >= OPTIONAL && LA41_5 <= POSITIVE_CLOSURE)||LA41_5==SET||LA41_5==WILDCARD) ) {
					alt41=5;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 41, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NOT:
				{
				int LA41_6 = input.LA(2);
				if ( (LA41_6==DOWN) ) {
					int LA41_11 = input.LA(3);
					if ( (LA41_11==SET) ) {
						alt41=8;
					}
					else if ( (LA41_11==BLOCK) ) {
						alt41=9;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 41, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 41, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 41, 0, input);
				throw nvae;
			}
			switch (alt41) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:804:4: labeledElement
					{
					pushFollow(FOLLOW_labeledElement_in_element1819);
					labeledElement();
					state._fsp--;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:805:4: atom
					{
					pushFollow(FOLLOW_atom_in_element1824);
					atom();
					state._fsp--;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:806:4: subrule
					{
					pushFollow(FOLLOW_subrule_in_element1829);
					subrule();
					state._fsp--;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:807:6: ACTION
					{
					ACTION27=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_element1836); 
					actionInAlt((ActionAST)ACTION27);
					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:808:6: SEMPRED
					{
					SEMPRED28=(GrammarAST)match(input,SEMPRED,FOLLOW_SEMPRED_in_element1850); 
					sempredInAlt((PredAST)SEMPRED28);
					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:809:6: ^( ACTION elementOptions )
					{
					ACTION29=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_element1865); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_element1867);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					actionInAlt((ActionAST)ACTION29);
					}
					break;
				case 7 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:810:6: ^( SEMPRED elementOptions )
					{
					SEMPRED30=(GrammarAST)match(input,SEMPRED,FOLLOW_SEMPRED_in_element1878); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_element1880);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					sempredInAlt((PredAST)SEMPRED30);
					}
					break;
				case 8 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:812:4: ^( NOT blockSet )
					{
					match(input,NOT,FOLLOW_NOT_in_element1890); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_blockSet_in_element1892);
					blockSet();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 9 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:813:4: ^( NOT block )
					{
					match(input,NOT,FOLLOW_NOT_in_element1899); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_block_in_element1901);
					block();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}

				exitElement(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "element"


	public static class astOperand_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "astOperand"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:816:1: astOperand : ( atom | ^( NOT blockSet ) | ^( NOT block ) );
	public final GrammarTreeVisitor.astOperand_return astOperand() throws RecognitionException {
		GrammarTreeVisitor.astOperand_return retval = new GrammarTreeVisitor.astOperand_return();
		retval.start = input.LT(1);


			enterAstOperand(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:823:2: ( atom | ^( NOT blockSet ) | ^( NOT block ) )
			int alt42=3;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==DOT||LA42_0==RULE_REF||LA42_0==STRING_LITERAL||LA42_0==TOKEN_REF||LA42_0==SET||LA42_0==WILDCARD) ) {
				alt42=1;
			}
			else if ( (LA42_0==NOT) ) {
				int LA42_2 = input.LA(2);
				if ( (LA42_2==DOWN) ) {
					int LA42_3 = input.LA(3);
					if ( (LA42_3==SET) ) {
						alt42=2;
					}
					else if ( (LA42_3==BLOCK) ) {
						alt42=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 42, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 42, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:823:4: atom
					{
					pushFollow(FOLLOW_atom_in_astOperand1923);
					atom();
					state._fsp--;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:824:4: ^( NOT blockSet )
					{
					match(input,NOT,FOLLOW_NOT_in_astOperand1929); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_blockSet_in_astOperand1931);
					blockSet();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:825:4: ^( NOT block )
					{
					match(input,NOT,FOLLOW_NOT_in_astOperand1938); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_block_in_astOperand1940);
					block();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}

				exitAstOperand(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "astOperand"


	public static class labeledElement_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "labeledElement"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:828:1: labeledElement : ^( ( ASSIGN | PLUS_ASSIGN ) ID element ) ;
	public final GrammarTreeVisitor.labeledElement_return labeledElement() throws RecognitionException {
		GrammarTreeVisitor.labeledElement_return retval = new GrammarTreeVisitor.labeledElement_return();
		retval.start = input.LT(1);

		GrammarAST ID31=null;
		TreeRuleReturnScope element32 =null;


			enterLabeledElement(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:835:2: ( ^( ( ASSIGN | PLUS_ASSIGN ) ID element ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:835:4: ^( ( ASSIGN | PLUS_ASSIGN ) ID element )
			{
			if ( input.LA(1)==ASSIGN||input.LA(1)==PLUS_ASSIGN ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			match(input, Token.DOWN, null); 
			ID31=(GrammarAST)match(input,ID,FOLLOW_ID_in_labeledElement1969); 
			pushFollow(FOLLOW_element_in_labeledElement1971);
			element32=element();
			state._fsp--;

			match(input, Token.UP, null); 

			label(((GrammarAST)retval.start), ID31, (element32!=null?((GrammarAST)element32.start):null));
			}


				exitLabeledElement(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledElement"


	public static class subrule_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "subrule"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:838:1: subrule : ( ^( blockSuffix block ) | block );
	public final GrammarTreeVisitor.subrule_return subrule() throws RecognitionException {
		GrammarTreeVisitor.subrule_return retval = new GrammarTreeVisitor.subrule_return();
		retval.start = input.LT(1);


			enterSubrule(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:845:2: ( ^( blockSuffix block ) | block )
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==CLOSURE||(LA43_0 >= OPTIONAL && LA43_0 <= POSITIVE_CLOSURE)) ) {
				alt43=1;
			}
			else if ( (LA43_0==BLOCK) ) {
				alt43=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 43, 0, input);
				throw nvae;
			}

			switch (alt43) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:845:4: ^( blockSuffix block )
					{
					pushFollow(FOLLOW_blockSuffix_in_subrule1996);
					blockSuffix();
					state._fsp--;

					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_block_in_subrule1998);
					block();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:846:5: block
					{
					pushFollow(FOLLOW_block_in_subrule2005);
					block();
					state._fsp--;

					}
					break;

			}

				exitSubrule(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "subrule"


	public static class lexerSubrule_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "lexerSubrule"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:849:1: lexerSubrule : ( ^( blockSuffix lexerBlock ) | lexerBlock );
	public final GrammarTreeVisitor.lexerSubrule_return lexerSubrule() throws RecognitionException {
		GrammarTreeVisitor.lexerSubrule_return retval = new GrammarTreeVisitor.lexerSubrule_return();
		retval.start = input.LT(1);


			enterLexerSubrule(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:856:2: ( ^( blockSuffix lexerBlock ) | lexerBlock )
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==CLOSURE||(LA44_0 >= OPTIONAL && LA44_0 <= POSITIVE_CLOSURE)) ) {
				alt44=1;
			}
			else if ( (LA44_0==BLOCK) ) {
				alt44=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}

			switch (alt44) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:856:4: ^( blockSuffix lexerBlock )
					{
					pushFollow(FOLLOW_blockSuffix_in_lexerSubrule2030);
					blockSuffix();
					state._fsp--;

					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_lexerBlock_in_lexerSubrule2032);
					lexerBlock();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:857:5: lexerBlock
					{
					pushFollow(FOLLOW_lexerBlock_in_lexerSubrule2039);
					lexerBlock();
					state._fsp--;

					}
					break;

			}

				exitLexerSubrule(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerSubrule"


	public static class blockSuffix_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "blockSuffix"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:860:1: blockSuffix : ebnfSuffix ;
	public final GrammarTreeVisitor.blockSuffix_return blockSuffix() throws RecognitionException {
		GrammarTreeVisitor.blockSuffix_return retval = new GrammarTreeVisitor.blockSuffix_return();
		retval.start = input.LT(1);


			enterBlockSuffix(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:867:5: ( ebnfSuffix )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:867:7: ebnfSuffix
			{
			pushFollow(FOLLOW_ebnfSuffix_in_blockSuffix2066);
			ebnfSuffix();
			state._fsp--;

			}


				exitBlockSuffix(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockSuffix"


	public static class ebnfSuffix_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ebnfSuffix"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:870:1: ebnfSuffix : ( OPTIONAL | CLOSURE | POSITIVE_CLOSURE );
	public final GrammarTreeVisitor.ebnfSuffix_return ebnfSuffix() throws RecognitionException {
		GrammarTreeVisitor.ebnfSuffix_return retval = new GrammarTreeVisitor.ebnfSuffix_return();
		retval.start = input.LT(1);


			enterEbnfSuffix(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:877:2: ( OPTIONAL | CLOSURE | POSITIVE_CLOSURE )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:
			{
			if ( input.LA(1)==CLOSURE||(input.LA(1) >= OPTIONAL && input.LA(1) <= POSITIVE_CLOSURE) ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}


				exitEbnfSuffix(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ebnfSuffix"


	public static class atom_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "atom"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:882:1: atom : ( ^( DOT ID terminal ) | ^( DOT ID ruleref ) | ^( WILDCARD elementOptions ) | WILDCARD | terminal | blockSet | ruleref );
	public final GrammarTreeVisitor.atom_return atom() throws RecognitionException {
		GrammarTreeVisitor.atom_return retval = new GrammarTreeVisitor.atom_return();
		retval.start = input.LT(1);

		GrammarAST WILDCARD33=null;
		GrammarAST WILDCARD34=null;


			enterAtom(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:889:2: ( ^( DOT ID terminal ) | ^( DOT ID ruleref ) | ^( WILDCARD elementOptions ) | WILDCARD | terminal | blockSet | ruleref )
			int alt45=7;
			switch ( input.LA(1) ) {
			case DOT:
				{
				int LA45_1 = input.LA(2);
				if ( (LA45_1==DOWN) ) {
					int LA45_6 = input.LA(3);
					if ( (LA45_6==ID) ) {
						int LA45_9 = input.LA(4);
						if ( (LA45_9==STRING_LITERAL||LA45_9==TOKEN_REF) ) {
							alt45=1;
						}
						else if ( (LA45_9==RULE_REF) ) {
							alt45=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 45, 9, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 45, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 45, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case WILDCARD:
				{
				int LA45_2 = input.LA(2);
				if ( (LA45_2==DOWN) ) {
					alt45=3;
				}
				else if ( (LA45_2==EOF||(LA45_2 >= UP && LA45_2 <= ACTION)||LA45_2==ASSIGN||LA45_2==DOT||LA45_2==NOT||LA45_2==PLUS_ASSIGN||LA45_2==RULE_REF||LA45_2==SEMPRED||LA45_2==STRING_LITERAL||LA45_2==TOKEN_REF||LA45_2==BLOCK||LA45_2==CLOSURE||(LA45_2 >= OPTIONAL && LA45_2 <= POSITIVE_CLOSURE)||LA45_2==SET||LA45_2==WILDCARD) ) {
					alt45=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 45, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case STRING_LITERAL:
			case TOKEN_REF:
				{
				alt45=5;
				}
				break;
			case SET:
				{
				alt45=6;
				}
				break;
			case RULE_REF:
				{
				alt45=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 45, 0, input);
				throw nvae;
			}
			switch (alt45) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:889:4: ^( DOT ID terminal )
					{
					match(input,DOT,FOLLOW_DOT_in_atom2127); 
					match(input, Token.DOWN, null); 
					match(input,ID,FOLLOW_ID_in_atom2129); 
					pushFollow(FOLLOW_terminal_in_atom2131);
					terminal();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:890:4: ^( DOT ID ruleref )
					{
					match(input,DOT,FOLLOW_DOT_in_atom2138); 
					match(input, Token.DOWN, null); 
					match(input,ID,FOLLOW_ID_in_atom2140); 
					pushFollow(FOLLOW_ruleref_in_atom2142);
					ruleref();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:891:7: ^( WILDCARD elementOptions )
					{
					WILDCARD33=(GrammarAST)match(input,WILDCARD,FOLLOW_WILDCARD_in_atom2152); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_atom2154);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					wildcardRef(WILDCARD33);
					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:892:7: WILDCARD
					{
					WILDCARD34=(GrammarAST)match(input,WILDCARD,FOLLOW_WILDCARD_in_atom2165); 
					wildcardRef(WILDCARD34);
					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:893:9: terminal
					{
					pushFollow(FOLLOW_terminal_in_atom2181);
					terminal();
					state._fsp--;

					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:894:7: blockSet
					{
					pushFollow(FOLLOW_blockSet_in_atom2189);
					blockSet();
					state._fsp--;

					}
					break;
				case 7 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:895:9: ruleref
					{
					pushFollow(FOLLOW_ruleref_in_atom2199);
					ruleref();
					state._fsp--;

					}
					break;

			}

				exitAtom(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "atom"


	public static class blockSet_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "blockSet"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:898:1: blockSet : ^( SET ( setElement )+ ) ;
	public final GrammarTreeVisitor.blockSet_return blockSet() throws RecognitionException {
		GrammarTreeVisitor.blockSet_return retval = new GrammarTreeVisitor.blockSet_return();
		retval.start = input.LT(1);


			enterBlockSet(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:905:2: ( ^( SET ( setElement )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:905:4: ^( SET ( setElement )+ )
			{
			match(input,SET,FOLLOW_SET_in_blockSet2224); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:905:10: ( setElement )+
			int cnt46=0;
			loop46:
			while (true) {
				int alt46=2;
				int LA46_0 = input.LA(1);
				if ( (LA46_0==LEXER_CHAR_SET||LA46_0==RANGE||LA46_0==STRING_LITERAL||LA46_0==TOKEN_REF) ) {
					alt46=1;
				}

				switch (alt46) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:905:10: setElement
					{
					pushFollow(FOLLOW_setElement_in_blockSet2226);
					setElement();
					state._fsp--;

					}
					break;

				default :
					if ( cnt46 >= 1 ) break loop46;
					EarlyExitException eee = new EarlyExitException(46, input);
					throw eee;
				}
				cnt46++;
			}

			match(input, Token.UP, null); 

			}


				exitBlockSet(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockSet"


	public static class setElement_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "setElement"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:908:1: setElement : ( STRING_LITERAL | TOKEN_REF | ^( RANGE a= STRING_LITERAL b= STRING_LITERAL ) | LEXER_CHAR_SET );
	public final GrammarTreeVisitor.setElement_return setElement() throws RecognitionException {
		GrammarTreeVisitor.setElement_return retval = new GrammarTreeVisitor.setElement_return();
		retval.start = input.LT(1);

		GrammarAST a=null;
		GrammarAST b=null;
		GrammarAST STRING_LITERAL35=null;
		GrammarAST TOKEN_REF36=null;


			enterSetElement(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:915:2: ( STRING_LITERAL | TOKEN_REF | ^( RANGE a= STRING_LITERAL b= STRING_LITERAL ) | LEXER_CHAR_SET )
			int alt47=4;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt47=1;
				}
				break;
			case TOKEN_REF:
				{
				alt47=2;
				}
				break;
			case RANGE:
				{
				alt47=3;
				}
				break;
			case LEXER_CHAR_SET:
				{
				alt47=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 47, 0, input);
				throw nvae;
			}
			switch (alt47) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:915:4: STRING_LITERAL
					{
					STRING_LITERAL35=(GrammarAST)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_setElement2249); 
					stringRef((TerminalAST)STRING_LITERAL35);
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:916:4: TOKEN_REF
					{
					TOKEN_REF36=(GrammarAST)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_setElement2256); 
					tokenRef((TerminalAST)TOKEN_REF36);
					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:917:4: ^( RANGE a= STRING_LITERAL b= STRING_LITERAL )
					{
					match(input,RANGE,FOLLOW_RANGE_in_setElement2265); 
					match(input, Token.DOWN, null); 
					a=(GrammarAST)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_setElement2269); 
					b=(GrammarAST)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_setElement2273); 
					match(input, Token.UP, null); 


							stringRef((TerminalAST)a);
							stringRef((TerminalAST)b);
							
					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:922:17: LEXER_CHAR_SET
					{
					match(input,LEXER_CHAR_SET,FOLLOW_LEXER_CHAR_SET_in_setElement2296); 
					}
					break;

			}

				exitSetElement(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "setElement"


	public static class block_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "block"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:925:1: block : ^( BLOCK ( optionsSpec )? ( ruleAction )* ( ACTION )? ( alternative )+ ) ;
	public final GrammarTreeVisitor.block_return block() throws RecognitionException {
		GrammarTreeVisitor.block_return retval = new GrammarTreeVisitor.block_return();
		retval.start = input.LT(1);


			enterBlock(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:5: ( ^( BLOCK ( optionsSpec )? ( ruleAction )* ( ACTION )? ( alternative )+ ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:7: ^( BLOCK ( optionsSpec )? ( ruleAction )* ( ACTION )? ( alternative )+ )
			{
			match(input,BLOCK,FOLLOW_BLOCK_in_block2321); 
			match(input, Token.DOWN, null); 
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:15: ( optionsSpec )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==OPTIONS) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:15: optionsSpec
					{
					pushFollow(FOLLOW_optionsSpec_in_block2323);
					optionsSpec();
					state._fsp--;

					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:28: ( ruleAction )*
			loop49:
			while (true) {
				int alt49=2;
				int LA49_0 = input.LA(1);
				if ( (LA49_0==AT) ) {
					alt49=1;
				}

				switch (alt49) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:28: ruleAction
					{
					pushFollow(FOLLOW_ruleAction_in_block2326);
					ruleAction();
					state._fsp--;

					}
					break;

				default :
					break loop49;
				}
			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:40: ( ACTION )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==ACTION) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:40: ACTION
					{
					match(input,ACTION,FOLLOW_ACTION_in_block2329); 
					}
					break;

			}

			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:48: ( alternative )+
			int cnt51=0;
			loop51:
			while (true) {
				int alt51=2;
				int LA51_0 = input.LA(1);
				if ( (LA51_0==ALT) ) {
					alt51=1;
				}

				switch (alt51) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:932:48: alternative
					{
					pushFollow(FOLLOW_alternative_in_block2332);
					alternative();
					state._fsp--;

					}
					break;

				default :
					if ( cnt51 >= 1 ) break loop51;
					EarlyExitException eee = new EarlyExitException(51, input);
					throw eee;
				}
				cnt51++;
			}

			match(input, Token.UP, null); 

			}


				exitBlock(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "block"


	public static class ruleref_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ruleref"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:935:1: ruleref : ^( RULE_REF (arg= ARG_ACTION )? ( elementOptions )? ) ;
	public final GrammarTreeVisitor.ruleref_return ruleref() throws RecognitionException {
		GrammarTreeVisitor.ruleref_return retval = new GrammarTreeVisitor.ruleref_return();
		retval.start = input.LT(1);

		GrammarAST arg=null;
		GrammarAST RULE_REF37=null;


			enterRuleref(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:942:5: ( ^( RULE_REF (arg= ARG_ACTION )? ( elementOptions )? ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:942:7: ^( RULE_REF (arg= ARG_ACTION )? ( elementOptions )? )
			{
			RULE_REF37=(GrammarAST)match(input,RULE_REF,FOLLOW_RULE_REF_in_ruleref2362); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:942:21: (arg= ARG_ACTION )?
				int alt52=2;
				int LA52_0 = input.LA(1);
				if ( (LA52_0==ARG_ACTION) ) {
					alt52=1;
				}
				switch (alt52) {
					case 1 :
						// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:942:21: arg= ARG_ACTION
						{
						arg=(GrammarAST)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_ruleref2366); 
						}
						break;

				}

				// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:942:34: ( elementOptions )?
				int alt53=2;
				int LA53_0 = input.LA(1);
				if ( (LA53_0==ELEMENT_OPTIONS) ) {
					alt53=1;
				}
				switch (alt53) {
					case 1 :
						// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:942:34: elementOptions
						{
						pushFollow(FOLLOW_elementOptions_in_ruleref2369);
						elementOptions();
						state._fsp--;

						}
						break;

				}

				match(input, Token.UP, null); 
			}


			    	ruleRef(RULE_REF37, (ActionAST)arg);
			    	if ( arg!=null ) actionInAlt((ActionAST)arg);
			    	
			}


				exitRuleref(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleref"


	public static class range_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "range"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:949:1: range : ^( RANGE STRING_LITERAL STRING_LITERAL ) ;
	public final GrammarTreeVisitor.range_return range() throws RecognitionException {
		GrammarTreeVisitor.range_return retval = new GrammarTreeVisitor.range_return();
		retval.start = input.LT(1);


			enterRange(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:956:5: ( ^( RANGE STRING_LITERAL STRING_LITERAL ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:956:7: ^( RANGE STRING_LITERAL STRING_LITERAL )
			{
			match(input,RANGE,FOLLOW_RANGE_in_range2406); 
			match(input, Token.DOWN, null); 
			match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_range2408); 
			match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_range2410); 
			match(input, Token.UP, null); 

			}


				exitRange(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "range"


	public static class terminal_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "terminal"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:959:1: terminal : ( ^( STRING_LITERAL elementOptions ) | STRING_LITERAL | ^( TOKEN_REF elementOptions ) | TOKEN_REF );
	public final GrammarTreeVisitor.terminal_return terminal() throws RecognitionException {
		GrammarTreeVisitor.terminal_return retval = new GrammarTreeVisitor.terminal_return();
		retval.start = input.LT(1);

		GrammarAST STRING_LITERAL38=null;
		GrammarAST STRING_LITERAL39=null;
		GrammarAST TOKEN_REF40=null;
		GrammarAST TOKEN_REF41=null;


			enterTerminal(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:966:5: ( ^( STRING_LITERAL elementOptions ) | STRING_LITERAL | ^( TOKEN_REF elementOptions ) | TOKEN_REF )
			int alt54=4;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==STRING_LITERAL) ) {
				int LA54_1 = input.LA(2);
				if ( (LA54_1==DOWN) ) {
					alt54=1;
				}
				else if ( (LA54_1==EOF||(LA54_1 >= UP && LA54_1 <= ACTION)||LA54_1==ASSIGN||LA54_1==DOT||LA54_1==LEXER_CHAR_SET||LA54_1==NOT||LA54_1==PLUS_ASSIGN||LA54_1==RANGE||LA54_1==RULE_REF||LA54_1==SEMPRED||LA54_1==STRING_LITERAL||LA54_1==TOKEN_REF||LA54_1==BLOCK||LA54_1==CLOSURE||LA54_1==EPSILON||(LA54_1 >= OPTIONAL && LA54_1 <= POSITIVE_CLOSURE)||LA54_1==SET||LA54_1==WILDCARD) ) {
					alt54=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 54, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA54_0==TOKEN_REF) ) {
				int LA54_2 = input.LA(2);
				if ( (LA54_2==DOWN) ) {
					alt54=3;
				}
				else if ( (LA54_2==EOF||(LA54_2 >= UP && LA54_2 <= ACTION)||LA54_2==ASSIGN||LA54_2==DOT||LA54_2==LEXER_CHAR_SET||LA54_2==NOT||LA54_2==PLUS_ASSIGN||LA54_2==RANGE||LA54_2==RULE_REF||LA54_2==SEMPRED||LA54_2==STRING_LITERAL||LA54_2==TOKEN_REF||LA54_2==BLOCK||LA54_2==CLOSURE||LA54_2==EPSILON||(LA54_2 >= OPTIONAL && LA54_2 <= POSITIVE_CLOSURE)||LA54_2==SET||LA54_2==WILDCARD) ) {
					alt54=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 54, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 54, 0, input);
				throw nvae;
			}

			switch (alt54) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:966:8: ^( STRING_LITERAL elementOptions )
					{
					STRING_LITERAL38=(GrammarAST)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_terminal2440); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_terminal2442);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					stringRef((TerminalAST)STRING_LITERAL38);
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:968:7: STRING_LITERAL
					{
					STRING_LITERAL39=(GrammarAST)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_terminal2465); 
					stringRef((TerminalAST)STRING_LITERAL39);
					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:969:7: ^( TOKEN_REF elementOptions )
					{
					TOKEN_REF40=(GrammarAST)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_terminal2479); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_elementOptions_in_terminal2481);
					elementOptions();
					state._fsp--;

					match(input, Token.UP, null); 

					tokenRef((TerminalAST)TOKEN_REF40);
					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:970:7: TOKEN_REF
					{
					TOKEN_REF41=(GrammarAST)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_terminal2492); 
					tokenRef((TerminalAST)TOKEN_REF41);
					}
					break;

			}

				exitTerminal(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "terminal"


	public static class elementOptions_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "elementOptions"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:973:1: elementOptions : ^( ELEMENT_OPTIONS ( elementOption[(GrammarASTWithOptions)$start.getParent()] )* ) ;
	public final GrammarTreeVisitor.elementOptions_return elementOptions() throws RecognitionException {
		GrammarTreeVisitor.elementOptions_return retval = new GrammarTreeVisitor.elementOptions_return();
		retval.start = input.LT(1);


			enterElementOptions(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:980:5: ( ^( ELEMENT_OPTIONS ( elementOption[(GrammarASTWithOptions)$start.getParent()] )* ) )
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:980:7: ^( ELEMENT_OPTIONS ( elementOption[(GrammarASTWithOptions)$start.getParent()] )* )
			{
			match(input,ELEMENT_OPTIONS,FOLLOW_ELEMENT_OPTIONS_in_elementOptions2529); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:980:25: ( elementOption[(GrammarASTWithOptions)$start.getParent()] )*
				loop55:
				while (true) {
					int alt55=2;
					int LA55_0 = input.LA(1);
					if ( (LA55_0==ASSIGN||LA55_0==ID) ) {
						alt55=1;
					}

					switch (alt55) {
					case 1 :
						// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:980:25: elementOption[(GrammarASTWithOptions)$start.getParent()]
						{
						pushFollow(FOLLOW_elementOption_in_elementOptions2531);
						elementOption((GrammarASTWithOptions)((GrammarAST)retval.start).getParent());
						state._fsp--;

						}
						break;

					default :
						break loop55;
					}
				}

				match(input, Token.UP, null); 
			}

			}


				exitElementOptions(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementOptions"


	public static class elementOption_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "elementOption"
	// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:983:1: elementOption[GrammarASTWithOptions t] : ( ID | ^( ASSIGN id= ID v= ID ) | ^( ASSIGN ID v= STRING_LITERAL ) | ^( ASSIGN ID v= ACTION ) | ^( ASSIGN ID v= INT ) );
	public final GrammarTreeVisitor.elementOption_return elementOption(GrammarASTWithOptions t) throws RecognitionException {
		GrammarTreeVisitor.elementOption_return retval = new GrammarTreeVisitor.elementOption_return();
		retval.start = input.LT(1);

		GrammarAST id=null;
		GrammarAST v=null;
		GrammarAST ID42=null;
		GrammarAST ID43=null;
		GrammarAST ID44=null;
		GrammarAST ID45=null;


			enterElementOption(((GrammarAST)retval.start));

		try {
			// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:990:5: ( ID | ^( ASSIGN id= ID v= ID ) | ^( ASSIGN ID v= STRING_LITERAL ) | ^( ASSIGN ID v= ACTION ) | ^( ASSIGN ID v= INT ) )
			int alt56=5;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==ID) ) {
				alt56=1;
			}
			else if ( (LA56_0==ASSIGN) ) {
				int LA56_2 = input.LA(2);
				if ( (LA56_2==DOWN) ) {
					int LA56_3 = input.LA(3);
					if ( (LA56_3==ID) ) {
						switch ( input.LA(4) ) {
						case ID:
							{
							alt56=2;
							}
							break;
						case STRING_LITERAL:
							{
							alt56=3;
							}
							break;
						case ACTION:
							{
							alt56=4;
							}
							break;
						case INT:
							{
							alt56=5;
							}
							break;
						default:
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 56, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 56, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 56, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 56, 0, input);
				throw nvae;
			}

			switch (alt56) {
				case 1 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:990:7: ID
					{
					ID42=(GrammarAST)match(input,ID,FOLLOW_ID_in_elementOption2562); 
					elementOption(t, ID42, null);
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:991:9: ^( ASSIGN id= ID v= ID )
					{
					match(input,ASSIGN,FOLLOW_ASSIGN_in_elementOption2582); 
					match(input, Token.DOWN, null); 
					id=(GrammarAST)match(input,ID,FOLLOW_ID_in_elementOption2586); 
					v=(GrammarAST)match(input,ID,FOLLOW_ID_in_elementOption2590); 
					match(input, Token.UP, null); 

					elementOption(t, id, v);
					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:992:9: ^( ASSIGN ID v= STRING_LITERAL )
					{
					match(input,ASSIGN,FOLLOW_ASSIGN_in_elementOption2606); 
					match(input, Token.DOWN, null); 
					ID43=(GrammarAST)match(input,ID,FOLLOW_ID_in_elementOption2608); 
					v=(GrammarAST)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_elementOption2612); 
					match(input, Token.UP, null); 

					elementOption(t, ID43, v);
					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:993:9: ^( ASSIGN ID v= ACTION )
					{
					match(input,ASSIGN,FOLLOW_ASSIGN_in_elementOption2626); 
					match(input, Token.DOWN, null); 
					ID44=(GrammarAST)match(input,ID,FOLLOW_ID_in_elementOption2628); 
					v=(GrammarAST)match(input,ACTION,FOLLOW_ACTION_in_elementOption2632); 
					match(input, Token.UP, null); 

					elementOption(t, ID44, v);
					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\GrammarTreeVisitor.g:994:9: ^( ASSIGN ID v= INT )
					{
					match(input,ASSIGN,FOLLOW_ASSIGN_in_elementOption2648); 
					match(input, Token.DOWN, null); 
					ID45=(GrammarAST)match(input,ID,FOLLOW_ID_in_elementOption2650); 
					v=(GrammarAST)match(input,INT,FOLLOW_INT_in_elementOption2654); 
					match(input, Token.UP, null); 

					elementOption(t, ID45, v);
					}
					break;

			}

				exitElementOption(((GrammarAST)retval.start));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementOption"

	// Delegated rules



	public static final BitSet FOLLOW_GRAMMAR_in_grammarSpec85 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_grammarSpec87 = new BitSet(new long[]{0x0000020010020800L,0x0000000080000001L});
	public static final BitSet FOLLOW_DOC_COMMENT_in_grammarSpec91 = new BitSet(new long[]{0x0000020010000800L,0x0000000080000001L});
	public static final BitSet FOLLOW_prequelConstructs_in_grammarSpec109 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_rules_in_grammarSpec126 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_mode_in_grammarSpec128 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_prequelConstruct_in_prequelConstructs170 = new BitSet(new long[]{0x0000020010000802L,0x0000000000000001L});
	public static final BitSet FOLLOW_optionsSpec_in_prequelConstruct197 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delegateGrammars_in_prequelConstruct207 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tokensSpec_in_prequelConstruct217 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_action_in_prequelConstruct227 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONS_in_optionsSpec252 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_option_in_optionsSpec254 = new BitSet(new long[]{0x0000000000000408L});
	public static final BitSet FOLLOW_ASSIGN_in_option288 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_option290 = new BitSet(new long[]{0x2000000028000000L});
	public static final BitSet FOLLOW_optionValue_in_option294 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IMPORT_in_delegateGrammars382 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_delegateGrammar_in_delegateGrammars384 = new BitSet(new long[]{0x0000000008000408L});
	public static final BitSet FOLLOW_ASSIGN_in_delegateGrammar413 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_delegateGrammar417 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_ID_in_delegateGrammar421 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ID_in_delegateGrammar436 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKENS_SPEC_in_tokensSpec470 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_tokenSpec_in_tokensSpec472 = new BitSet(new long[]{0x0000000008000008L});
	public static final BitSet FOLLOW_ID_in_tokenSpec495 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_action523 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_action527 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_ID_in_action532 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_action534 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RULES_in_rules562 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_rule_in_rules567 = new BitSet(new long[]{0x0000000000000008L,0x0000000010000000L});
	public static final BitSet FOLLOW_lexerRule_in_rules569 = new BitSet(new long[]{0x0000000000000008L,0x0000000010000000L});
	public static final BitSet FOLLOW_MODE_in_mode600 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_mode602 = new BitSet(new long[]{0x0000000000000008L,0x0000000010000000L});
	public static final BitSet FOLLOW_lexerRule_in_mode606 = new BitSet(new long[]{0x0000000000000008L,0x0000000010000000L});
	public static final BitSet FOLLOW_RULE_in_lexerRule632 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_TOKEN_REF_in_lexerRule634 = new BitSet(new long[]{0x0000000000020000L,0x0000000040001000L});
	public static final BitSet FOLLOW_DOC_COMMENT_in_lexerRule644 = new BitSet(new long[]{0x0000000000000000L,0x0000000040001000L});
	public static final BitSet FOLLOW_RULEMODIFIERS_in_lexerRule649 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FRAGMENT_in_lexerRule653 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_lexerRuleBlock_in_lexerRule678 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RULE_in_rule723 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_RULE_REF_in_rule725 = new BitSet(new long[]{0x8040020100020900L,0x0000000040001000L});
	public static final BitSet FOLLOW_DOC_COMMENT_in_rule732 = new BitSet(new long[]{0x8040020100000900L,0x0000000040001000L});
	public static final BitSet FOLLOW_RULEMODIFIERS_in_rule737 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ruleModifier_in_rule742 = new BitSet(new long[]{0x0003800000800008L});
	public static final BitSet FOLLOW_ARG_ACTION_in_rule753 = new BitSet(new long[]{0x8040020100000800L,0x0000000000001000L});
	public static final BitSet FOLLOW_ruleReturns_in_rule766 = new BitSet(new long[]{0x8000020100000800L,0x0000000000001000L});
	public static final BitSet FOLLOW_throwsSpec_in_rule779 = new BitSet(new long[]{0x0000020100000800L,0x0000000000001000L});
	public static final BitSet FOLLOW_locals_in_rule792 = new BitSet(new long[]{0x0000020000000800L,0x0000000000001000L});
	public static final BitSet FOLLOW_optionsSpec_in_rule807 = new BitSet(new long[]{0x0000020000000800L,0x0000000000001000L});
	public static final BitSet FOLLOW_ruleAction_in_rule821 = new BitSet(new long[]{0x0000020000000800L,0x0000000000001000L});
	public static final BitSet FOLLOW_ruleBlock_in_rule852 = new BitSet(new long[]{0x0000000000401008L});
	public static final BitSet FOLLOW_exceptionGroup_in_rule854 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_exceptionHandler_in_exceptionGroup901 = new BitSet(new long[]{0x0000000000401002L});
	public static final BitSet FOLLOW_finallyClause_in_exceptionGroup904 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CATCH_in_exceptionHandler930 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARG_ACTION_in_exceptionHandler932 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_exceptionHandler934 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FINALLY_in_finallyClause959 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ACTION_in_finallyClause961 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LOCALS_in_locals989 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARG_ACTION_in_locals991 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RETURNS_in_ruleReturns1014 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARG_ACTION_in_ruleReturns1016 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_THROWS_in_throwsSpec1042 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_throwsSpec1044 = new BitSet(new long[]{0x0000000008000008L});
	public static final BitSet FOLLOW_AT_in_ruleAction1071 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_ruleAction1073 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_ruleAction1075 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BLOCK_in_lexerRuleBlock1153 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_lexerOuterAlternative_in_lexerRuleBlock1172 = new BitSet(new long[]{0x0000000000000008L,0x0000000000200100L});
	public static final BitSet FOLLOW_BLOCK_in_ruleBlock1217 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_outerAlternative_in_ruleBlock1236 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000100L});
	public static final BitSet FOLLOW_lexerAlternative_in_lexerOuterAlternative1276 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alternative_in_outerAlternative1298 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_ALT_ACTION_in_lexerAlternative1320 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_lexerElements_in_lexerAlternative1322 = new BitSet(new long[]{0x0000000008000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_lexerCommand_in_lexerAlternative1324 = new BitSet(new long[]{0x0000000008000008L,0x0000000000100000L});
	public static final BitSet FOLLOW_lexerElements_in_lexerAlternative1336 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALT_in_lexerElements1364 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_lexerElement_in_lexerElements1366 = new BitSet(new long[]{0x2408204080000418L,0x0000000501825002L});
	public static final BitSet FOLLOW_labeledLexerElement_in_lexerElement1392 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAtom_in_lexerElement1397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerSubrule_in_lexerElement1402 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_lexerElement1409 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMPRED_in_lexerElement1423 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_lexerElement1438 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_lexerElement1440 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SEMPRED_in_lexerElement1451 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_lexerElement1453 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EPSILON_in_lexerElement1461 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_labeledLexerElement1488 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_labeledLexerElement1494 = new BitSet(new long[]{0x2008004080000000L,0x0000000500001002L});
	public static final BitSet FOLLOW_lexerAtom_in_labeledLexerElement1497 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_block_in_labeledLexerElement1499 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BLOCK_in_lexerBlock1524 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_optionsSpec_in_lexerBlock1526 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200100L});
	public static final BitSet FOLLOW_lexerAlternative_in_lexerBlock1529 = new BitSet(new long[]{0x0000000000000008L,0x0000000000200100L});
	public static final BitSet FOLLOW_terminal_in_lexerAtom1560 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_lexerAtom1571 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_blockSet_in_lexerAtom1573 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_blockSet_in_lexerAtom1584 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WILDCARD_in_lexerAtom1595 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_lexerAtom1597 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WILDCARD_in_lexerAtom1608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_CHAR_SET_in_lexerAtom1616 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_range_in_lexerAtom1626 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_actionElement1650 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_actionElement1658 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_actionElement1660 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SEMPRED_in_actionElement1668 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMPRED_in_actionElement1676 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_actionElement1678 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ALT_in_alternative1701 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_alternative1703 = new BitSet(new long[]{0x2500204000080410L,0x0000000501805002L});
	public static final BitSet FOLLOW_element_in_alternative1706 = new BitSet(new long[]{0x2500204000080418L,0x0000000501805002L});
	public static final BitSet FOLLOW_ALT_in_alternative1714 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_EPSILON_in_alternative1716 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LEXER_ACTION_CALL_in_lexerCommand1742 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_lexerCommand1744 = new BitSet(new long[]{0x0000000028000000L});
	public static final BitSet FOLLOW_lexerCommandExpr_in_lexerCommand1746 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ID_in_lexerCommand1762 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_labeledElement_in_element1819 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atom_in_element1824 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subrule_in_element1829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_element1836 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMPRED_in_element1850 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_element1865 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_element1867 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SEMPRED_in_element1878 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_element1880 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_in_element1890 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_blockSet_in_element1892 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_in_element1899 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_block_in_element1901 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_atom_in_astOperand1923 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_astOperand1929 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_blockSet_in_astOperand1931 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_in_astOperand1938 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_block_in_astOperand1940 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_set_in_labeledElement1963 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_labeledElement1969 = new BitSet(new long[]{0x2500204000080410L,0x0000000501805002L});
	public static final BitSet FOLLOW_element_in_labeledElement1971 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_blockSuffix_in_subrule1996 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_block_in_subrule1998 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_block_in_subrule2005 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blockSuffix_in_lexerSubrule2030 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_lexerBlock_in_lexerSubrule2032 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_lexerBlock_in_lexerSubrule2039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_blockSuffix2066 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_atom2127 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_atom2129 = new BitSet(new long[]{0x2000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_terminal_in_atom2131 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DOT_in_atom2138 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_atom2140 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_ruleref_in_atom2142 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WILDCARD_in_atom2152 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_atom2154 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WILDCARD_in_atom2165 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_terminal_in_atom2181 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blockSet_in_atom2189 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ruleref_in_atom2199 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_blockSet2224 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_setElement_in_blockSet2226 = new BitSet(new long[]{0x2008000080000008L,0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_setElement2249 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_setElement2256 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RANGE_in_setElement2265 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_setElement2269 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_setElement2273 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LEXER_CHAR_SET_in_setElement2296 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLOCK_in_block2321 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_optionsSpec_in_block2323 = new BitSet(new long[]{0x0000000000000810L,0x0000000000000100L});
	public static final BitSet FOLLOW_ruleAction_in_block2326 = new BitSet(new long[]{0x0000000000000810L,0x0000000000000100L});
	public static final BitSet FOLLOW_ACTION_in_block2329 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_alternative_in_block2332 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000100L});
	public static final BitSet FOLLOW_RULE_REF_in_ruleref2362 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARG_ACTION_in_ruleref2366 = new BitSet(new long[]{0x0000000000000008L,0x0000000000010000L});
	public static final BitSet FOLLOW_elementOptions_in_ruleref2369 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RANGE_in_range2406 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_range2408 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_range2410 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_terminal2440 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_terminal2442 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_terminal2465 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_terminal2479 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOptions_in_terminal2481 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TOKEN_REF_in_terminal2492 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ELEMENT_OPTIONS_in_elementOptions2529 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_elementOption_in_elementOptions2531 = new BitSet(new long[]{0x0000000008000408L});
	public static final BitSet FOLLOW_ID_in_elementOption2562 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASSIGN_in_elementOption2582 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_elementOption2586 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_ID_in_elementOption2590 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASSIGN_in_elementOption2606 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_elementOption2608 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_elementOption2612 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASSIGN_in_elementOption2626 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_elementOption2628 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_elementOption2632 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASSIGN_in_elementOption2648 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_elementOption2650 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_INT_in_elementOption2654 = new BitSet(new long[]{0x0000000000000008L});
}
