/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.gunit.swingui.model.Rule;
import org.antlr.gunit.swingui.model.TestSuite;
import org.antlr.gunit.swingui.parsers.ANTLRv3Lexer;
import org.antlr.gunit.swingui.parsers.ANTLRv3Parser;
import org.antlr.gunit.swingui.parsers.StGUnitLexer;
import org.antlr.gunit.swingui.parsers.StGUnitParser;
import org.antlr.gunit.swingui.runner.TestSuiteAdapter;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class TestSuiteFactory {
    private static String TEMPLATE_FILE = "org/antlr/gunit/swingui/gunit.stg";
    private static StringTemplateGroup templates;
    public static final String TEST_SUITE_EXT = ".gunit";
    public static final String GRAMMAR_EXT = ".g";

    static {
        ClassLoader loader = TestSuiteFactory.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(TEMPLATE_FILE);
        if (in == null) {
            throw new RuntimeException("internal error: Can't find templates " + TEMPLATE_FILE);
        }
        InputStreamReader rd = new InputStreamReader(in);
        templates = new StringTemplateGroup((Reader)rd);
    }

    public static TestSuite createTestSuite(File grammarFile) {
        if (grammarFile != null && grammarFile.exists() && grammarFile.isFile()) {
            String fileName = grammarFile.getName();
            String grammarName = fileName.substring(0, fileName.lastIndexOf(46));
            String grammarDir = grammarFile.getParent();
            File testFile = new File(String.valueOf(grammarDir) + File.separator + grammarName + TEST_SUITE_EXT);
            TestSuite result = new TestSuite(grammarName, testFile);
            result.rules = TestSuiteFactory.loadRulesFromGrammar(grammarFile);
            if (TestSuiteFactory.saveTestSuite(result)) {
                return result;
            }
            throw new RuntimeException("Can't save test suite file.");
        }
        throw new RuntimeException("Invalid grammar file.");
    }

    private static List<Rule> loadRulesFromGrammar(File grammarFile) {
        ArrayList<String> ruleNames = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(grammarFile));
            ANTLRv3Lexer lexer = new ANTLRv3Lexer((CharStream)new ANTLRReaderStream((Reader)reader));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            ANTLRv3Parser parser = new ANTLRv3Parser((TokenStream)tokens);
            parser.rules = ruleNames;
            parser.grammarDef();
            ((Reader)reader).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (String str : ruleNames) {
            ruleList.add(new Rule(str));
        }
        return ruleList;
    }

    public static boolean saveTestSuite(TestSuite testSuite) {
        String data = TestSuiteFactory.getScript(testSuite);
        try {
            FileWriter fw = new FileWriter(testSuite.getTestSuiteFile());
            fw.write(data);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getScript(TestSuite testSuite) {
        if (testSuite == null) {
            return null;
        }
        StringTemplate gUnitScript = templates.getInstanceOf("gUnitFile");
        gUnitScript.setAttribute("testSuite", (Object)testSuite);
        return gUnitScript.toString();
    }

    public static TestSuite loadTestSuite(File file) {
        if (file.getName().endsWith(GRAMMAR_EXT)) {
            throw new RuntimeException(String.valueOf(file.getName()) + " is a grammar file not a gunit file");
        }
        File grammarFile = TestSuiteFactory.getGrammarFile(file);
        if (grammarFile == null) {
            throw new RuntimeException("Can't find grammar file associated with gunit file: " + file.getAbsoluteFile());
        }
        TestSuite result = new TestSuite("", file);
        try {
            TestSuiteAdapter adapter;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StGUnitLexer lexer = new StGUnitLexer((CharStream)new ANTLRReaderStream((Reader)reader));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            StGUnitParser parser = new StGUnitParser((TokenStream)tokens);
            parser.adapter = adapter = new TestSuiteAdapter(result);
            parser.gUnitDef();
            result.setTokens(tokens);
            ((Reader)reader).close();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error reading test suite file.\n" + ex.getMessage());
        }
        List<Rule> completeRuleList = TestSuiteFactory.loadRulesFromGrammar(grammarFile);
        for (Rule rule : completeRuleList) {
            if (result.hasRule(rule)) continue;
            result.addRule(rule);
        }
        return result;
    }

    private static File getGrammarFile(File testsuiteFile) {
        String sTestFile;
        try {
            sTestFile = testsuiteFile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        String fname = String.valueOf(sTestFile.substring(0, sTestFile.lastIndexOf(46))) + GRAMMAR_EXT;
        File fileGrammar = new File(fname);
        if (fileGrammar.exists() && fileGrammar.isFile()) {
            return fileGrammar;
        }
        fname = String.valueOf(sTestFile.substring(0, sTestFile.lastIndexOf(46))) + "Parser" + GRAMMAR_EXT;
        if (fileGrammar.exists() && fileGrammar.isFile()) {
            return fileGrammar;
        }
        return fileGrammar;
    }
}

