/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antora.maven.FrontendMojoExecutor;
import org.antora.maven.NodeVersionResolver;
import org.antora.maven.PlaybookProvider;
import org.antora.maven.ProvidedPlaybookRetriever;
import org.antora.maven.SystemNodeLinker;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="antora", defaultPhase=LifecyclePhase.NONE, requiresOnline=true)
public class AntoraMavenPlugin
extends AbstractMojo {
    private static final String ANTORA_PACKAGE_NAME = "antora";
    private static final String ANTORA_CLI_PACKAGE_NAME = "@antora/cli";
    private static final String ANTORA_COMMAND_NAME = "antora";
    private static final String PACKAGE_FILE = "package.json";
    private static final String PACKAGE_LOCK_FILE = "package-lock.json";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(alias="env")
    private Map<String, String> environmentVariables;
    @Parameter(property="node.executable")
    private String nodeExecutable;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File nodeInstallDirectory;
    @Parameter
    private String nodeVersion;
    @Parameter
    private List<String> options;
    @Parameter
    private List<String> packages;
    @Parameter(defaultValue="antora-playbook.yml", property="antora.playbook", required=true)
    private File playbook;
    @Parameter
    private PlaybookProvider playbookProvider;
    @Parameter(defaultValue="latest")
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String playbookArgument;
        this.validate();
        File basedir = this.mavenProject.getBasedir();
        File nodeHomeDir = new File(this.nodeInstallDirectory, "node");
        File npmCacheDir = null;
        FrontendMojoExecutor frontendMojoExecutor = new FrontendMojoExecutor(this.pluginManager, this.mavenSession, MojoExecutor.element((String)"installDirectory", (String)this.nodeInstallDirectory.getPath()));
        SystemNodeLinker systemNodeLinker = new SystemNodeLinker(this.getLog(), nodeHomeDir);
        if (this.nodeExecutable == null) {
            systemNodeLinker.unlinkNode();
            frontendMojoExecutor.executeMojo("install-node-and-npm", MojoExecutor.element((String)"nodeVersion", (String)new NodeVersionResolver(this.getLog()).resolveVersion(this.nodeVersion)));
            npmCacheDir = new File(nodeHomeDir, "_npm");
        } else {
            systemNodeLinker.linkNode(this.nodeExecutable);
        }
        ArrayList<String> allPackages = new ArrayList<String>();
        if (this.playbookProvider == null) {
            playbookArgument = basedir.toPath().relativize(this.playbook.toPath()).toString();
            if (this.packageFileExistsWithDependencies(new File(basedir, PACKAGE_FILE))) {
                String antoraCommandName;
                boolean hasPackageLockFile = new File(basedir, PACKAGE_LOCK_FILE).exists();
                frontendMojoExecutor.executeMojo("npm", MojoExecutor.element((String)"arguments", (String)(hasPackageLockFile ? "ci" : "i")), MojoExecutor.element((String)"environmentVariables", (MojoExecutor.Element[])this.npmInstallEnvironmentVariables(hasPackageLockFile, npmCacheDir)));
                String string = antoraCommandName = this.isWindows() ? "antora.cmd" : "antora";
                if (!Paths.get(basedir.getPath(), "node_modules", ".bin", antoraCommandName).toFile().exists()) {
                    allPackages.add(this.antoraCliPackageSpec(this.version));
                }
            } else {
                allPackages.add(this.antoraPackageSpec(this.version));
                if (this.packages != null) {
                    allPackages.addAll(this.packages);
                }
            }
        } else {
            File providedPlaybook = new File(basedir, "provided-antora-playbook.yml");
            playbookArgument = providedPlaybook.getName();
            Map<String, String> providedPackages = new ProvidedPlaybookRetriever(this.getLog(), basedir).retrievePlaybook(this.playbookProvider, providedPlaybook);
            allPackages.add(this.antoraPackageSpec(providedPackages.containsKey("antora") ? providedPackages.remove("antora") : this.version));
            providedPackages.forEach((name, versionSpec) -> allPackages.add(this.packageSpec((String)name, (String)versionSpec)));
        }
        try {
            frontendMojoExecutor.executeMojo("npx", MojoExecutor.element((String)"arguments", (String)this.npxAntoraArguments(allPackages, this.options, playbookArgument)), MojoExecutor.element((String)"environmentVariables", (MojoExecutor.Element[])this.antoraEnvironmentVariables(this.environmentVariables, npmCacheDir)));
        }
        catch (MojoExecutionException e) {
            throw new MojoFailureException("Antora failed to generate site successfully", (Throwable)e);
        }
    }

    private void validate() throws MojoExecutionException {
        File homeNodeModulesDir = new File(System.getProperty("user.home"), "node_modules");
        if (homeNodeModulesDir.isDirectory()) {
            boolean directoryIsEmpty = true;
            try (Stream<Path> entries = Files.list(homeNodeModulesDir.toPath());){
                directoryIsEmpty = entries.findFirst().isEmpty();
            }
            catch (IOException ioe) {
                directoryIsEmpty = false;
            }
            if (!directoryIsEmpty) {
                this.getLog().warn((CharSequence)"Detected the existence of $HOME/node_modules, which is not compatible with this plugin. Please remove it.");
            }
        }
        this.playbookProvider = PlaybookProvider.validate(this.playbookProvider);
        if (this.playbookProvider == null && !this.playbook.exists()) {
            String message = "Antora playbook file not found: " + this.playbook;
            this.getLog().error((CharSequence)("Cannot run Antora because " + message));
            throw new MojoExecutionException(message);
        }
    }

    private MojoExecutor.Element[] npmInstallEnvironmentVariables(boolean hasPackageLockFile, File npmCacheDir) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (npmCacheDir != null) {
            env.put("npm_config_cache", npmCacheDir.getPath());
        }
        env.put("npm_config_fund", "false");
        env.put("npm_config_omit", "optional");
        if (!hasPackageLockFile) {
            env.put("npm_config_package_lock", "false");
        }
        env.put("npm_config_update_notifier", "false");
        return this.mapToElementArray(env);
    }

    private String npxAntoraArguments(List<String> allPackages, List<String> rawOptions, String playbookArgument) {
        ArrayList<String> arguments = new ArrayList<String>(List.of("--yes"));
        if (allPackages.isEmpty()) {
            arguments.set(0, "--offline");
        } else {
            allPackages.forEach(packageSpec -> arguments.addAll(List.of("--package", packageSpec)));
        }
        arguments.add("antora");
        arguments.addAll(this.antoraOptions(rawOptions));
        arguments.add(playbookArgument);
        return String.join((CharSequence)" ", arguments);
    }

    private List<String> antoraOptions(List<String> rawOptions) {
        ArrayList<String> opts = new ArrayList<String>();
        if (rawOptions == null) {
            Path relativeBuildDirectory = this.mavenProject.getBasedir().toPath().relativize(Paths.get(this.mavenProject.getBuild().getDirectory(), "site"));
            this.appendOptions(List.of("--to-dir=" + relativeBuildDirectory), opts);
        } else if (!rawOptions.isEmpty()) {
            this.appendOptions(rawOptions, opts);
        }
        if (this.mavenSession.getRequest().isShowErrors() && !opts.contains("--stacktrace")) {
            opts.add("--stacktrace");
        }
        return opts;
    }

    private MojoExecutor.Element[] antoraEnvironmentVariables(Map<String, String> env, File npmCacheDir) {
        env = env == null ? new HashMap<String, String>() : new HashMap<String, String>(env);
        String isTTY = System.getenv("IS_TTY");
        if (isTTY == null) {
            isTTY = "true";
            env.put("IS_TTY", "true");
        }
        if ("true".equals(isTTY) && System.getenv("FORCE_COLOR") == null && this.mavenSession.getRequest().isInteractiveMode()) {
            env.put("FORCE_COLOR", "true");
        }
        env.put("NODE_OPTIONS", "--no-global-search-paths");
        if (npmCacheDir != null) {
            env.put("npm_config_cache", npmCacheDir.getPath());
        }
        env.put("npm_config_fund", "false");
        env.put("npm_config_lockfile_version", "3");
        env.put("npm_config_omit", "optional");
        env.put("npm_config_update_notifier", "false");
        return this.mapToElementArray(env);
    }

    private String antoraPackageSpec(String versionSpec) {
        return this.packageSpec("antora", versionSpec);
    }

    private String antoraCliPackageSpec(String versionSpec) {
        return this.packageSpec(ANTORA_CLI_PACKAGE_NAME, versionSpec);
    }

    private String packageSpec(String name, String versionSpec) {
        return name + (String)(versionSpec == null || "latest".equals(versionSpec) ? "" : "@" + versionSpec);
    }

    private boolean packageFileExistsWithDependencies(File packageFile) {
        boolean bl;
        if (!packageFile.exists()) {
            return false;
        }
        FileReader reader = new FileReader(packageFile);
        try {
            JsonObject pkg = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            bl = pkg.has("dependencies") && !pkg.getAsJsonObject("dependencies").isEmpty() || pkg.has("devDependencies") && !pkg.getAsJsonObject("devDependencies").isEmpty();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return true;
            }
        }
        reader.close();
        return bl;
    }

    private MojoExecutor.Element[] mapToElementArray(Map<String, String> map) {
        return (MojoExecutor.Element[])map.entrySet().stream().map(envEntry -> MojoExecutor.element((String)((String)envEntry.getKey()), (String)((String)envEntry.getValue()))).toArray(MojoExecutor.Element[]::new);
    }

    private void appendOptions(List<String> from, List<String> to) {
        from.forEach(text -> {
            String value;
            if ((text = text.strip()).isEmpty()) {
                return;
            }
            String[] segments = text.split("[ =]", 2);
            String name = segments[0];
            if (name.startsWith("--")) {
                name = name.substring(2);
            }
            String string = value = segments.length == 2 ? segments[1] : null;
            if (name.endsWith("?")) {
                String[] valueAndFallback;
                name = name.substring(0, name.length() - 1);
                if (value != null && value.contains(":") && (value = (valueAndFallback = value.split(":", 2))[0]).isEmpty() && valueAndFallback.length == 2) {
                    value = valueAndFallback[1];
                }
                if ("false".equals(value)) {
                    return;
                }
                to.add("--" + name);
            } else if (value == null) {
                to.add("--" + name);
            } else if (Pattern.compile("[ \"]").matcher(value).find()) {
                String q = "\"";
                if (value.contains(q)) {
                    if (value.contains("'")) {
                        value = value.replace(q, "&quot;");
                    } else {
                        q = "'";
                    }
                }
                to.add("--" + name + "=" + q + value + q);
            } else {
                to.add("--" + name + "=" + value);
            }
        });
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }
}

