/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.antora.maven.FileDownloader;
import org.antora.maven.FileSideloader;
import org.antora.maven.PlaybookProvider;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ProvidedPlaybookRetriever {
    private static final String PACKAGES_MAGIC_COMMENT_PREFIX = "# PACKAGES ";
    private final Log log;
    private final File basedir;

    public ProvidedPlaybookRetriever(Log log, File basedir) {
        this.log = log;
        this.basedir = basedir;
    }

    public Map<String, String> retrievePlaybook(PlaybookProvider provider, File playbook) throws MojoExecutionException {
        if (playbook.exists()) {
            this.log.info((CharSequence)"Provided playbook has already been retrieved.");
            this.log.info((CharSequence)("Remove " + playbook.getName() + " to retrieve a new copy."));
        } else {
            boolean tryDownload;
            block8: {
                this.log.info((CharSequence)"Retrieving Antora playbook from provider.");
                tryDownload = provider.isDownloadAvailable();
                if (provider.isSideloadAvailable()) {
                    try {
                        new FileSideloader(this.basedir).sideload(provider.getRevPath(), playbook);
                        tryDownload = false;
                    }
                    catch (IOException ioe) {
                        playbook.delete();
                        if (tryDownload) break block8;
                        String msg = "Unable to find provided playbook in local repository and no remote repository is specified from which to download it";
                        this.log.error((CharSequence)msg);
                        throw new MojoExecutionException(msg, (Exception)ioe);
                    }
                }
            }
            if (tryDownload) {
                try {
                    new FileDownloader().download(provider.getDownloadURL(), playbook);
                }
                catch (IOException ioe) {
                    playbook.delete();
                    String msg = "Unable to retrieve provided playbook from remote repository.";
                    this.log.error((CharSequence)msg);
                    throw new MojoExecutionException(msg, (Exception)ioe);
                }
            }
        }
        return this.extractPackages(playbook);
    }

    private Map<String, String> extractPackages(File playbook) {
        HashMap<String, String> packages = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(playbook));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] specs;
                if (!line.startsWith(PACKAGES_MAGIC_COMMENT_PREFIX)) continue;
                for (String spec : specs = line.stripTrailing().substring(PACKAGES_MAGIC_COMMENT_PREFIX.length()).split(" +")) {
                    String[] segments = spec.split("(?!^)[@:]");
                    String name = segments[0];
                    String versionSpec = segments.length > 1 ? segments[1] : null;
                    packages.put(name, versionSpec);
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return packages;
    }
}

