/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antora.maven.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class SystemNodeLinker {
    private static final String RESOLVE_NODE_HOME_SCRIPT = "const p=require('path');function hasNpm(dir){try{require.resolve(p.join(dir,'npm/bin/npm-cli.js'));return dir}catch{}};const exe=process.execPath,root=p.join(exe,p.basename(p.dirname(exe))==='bin'?'../..':'..');const pkgs=hasNpm(p.join(root,'lib/node_modules'))||hasNpm(p.join(root,'node_modules'))||'';pkgs&&exe+'\\n'+pkgs+'\\n'+process.version";
    private final Log log;
    private final Path symbolicNodeHomeDir;

    public SystemNodeLinker(Log log, File symbolicNodeHomeDir) {
        this.log = log;
        this.symbolicNodeHomeDir = symbolicNodeHomeDir.toPath();
    }

    public String linkNode(String nodeExecutable) throws MojoExecutionException {
        List<String> targets = null;
        String quotedNodeExecutable = "nodeExecutable \"" + nodeExecutable + "\"";
        try {
            targets = this.resolveSystemNodeHome(nodeExecutable);
            if (targets.isEmpty()) {
                targets = null;
            }
        }
        catch (IOException e) {
            String msg = "Cannot run " + quotedNodeExecutable;
            Throwable cause = e.getCause() == null ? e : e.getCause();
            this.log.error((CharSequence)(msg + ": " + cause.getMessage()));
            throw new MojoExecutionException(msg, cause);
        }
        if (targets == null) {
            String msg = "Cannot verify compatible Node.js installation for " + quotedNodeExecutable;
            this.log.error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        Path nodeExecutableTarget = Path.of(targets.get(0), new String[0]);
        Path nodeModulesDirectoryTarget = Path.of(targets.get(1), new String[0]);
        String nodeVersion = targets.get(2);
        Path nodeExecutableLink = this.symbolicNodeHomeDir.resolve("node" + this.getFileExtension(nodeExecutableTarget));
        Path nodeModulesDirectoryLink = this.symbolicNodeHomeDir.resolve("node_modules");
        if (this.isSymbolicLinkTo(nodeExecutableLink, nodeExecutableTarget) && this.isSymbolicLinkTo(nodeModulesDirectoryLink, nodeModulesDirectoryTarget)) {
            this.log.info((CharSequence)("System Node.js already linked for " + quotedNodeExecutable));
            return nodeVersion;
        }
        try {
            FileUtils.cleanDirectory(this.symbolicNodeHomeDir.toFile());
        }
        catch (IOException e) {
            String msg = "Unable to prepare Node.js installation directory for " + quotedNodeExecutable;
            this.log.error((CharSequence)msg);
            throw new MojoExecutionException(msg, (Exception)e);
        }
        try {
            Files.createSymbolicLink(nodeExecutableLink, nodeExecutableTarget, new FileAttribute[0]);
            Files.createSymbolicLink(nodeModulesDirectoryLink, nodeModulesDirectoryTarget, new FileAttribute[0]);
            this.log.info((CharSequence)("Linking system Node.js for " + quotedNodeExecutable));
            return nodeVersion;
        }
        catch (IOException e) {
            try {
                Files.copy(nodeExecutableTarget, nodeExecutableLink, StandardCopyOption.COPY_ATTRIBUTES);
                File npmModuleDirectorySrc = new File(nodeModulesDirectoryTarget.toFile(), "npm");
                File npmModuleDirectoryDest = new File(nodeModulesDirectoryLink.toFile(), "npm");
                npmModuleDirectoryDest.getParentFile().mkdir();
                FileUtils.copyRecursively(npmModuleDirectorySrc, npmModuleDirectoryDest);
                this.log.info((CharSequence)("Copying system Node.js for " + quotedNodeExecutable));
                return nodeVersion;
            }
            catch (IOException re) {
                e = re;
                String msg = "Unable to link or copy system Node.js for " + quotedNodeExecutable;
                this.log.error((CharSequence)msg);
                throw new MojoExecutionException(msg, (Exception)e);
            }
        }
    }

    public void unlinkNode() {
        if (!this.symbolicNodeHomeDir.toFile().isDirectory()) {
            return;
        }
        List.of("node", "node.exe", "node_modules").forEach(name -> {
            Path path = this.symbolicNodeHomeDir.resolve((String)name);
            if (this.isSymbolicLink(path)) {
                path.toFile().delete();
            }
        });
    }

    private List<String> resolveSystemNodeHome(String nodeExecutable) throws IOException {
        Process p = new ProcessBuilder(nodeExecutable, "-p", RESOLVE_NODE_HOME_SCRIPT).start();
        try (BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
             BufferedReader stderrReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
            List errLines;
            int exitValue;
            List<String> output = stdoutReader.lines().collect(Collectors.toList());
            if (output.size() == 1 && ((String)output.get(0)).isEmpty()) {
                output.clear();
            }
            try {
                p.waitFor(1L, TimeUnit.SECONDS);
                exitValue = p.exitValue();
            }
            catch (InterruptedException e) {
                exitValue = 1;
            }
            if (exitValue == 0 && (output.size() == 3 || output.isEmpty())) {
                List<String> e = output;
                return e;
            }
            String msg = "Not a valid Node.js executable";
            IOException cause = null;
            if (exitValue > 0 && !(errLines = stderrReader.lines().collect(Collectors.toList())).isEmpty() && !Pattern.compile(" (?:flag|option)[: ].*[-']?p").matcher((CharSequence)errLines.get(0)).find()) {
                cause = new IOException("error=" + exitValue + ", " + String.join((CharSequence)"\n", errLines));
            }
            throw new IOException(msg, cause);
        }
    }

    private String getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int fileExtensionIdx = fileName.lastIndexOf(46);
        if (fileExtensionIdx < 0) {
            return "";
        }
        return fileName.substring(fileExtensionIdx);
    }

    private boolean isSymbolicLink(Path candidate) {
        try {
            Files.readSymbolicLink(candidate);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isSymbolicLinkTo(Path candidate, Path target) {
        try {
            return Files.readSymbolicLink(candidate).equals(target);
        }
        catch (IOException e) {
            return false;
        }
    }
}

