/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.util.Objects;
import org.antublue.test.engine.api.Argument;

public class ByteArgument
implements Argument {
    private final String name;
    private final byte value;

    public ByteArgument(String name, byte value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public byte value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArgument that = (ByteArgument)o;
        return this.value == that.value && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static ByteArgument of(byte value) {
        return new ByteArgument(String.valueOf(value).toUpperCase(), value);
    }
}

