/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.util.Objects;
import org.antublue.test.engine.api.Argument;

public class DoubleArgument
implements Argument {
    private final String name;
    private final double value;

    public DoubleArgument(String name, double value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public double value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleArgument that = (DoubleArgument)o;
        return Double.compare(that.value, this.value) == 0 && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static DoubleArgument of(double value) {
        return new DoubleArgument(String.valueOf(value).toUpperCase(), value);
    }
}

