/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.maven.plugin;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.antublue.test.engine.internal.TestEngineConsoleTestExecutionListener;
import org.antublue.test.engine.internal.util.AnsiColor;
import org.antublue.test.engine.internal.util.AnsiColorString;
import org.antublue.test.engine.maven.plugin.SuppressedStackTraceMojoExecutionException;
import org.antublue.test.engine.maven.plugin.TestEngineMavenPluginInformation;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

@Mojo(name="test", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class TestEngineMavenPlugin
extends AbstractMojo {
    private static final String GROUP_ID = "org.antublue";
    private static final String ARTIFACT_ID = "test-engine-maven-plugin";
    private static final String VERSION = TestEngineMavenPluginInformation.getVersion();
    private static final String BANNER = new AnsiColorString().color(AnsiColor.WHITE_BRIGHT).append("Antu").color(AnsiColor.BLUE_BOLD_BRIGHT).append("BLUE").color(AnsiColor.WHITE_BRIGHT).append(" Test Engine Maven Plugin ").append(VERSION).toString();
    private static final String SEPARATOR = AnsiColor.WHITE_BRIGHT.apply((Object)"------------------------------------------------------------------------");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject mavenProject;
    @Parameter(property="properties")
    protected Map<String, String> properties;
    private Log log;

    public void execute() throws MojoExecutionException {
        this.debug(SEPARATOR);
        this.debug(BANNER);
        this.debug(SEPARATOR);
        System.setProperty("__ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN__", "true");
        this.debug("system property [__ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN__] = [%s]", (Object)"true");
        if (!this.mavenSession.getRequest().isInteractiveMode()) {
            System.setProperty("__ANTUBLUE_TEST_ENGINE_MAVEN_BATCH_MODE__", "true");
            this.debug("system property [__ANTUBLUE_TEST_ENGINE_MAVEN_BATCH_MODE__] = [%s]", (Object)"true");
        }
        Optional.ofNullable(this.properties).ifPresent(map -> map.forEach((key, value) -> {
            if (key != null && value != null) {
                System.setProperty(key, value);
                this.debug("system property [%s] = [%s]", key, value);
            }
        }));
        try {
            LinkedHashSet artifactPaths = new LinkedHashSet();
            Optional.ofNullable(this.mavenProject.getCompileClasspathElements()).ifPresent(strings -> strings.forEach(string -> artifactPaths.add(new File((String)string).toPath())));
            Optional.ofNullable(this.mavenProject.getRuntimeClasspathElements()).ifPresent(strings -> strings.forEach(string -> artifactPaths.add(new File((String)string).toPath())));
            Optional.ofNullable(this.mavenProject.getTestClasspathElements()).ifPresent(strings -> strings.forEach(string -> artifactPaths.add(new File((String)string).toPath())));
            Optional.ofNullable(this.mavenProject.getArtifact()).ifPresent(artifact -> artifactPaths.add(artifact.getFile().toPath()));
            Optional.ofNullable(this.mavenProject.getDependencyArtifacts()).ifPresent(artifacts -> artifacts.forEach(artifact -> artifactPaths.add(artifact.getFile().toPath())));
            Optional.ofNullable(this.mavenProject.getAttachedArtifacts()).ifPresent(artifacts -> artifacts.forEach(artifact -> artifactPaths.add(artifact.getFile().toPath())));
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            for (Path path : artifactPaths) {
                URL url = path.toUri().toURL();
                urls.add(url);
                this.debug("classpath entry [%s]", (Object)url);
            }
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            TestEngineConsoleTestExecutionListener testEngineConsoleTestExecutionListener = new TestEngineConsoleTestExecutionListener();
            LauncherConfig launcherConfig = LauncherConfig.builder().build();
            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(artifactPaths)).filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{".*"})}).configurationParameters(Collections.emptyMap()).build();
            try (LauncherSession launcherSession = LauncherFactory.openSession((LauncherConfig)launcherConfig);){
                Launcher launcher = launcherSession.getLauncher();
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{testEngineConsoleTestExecutionListener});
                launcher.execute(launcherDiscoveryRequest, new TestExecutionListener[0]);
            }
            if (testEngineConsoleTestExecutionListener.hasFailures()) {
                throw new SuppressedStackTraceMojoExecutionException("Test failures");
            }
        }
        catch (SuppressedStackTraceMojoExecutionException e) {
            throw e;
        }
        catch (JUnitException e) {
            StringBuilder stringBuilder = new StringBuilder().append(System.lineSeparator()).append(System.lineSeparator()).append(e.getCause().getMessage()).append(System.lineSeparator());
            throw new SuppressedStackTraceMojoExecutionException(stringBuilder.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new MojoExecutionException("General AntuBLUE Test Engine Maven Plugin Exception", t);
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private void debug(String format, Object object) {
        if (this.log.isDebugEnabled()) {
            this.debug(format, new Object[]{object});
        }
    }

    private void debug(String format, Object ... objects) {
        if (this.log.isDebugEnabled()) {
            this.debug(String.format(format, objects));
        }
    }

    private void debug(String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)message);
        }
    }

    private void info() {
        this.info("");
    }

    private void info(String format, Object ... objects) {
        this.info(String.format(format, objects));
    }

    private void info(String message) {
        System.out.println(new AnsiColorString().append("[").color(AnsiColor.BLUE_BOLD).append("INFO").color(AnsiColor.RESET).append("] ").append(message));
    }
}

