/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.maven.plugin.logger;

import org.apache.maven.plugin.logging.Log;

public class Logger {
    private final Log log;

    private Logger(Log log) {
        this.log = log;
    }

    public void debug(String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)message);
        }
    }

    public void debug(String format, Object ... objects) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format(format, objects));
        }
    }

    public void info(String message) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)message);
        }
    }

    public void info(String format, Object ... objects) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)String.format(format, objects));
        }
    }

    public void warn(String message) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)message);
        }
    }

    public void warn(String format, Object ... objects) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)String.format(format, objects));
        }
    }

    public void error(String message) {
        if (this.log.isErrorEnabled()) {
            this.log.error((CharSequence)message);
        }
    }

    public void error(String format, Object ... objects) {
        if (this.log.isErrorEnabled()) {
            this.log.error((CharSequence)String.format(format, objects));
        }
    }

    public static Logger from(Log log) {
        return new Logger(log);
    }
}

