/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.math.BigDecimal;
import java.util.Objects;
import org.antublue.test.engine.api.Argument;

public class BigDecimalArgument
implements Argument {
    private final String name;
    private final BigDecimal value;

    public BigDecimalArgument(String name, BigDecimal value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public BigDecimal value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigDecimalArgument that = (BigDecimalArgument)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static BigDecimalArgument of(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return new BigDecimalArgument(String.valueOf(value).toUpperCase(), value);
    }
}

