/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.util.Objects;
import org.antublue.test.engine.api.Argument;

public class FloatArgument
implements Argument {
    private final String name;
    private final float value;

    public FloatArgument(String name, float value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public float value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatArgument that = (FloatArgument)o;
        return Float.compare(that.value, this.value) == 0 && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, Float.valueOf(this.value));
    }

    public static FloatArgument of(float value) {
        return new FloatArgument(String.valueOf(value).toUpperCase(), value);
    }
}

