/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.util.Objects;
import org.antublue.test.engine.api.Argument;

public class IntegerArgument
implements Argument {
    private final String name;
    private final int value;

    public IntegerArgument(String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public int value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerArgument that = (IntegerArgument)o;
        return this.value == that.value && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static IntegerArgument of(int value) {
        return new IntegerArgument(String.valueOf(value).toUpperCase(), value);
    }
}

