/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

public class AnsiColor {
    private static final String NO_COLOR = "NO_COLOR";
    private static final String EMPTY_STRING = "";
    private static final String ONE = "1";
    private static final String TRUE = "true";
    public static final AnsiColor RESET = new AnsiColor("\u001b[0m");
    public static final AnsiColor BLACK = new AnsiColor("\u001b[0;30m");
    public static final AnsiColor RED = new AnsiColor("\u001b[0;38;5;160m");
    public static final AnsiColor GREEN = new AnsiColor("\u001b[0;32m");
    public static final AnsiColor YELLOW = new AnsiColor("\u001b[0;33m");
    public static final AnsiColor BLUE = new AnsiColor("\u001b[0;34m");
    public static final AnsiColor PURPLE = new AnsiColor("\u001b[0;35m");
    public static final AnsiColor CYAN = new AnsiColor("\u001b[0;36m");
    public static final AnsiColor WHITE = new AnsiColor("\u001b[0;37m");
    public static final AnsiColor BLACK_BOLD = new AnsiColor("\u001b[1;30m");
    public static final AnsiColor RED_BOLD = new AnsiColor("\u001b[1;31m");
    public static final AnsiColor GREEN_BOLD = new AnsiColor("\u001b[1;32m");
    public static final AnsiColor YELLOW_BOLD = new AnsiColor("\u001b[1;33m");
    public static final AnsiColor BLUE_BOLD = new AnsiColor("\u001b[1;34m");
    public static final AnsiColor PURPLE_BOLD = new AnsiColor("\u001b[1;35m");
    public static final AnsiColor CYAN_BOLD = new AnsiColor("\u001b[1;36m");
    public static final AnsiColor WHITE_BOLD = new AnsiColor("\u001b[1;37m");
    public static final AnsiColor BLACK_UNDERLINED = new AnsiColor("\u001b[4;30m");
    public static final AnsiColor RED_UNDERLINED = new AnsiColor("\u001b[4;31m");
    public static final AnsiColor GREEN_UNDERLINED = new AnsiColor("\u001b[4;32m");
    public static final AnsiColor YELLOW_UNDERLINED = new AnsiColor("\u001b[4;33m");
    public static final AnsiColor BLUE_UNDERLINED = new AnsiColor("\u001b[4;34m");
    public static final AnsiColor PURPLE_UNDERLINED = new AnsiColor("\u001b[4;35m");
    public static final AnsiColor CYAN_UNDERLINED = new AnsiColor("\u001b[4;36m");
    public static final AnsiColor WHITE_UNDERLINED = new AnsiColor("\u001b[4;37m");
    public static final AnsiColor BLACK_BACKGROUND = new AnsiColor("\u001b[40m");
    public static final AnsiColor RED_BACKGROUND = new AnsiColor("\u001b[41m");
    public static final AnsiColor GREEN_BACKGROUND = new AnsiColor("\u001b[42m");
    public static final AnsiColor YELLOW_BACKGROUND = new AnsiColor("\u001b[43m");
    public static final AnsiColor BLUE_BACKGROUND = new AnsiColor("\u001b[44m");
    public static final AnsiColor PURPLE_BACKGROUND = new AnsiColor("\u001b[45m");
    public static final AnsiColor CYAN_BACKGROUND = new AnsiColor("\u001b[46m");
    public static final AnsiColor WHITE_BACKGROUND = new AnsiColor("\u001b[47m");
    public static final AnsiColor BLACK_BRIGHT = new AnsiColor("\u001b[0;90m");
    public static final AnsiColor RED_BRIGHT = new AnsiColor("\u001b[0;38;5;196m");
    public static final AnsiColor GREEN_BRIGHT = new AnsiColor("\u001b[0;92m");
    public static final AnsiColor YELLOW_BRIGHT = new AnsiColor("\u001b[0;93m");
    public static final AnsiColor BLUE_BRIGHT = new AnsiColor("\u001b[0;94m");
    public static final AnsiColor PURPLE_BRIGHT = new AnsiColor("\u001b[0;95m");
    public static final AnsiColor CYAN_BRIGHT = new AnsiColor("\u001b[0;96m");
    public static final AnsiColor WHITE_BRIGHT = new AnsiColor("\u001b[1;97m");
    public static final AnsiColor BLACK_BOLD_BRIGHT = new AnsiColor("\u001b[1;90m");
    public static final AnsiColor RED_BOLD_BRIGHT = new AnsiColor("\u001b[1;38;5;160m");
    public static final AnsiColor GREEN_BOLD_BRIGHT = new AnsiColor("\u001b[1;92m");
    public static final AnsiColor YELLOW_BOLD_BRIGHT = new AnsiColor("\u001b[1;93m");
    public static final AnsiColor BLUE_BOLD_BRIGHT = new AnsiColor("\u001b[1;94m");
    public static final AnsiColor PURPLE_BOLD_BRIGHT = new AnsiColor("\u001b[1;95m");
    public static final AnsiColor CYAN_BOLD_BRIGHT = new AnsiColor("\u001b[1;96m");
    public static final AnsiColor WHITE_BOLD_BRIGHT = new AnsiColor("\u001b[1;97m");
    public static final AnsiColor BLACK_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;100m");
    public static final AnsiColor RED_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;101m");
    public static final AnsiColor GREEN_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;102m");
    public static final AnsiColor YELLOW_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;103m");
    public static final AnsiColor BLUE_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;104m");
    public static final AnsiColor PURPLE_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;105m");
    public static final AnsiColor CYAN_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;106m");
    public static final AnsiColor WHITE_BACKGROUND_BRIGHT = new AnsiColor("\u001b[0;107m");
    private static boolean ANSI_COLOR_SUPPORTED = System.console() != null;
    private final String ansiColorCodeSequence;

    private AnsiColor(String ansiColorCodeSequence) {
        this.ansiColorCodeSequence = ansiColorCodeSequence;
    }

    public String apply(Object object) {
        if (ANSI_COLOR_SUPPORTED) {
            return this.ansiColorCodeSequence + object + RESET;
        }
        return String.valueOf(object);
    }

    public String toString() {
        if (ANSI_COLOR_SUPPORTED) {
            return this.ansiColorCodeSequence;
        }
        return EMPTY_STRING;
    }

    public static boolean isSupported() {
        return ANSI_COLOR_SUPPORTED;
    }

    static {
        if (ONE.equals(System.getenv(NO_COLOR))) {
            ANSI_COLOR_SUPPORTED = false;
        }
        if (TRUE.equals("__ANTUBLUE_TEST_ENGINE_MAVEN_BATCH_MODE__")) {
            ANSI_COLOR_SUPPORTED = false;
        }
    }
}

