/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.support.DisplayNameSupport;
import org.antublue.test.engine.internal.support.OrdererSupport;
import org.antublue.test.engine.internal.util.Predicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class TestMethodTestDescriptor
extends ExecutableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestMethodTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument<?> testArgument;
    private final List<Method> beforeEachMethods;
    private final Method testMethod;
    private final List<Method> afterEachMethods;
    private Object testInstance;

    public TestMethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, List<Method> beforeEachMethods, Method testMethod, List<Method> afterEachMethods, Argument<?> testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.beforeEachMethods = beforeEachMethods;
        this.testMethod = testMethod;
        this.afterEachMethods = afterEachMethods;
        this.testArgument = testArgument;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    @Override
    public void execute(ExecutionRequest executionRequest, Object testInstance) {
        LOGGER.trace("execute(ExecutionRequest executionRequest)");
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        this.testInstance = testInstance;
        this.getStopWatch().reset();
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testClass.displayName", DisplayNameSupport.getDisplayName(this.testClass));
        this.getMetadata().put("testArgument", this.testArgument);
        this.getMetadata().put("testMethod", this.testMethod);
        this.getMetadata().put("testMethod.displayName", this.getDisplayName());
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = this.getThrowableCollector();
        throwableCollector.execute(this::beforeEach);
        if (this.getThrowableCollector().isEmpty()) {
            throwableCollector.execute(this::test);
        }
        throwableCollector.execute(this::afterEach);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoseconds());
        if (this.getThrowableCollector().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", "PASS");
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", "FAIL");
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableCollector().getThrowable()));
        }
    }

    private void beforeEach() throws Throwable {
        LOGGER.trace("beforeEach() testClass [%s] testInstance [%s]", this.testInstance.getClass().getName(), this.testInstance);
        for (Method method : this.beforeEachMethods) {
            LOGGER.trace("beforeEach() testClass [%s] testInstance [%s] method [%s]", this.testInstance.getClass().getName(), this.testInstance, method);
            method.invoke(this.testInstance, new Object[0]);
        }
    }

    private void test() throws Throwable {
        LOGGER.trace("test() testClass [%s] testInstance [%s] method [%s]", this.testInstance.getClass().getName(), this.testInstance, this.testMethod);
        this.testMethod.invoke(this.testInstance, new Object[0]);
    }

    private void afterEach() throws Throwable {
        LOGGER.trace("afterEach() testClass [%s] testInstance [%s]", this.testInstance.getClass().getName(), this.testInstance);
        for (Method method : this.afterEachMethods) {
            LOGGER.trace("afterEach() testClass [%s] testInstance [%s] method [%s]", this.testInstance.getClass().getName(), this.testInstance, method);
            method.invoke(this.testInstance, new Object[0]);
        }
    }

    public static TestMethodTestDescriptor create(UniqueId parentUniqueId, Class<?> testClass, Method testMethod, Argument<?> testArgument) {
        Preconditions.notNull((Object)parentUniqueId, (String)"parentUniqueId is null");
        Preconditions.notNull(testClass, (String)"testClass is null");
        Preconditions.notNull((Object)testMethod, (String)"testMethod is null");
        Preconditions.notNull(testArgument, (String)"testArgument is null");
        UniqueId uniqueId = parentUniqueId.append(TestMethodTestDescriptor.class.getName(), testMethod.getName());
        String displayName = DisplayNameSupport.getDisplayName(testMethod);
        List<Method> beforeEachMethods = ReflectionSupport.findMethods(testClass, Predicates.BEFORE_EACH_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        beforeEachMethods = OrdererSupport.orderTestMethods(beforeEachMethods, HierarchyTraversalMode.TOP_DOWN);
        List<Method> afterEachMethods = ReflectionSupport.findMethods(testClass, Predicates.AFTER_EACH_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        afterEachMethods = OrdererSupport.orderTestMethods(afterEachMethods, HierarchyTraversalMode.BOTTOM_UP);
        return new TestMethodTestDescriptor(uniqueId, displayName, testClass, beforeEachMethods, testMethod, afterEachMethods, testArgument);
    }
}

