/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.api;

import java.math.BigDecimal;
import java.math.BigInteger;

public interface Argument<T> {
    public static Argument<Boolean> ofBoolean(boolean value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Byte> ofByte(byte value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Character> ofChar(char value) {
        return Argument.of(String.valueOf(value), Character.valueOf(value));
    }

    public static Argument<Short> ofShort(short value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Integer> ofInt(int value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Long> ofLong(long value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Float> ofFloat(float value) {
        return Argument.of(String.valueOf(value), Float.valueOf(value));
    }

    public static Argument<Double> ofDouble(double value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<String> ofString(String value) {
        if (value == null) {
            return Argument.of("String=/null/", value);
        }
        if (value.isEmpty()) {
            return Argument.of("String=/empty/", value);
        }
        return Argument.of(value, value);
    }

    public static Argument<BigInteger> ofBigInteger(BigInteger value) {
        if (value == null) {
            return Argument.of("BigInteger=/null/", value);
        }
        return Argument.of(value.toString(), value);
    }

    public static Argument<BigDecimal> ofBigDecimal(BigDecimal value) {
        if (value == null) {
            return Argument.of("BigDecimal=/null/", value);
        }
        return Argument.of(value.toString(), value);
    }

    public static <T> Argument<T> of(final String name, final T payload) {
        Argument.notNullOrEmpty(name, "name is null", "name is empty");
        return new Argument<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public T getPayload() {
                return payload;
            }

            public String toString() {
                return name;
            }
        };
    }

    public String getName();

    public T getPayload();

    public static void notNullOrEmpty(String string, String nullMessage, String emptyMessage) {
        if (string == null) {
            throw new IllegalArgumentException(nullMessage);
        }
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException(emptyMessage);
        }
    }
}

