/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Key {
    private final List<Segment> segments;

    private Key(List<Segment> segments) {
        this.segments = segments;
    }

    public List<Segment> segments() {
        return new ArrayList<Segment>(this.segments);
    }

    public Key append(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        Key key = new Key(Collections.synchronizedList(this.segments));
        key.segments.add(new Segment(object));
        return key;
    }

    public Key remove() {
        List<Segment> segments = Collections.synchronizedList(this.segments);
        if (segments.size() <= 1) {
            throw new IllegalStateException("can't remove root segment");
        }
        segments.remove(segments.size() - 1);
        return new Key(segments);
    }

    public static Key of(Object ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects is null");
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("objects is empty");
        }
        List<Segment> segments = Collections.synchronizedList(new ArrayList(objects.length));
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object == null) {
                throw new IllegalArgumentException(String.format("objects[%d] is null", i));
            }
            segments.add(new Segment(object));
        }
        return new Key(segments);
    }

    public static Object of(List<Object> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects is null");
        }
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("objects is empty");
        }
        List<Segment> segments = Collections.synchronizedList(new ArrayList(objects.size()));
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            if (object == null) {
                throw new IllegalArgumentException(String.format("object[%d] is null", i));
            }
            segments.add(new Segment(object));
        }
        return new Key(segments);
    }

    public String toString() {
        return "Key{segments=" + this.segments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        return Objects.equals(this.segments, key.segments);
    }

    public int hashCode() {
        return Objects.hashCode(this.segments);
    }

    public static class Segment {
        private final Object value;

        private Segment(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }
    }
}

