/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.api.concurrency;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import org.antublue.verifyica.api.Configuration;
import org.antublue.verifyica.api.Context;
import org.antublue.verifyica.api.Store;

public class ConcurrencySupport {
    private static final LockManager LOCK_MANAGER = new LockManager();

    private ConcurrencySupport() {
    }

    public static LockReference getLockReference(Object key) {
        ConcurrencySupport.notNull(key, "key is null");
        return new DefaultLockReference(LOCK_MANAGER, key);
    }

    public static void run(Object key, Runnable runnable) {
        ConcurrencySupport.notNull(key, "key is null");
        ConcurrencySupport.notNull(runnable, "runnable is null");
        LockReference lockReference = ConcurrencySupport.getLockReference(key);
        lockReference.lock();
        try {
            runnable.run();
        }
        finally {
            lockReference.unlock();
        }
    }

    public static void run(Lock lock, Runnable runnable) {
        ConcurrencySupport.notNull(lock, "lock is null");
        ConcurrencySupport.notNull(runnable, "runnable is null");
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static void run(Configuration configuration, Runnable runnable) {
        ConcurrencySupport.notNull(configuration, "configuration is null");
        ConcurrencySupport.notNull(runnable, "runnable is null");
        ConcurrencySupport.run(configuration.getLock(), runnable);
    }

    public static void run(Context context, Runnable runnable) {
        ConcurrencySupport.notNull(context, "context is null");
        ConcurrencySupport.notNull(runnable, "runnable is null");
        ConcurrencySupport.run(context.getLock(), runnable);
    }

    public static void run(Store store, Runnable runnable) {
        ConcurrencySupport.notNull(store, "store is null");
        ConcurrencySupport.notNull(runnable, "runnable is null");
        ConcurrencySupport.run(store.getLock(), runnable);
    }

    public static void run(ReadWriteLock readWriteLock, LockType lockType, Runnable runnable) {
        Lock lock;
        ConcurrencySupport.notNull(readWriteLock, "readWriteLock is null");
        ConcurrencySupport.notNull((Object)lockType, "lockType is null");
        ConcurrencySupport.notNull(runnable, "runnable is null");
        switch (lockType.ordinal()) {
            case 0: {
                lock = readWriteLock.readLock();
                ConcurrencySupport.notNull(lock, "readWriteLock.readLock() is null");
                break;
            }
            case 1: {
                lock = readWriteLock.writeLock();
                ConcurrencySupport.notNull(lock, "readWriteLock.writeLock() is null");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid lockType [%s]", new Object[]{lockType}));
            }
        }
        ConcurrencySupport.run(lock, runnable);
    }

    public static void run(Semaphore semaphore, Runnable runnable) throws InterruptedException {
        ConcurrencySupport.notNull(semaphore, "semaphore is null");
        ConcurrencySupport.notNull(runnable, "runnable is null");
        semaphore.acquire();
        try {
            runnable.run();
        }
        finally {
            semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V call(Object key, Callable<V> callable) throws Throwable {
        ConcurrencySupport.notNull(key, "key is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        LockReference lockReference = ConcurrencySupport.getLockReference(key);
        lockReference.lock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            lockReference.unlock();
        }
    }

    public static <V> V call(Lock lock, Callable<V> callable) throws Throwable {
        ConcurrencySupport.notNull(lock, "lock is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        lock.lock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public static <V> V call(ReadWriteLock readWriteLock, Callable<V> callable) throws Throwable {
        ConcurrencySupport.notNull(readWriteLock, "readWriteLock is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        Lock lock = readWriteLock.writeLock();
        ConcurrencySupport.notNull(lock, "readWriteLock.writeLock() is null");
        return ConcurrencySupport.call(lock, callable);
    }

    public static <V> V call(ReadWriteLock readWriteLock, LockType lockType, Callable<V> callable) throws Throwable {
        Lock lock;
        ConcurrencySupport.notNull(readWriteLock, "readWriteLock is null");
        ConcurrencySupport.notNull((Object)lockType, "lockType is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        switch (lockType.ordinal()) {
            case 0: {
                lock = readWriteLock.readLock();
                ConcurrencySupport.notNull(lock, "readWriteLock.readLock() is null");
                break;
            }
            case 1: {
                lock = readWriteLock.writeLock();
                ConcurrencySupport.notNull(lock, "readWriteLock.writeLock() is null");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid lockType [%s]", new Object[]{lockType}));
            }
        }
        return ConcurrencySupport.call(lock, callable);
    }

    public static <V> V call(Configuration configuration, Callable<V> callable) throws Throwable {
        ConcurrencySupport.notNull(configuration, "configuration is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        return ConcurrencySupport.call(configuration.getLock(), callable);
    }

    public static <V> V call(Context context, Callable<V> callable) throws Throwable {
        ConcurrencySupport.notNull(context, "context is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        return ConcurrencySupport.call(context.getLock(), callable);
    }

    public static <V> V call(Store store, Callable<V> callable) throws Throwable {
        ConcurrencySupport.notNull(store, "store is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        return ConcurrencySupport.call(store.getLock(), callable);
    }

    public static <V> V call(Semaphore semaphore, Callable<V> callable) throws Exception {
        ConcurrencySupport.notNull(semaphore, "semaphore is null");
        ConcurrencySupport.notNull(callable, "callable is null");
        semaphore.acquire();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            semaphore.release();
        }
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static class DefaultLockReference
    implements LockReference {
        private final LockManager lockManager;
        private final Object key;

        private DefaultLockReference(LockManager lockManager, Object key) {
            this.lockManager = lockManager;
            this.key = key;
        }

        @Override
        public void lock() {
            this.lockManager.lock(this.key);
        }

        @Override
        public boolean tryLock() {
            return this.lockManager.tryLock(this.key);
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit timeUnit) throws InterruptedException {
            ConcurrencySupport.notNull((Object)timeUnit, "timeUnit it null");
            return this.lockManager.tryLock(this.key, timeout, timeUnit);
        }

        @Override
        public void unlock() {
            this.lockManager.unlock(this.key);
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultLockReference that = (DefaultLockReference)o;
            return Objects.equals(this.lockManager, that.lockManager) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.lockManager, this.key);
        }
    }

    private static class LockManager {
        private final ReentrantLock lockManagerLock = new ReentrantLock(true);
        private final Map<Object, ReentrantLock> lockMap = new HashMap<Object, ReentrantLock>();
        private final Map<Object, Counter> lockCounterMap = new HashMap<Object, Counter>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(Object key) {
            ReentrantLock lock;
            this.lockManagerLock.lock();
            try {
                lock = this.lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
                Counter counter = this.lockCounterMap.computeIfAbsent(key, k -> new Counter());
                counter.increment();
            }
            finally {
                this.lockManagerLock.unlock();
            }
            lock.lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(Object key) {
            this.lockManagerLock.lock();
            try {
                ReentrantLock lock = this.lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
                Counter counter = this.lockCounterMap.computeIfAbsent(key, k -> new Counter());
                counter.increment();
                if (lock.tryLock()) {
                    boolean bl = true;
                    return bl;
                }
                if (counter.decrement() == 0) {
                    this.lockMap.remove(key);
                    this.lockCounterMap.remove(key);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lockManagerLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(Object key, long timeout, TimeUnit timeUnit) throws InterruptedException {
            this.lockManagerLock.lock();
            try {
                ReentrantLock lock = this.lockMap.computeIfAbsent(key, k -> new ReentrantLock(true));
                Counter counter = this.lockCounterMap.computeIfAbsent(key, k -> new Counter());
                counter.increment();
                if (lock.tryLock(timeout, timeUnit)) {
                    boolean bl = true;
                    return bl;
                }
                if (counter.decrement() == 0) {
                    this.lockMap.remove(key);
                    this.lockCounterMap.remove(key);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lockManagerLock.unlock();
            }
        }

        public void unlock(Object key) {
            block6: {
                this.lockManagerLock.lock();
                try {
                    ReentrantLock lock = this.lockMap.get(key);
                    if (lock != null) {
                        if (lock.isHeldByCurrentThread()) {
                            lock.unlock();
                            if (this.lockCounterMap.get(key).decrement() == 0) {
                                this.lockMap.remove(key);
                                this.lockCounterMap.remove(key);
                            }
                            break block6;
                        }
                        throw new IllegalMonitorStateException(String.format("Current thread does not hold the lock for the given key [%s]", key));
                    }
                    throw new IllegalMonitorStateException(String.format("No lock found for the given key [%s]", key));
                }
                finally {
                    this.lockManagerLock.unlock();
                }
            }
        }
    }

    public static interface LockReference {
        public void lock();

        public boolean tryLock() throws InterruptedException;

        public boolean tryLock(long var1, TimeUnit var3) throws InterruptedException;

        public void unlock();
    }

    public static enum LockType {
        READ,
        WRITE;

    }

    private static class Counter {
        private int count;

        public void increment() {
            ++this.count;
        }

        public int decrement() {
            --this.count;
            if (this.count < 0) {
                this.count = 0;
            }
            return this.count;
        }
    }
}

