/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.antublue.verifyica.api.Store;
import org.antublue.verifyica.engine.common.ThrowableCollector;
import org.antublue.verifyica.engine.configuration.DefaultConfiguration;
import org.antublue.verifyica.engine.context.DefaultEngineContext;
import org.antublue.verifyica.engine.context.DefaultEngineInterceptorContext;
import org.antublue.verifyica.engine.descriptor.ClassTestDescriptor;
import org.antublue.verifyica.engine.descriptor.StatusEngineDescriptor;
import org.antublue.verifyica.engine.descriptor.execution.NamedRunnable;
import org.antublue.verifyica.engine.descriptor.execution.RunnableClassTestDescriptor;
import org.antublue.verifyica.engine.discovery.EngineDiscoveryRequestResolver;
import org.antublue.verifyica.engine.exception.EngineException;
import org.antublue.verifyica.engine.interceptor.internal.engine.EngineInterceptorRegistry;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.antublue.verifyica.engine.support.ExecutorServiceSupport;
import org.antublue.verifyica.engine.support.HashSupport;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;

public class VerifyicaEngine
implements TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyicaEngine.class);
    private static final String ENGINE_PROPERTIES_RESOURCE = "/engine.properties";
    private static final String ENGINE_PROPERTIES_VERSION_KEY = "version";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String ID = "verifyica";
    private static final String GROUP_ID = "org.antublue.verifyica";
    private static final String ARTIFACT_ID = "engine";
    private static final String VERSION = VerifyicaEngine.version();
    private static final String UNIQUE_ID = "[engine:verifyica]";

    public String getId() {
        return ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public static String staticGetVersion() {
        return VERSION;
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        if (!UNIQUE_ID.equals(uniqueId.toString())) {
            return null;
        }
        LOGGER.trace("discovering test classes and test methods ...");
        DefaultEngineContext engineContext = DefaultEngineContext.getInstance();
        DefaultEngineInterceptorContext engineInterceptorContext = new DefaultEngineInterceptorContext(engineContext);
        StatusEngineDescriptor engineDescriptor = new StatusEngineDescriptor(uniqueId, this.getId());
        try {
            EngineInterceptorRegistry.getInstance().onInitialize(engineInterceptorContext);
            new EngineDiscoveryRequestResolver().resolveSelectors(engineDiscoveryRequest, engineDescriptor);
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EngineException(t);
        }
        LOGGER.trace("discovered [%d] test classes", engineDescriptor.getChildren().size());
        return engineDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionRequest executionRequest) {
        if (executionRequest.getRootTestDescriptor().getChildren().isEmpty()) {
            return;
        }
        LOGGER.trace("executing test classes and test methods");
        if (LOGGER.isTraceEnabled()) {
            VerifyicaEngine.traceEngineDescriptor(executionRequest.getRootTestDescriptor());
        }
        DefaultEngineContext engineContext = DefaultEngineContext.getInstance();
        ExecutorService executorService = ExecutorServiceSupport.createExecutorService(VerifyicaEngine.getEngineClassParallelism());
        ThrowableCollector throwableCollector = new ThrowableCollector();
        DefaultEngineInterceptorContext engineInterceptorContext = new DefaultEngineInterceptorContext(engineContext);
        try {
            EngineInterceptorRegistry.getInstance().beforeExecute(engineInterceptorContext);
            executionRequest.getEngineExecutionListener().executionStarted(executionRequest.getRootTestDescriptor());
            List<ClassTestDescriptor> classTestDescriptors = VerifyicaEngine.getClassTestDescriptors(executionRequest);
            LOGGER.trace("classTestDescriptors size [%d]", classTestDescriptors.size());
            ArrayList<Future<?>> futures = new ArrayList();
            classTestDescriptors.forEach(classTestDescriptor -> futures.add(executorService.submit(NamedRunnable.wrap(new RunnableClassTestDescriptor(executionRequest, engineContext, (ClassTestDescriptor)((Object)classTestDescriptor)), "verifyica/" + HashSupport.alphanumeric(4)))));
            ExecutorServiceSupport.waitForAll(futures);
        }
        catch (Throwable t) {
            throwableCollector.add(t);
        }
        finally {
            executorService.shutdown();
            Store store = engineContext.getStore();
            for (Object key : store.keySet()) {
                Object value = store.get(key);
                if (!(value instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)value).close();
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    throwableCollector.add(t);
                }
            }
            store.clear();
            try {
                EngineInterceptorRegistry.getInstance().afterExecute(engineInterceptorContext);
            }
            catch (Throwable t) {
                throwableCollector.add(t);
            }
        }
        TestExecutionResult testExecutionResult = throwableCollector.toTestExecutionResult();
        executionRequest.getEngineExecutionListener().executionFinished(executionRequest.getRootTestDescriptor(), testExecutionResult);
        LOGGER.trace("execution done");
    }

    private static List<ClassTestDescriptor> getClassTestDescriptors(ExecutionRequest executionRequest) {
        return executionRequest.getRootTestDescriptor().getChildren().stream().filter(testDescriptor -> testDescriptor instanceof ClassTestDescriptor).map(testDescriptor -> (ClassTestDescriptor)((Object)testDescriptor)).collect(Collectors.toList());
    }

    private static int getEngineClassParallelism() {
        int engineParallelism = DefaultConfiguration.getInstance().getOptional("verifyica.engine.class.parallelism").map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 1) {
                    throw new EngineException(String.format("Invalid %s value [%d]", "verifyica.engine.class.parallelism", intValue));
                }
                return intValue;
            }
            catch (NumberFormatException e) {
                throw new EngineException(String.format("Invalid %s value [%s]", "verifyica.engine.class.parallelism", value), e);
            }
        }).orElse(Runtime.getRuntime().availableProcessors());
        LOGGER.trace("getEngineClassParallelism() [%s]", engineParallelism);
        return engineParallelism;
    }

    private static String version() {
        String value = UNKNOWN_VERSION;
        try (InputStream inputStream = VerifyicaEngine.class.getResourceAsStream(ENGINE_PROPERTIES_RESOURCE);){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                value = properties.getProperty(ENGINE_PROPERTIES_VERSION_KEY).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    private static void traceEngineDescriptor(TestDescriptor testDescriptor) {
        VerifyicaEngine.traceTestDescriptor(testDescriptor, 0);
    }

    private static void traceTestDescriptor(TestDescriptor testDescriptor, int level) {
        LOGGER.trace(String.join((CharSequence)" ", Collections.nCopies(level, " ")) + testDescriptor);
        testDescriptor.getChildren().forEach(testDescriptor1 -> VerifyicaEngine.traceTestDescriptor(testDescriptor1, level + 2));
    }
}

