/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.common;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class StateTracker<T> {
    private final Map<T, StateEntry<T>> map = new LinkedHashMap<T, StateEntry<T>>();
    private StateEntry<T> currentStateEntry;

    public void setState(T state) {
        ArgumentSupport.notNull(state, "state is null");
        if (this.map.containsKey(state)) {
            throw new IllegalStateException(String.format("Application error, state [%s] already encountered", state));
        }
        this.currentStateEntry = new StateEntry<T>(state);
        this.map.put(state, this.currentStateEntry);
    }

    public void setState(T state, Throwable throwable) {
        ArgumentSupport.notNull(state, "state is null");
        ArgumentSupport.notNull(throwable, "throwable is null");
        if (this.map.containsKey(state)) {
            throw new IllegalStateException(String.format("Application error, state [%s] already encountered", state));
        }
        this.currentStateEntry = new StateEntry<T>(state, throwable);
        this.map.put(state, this.currentStateEntry);
    }

    public boolean containsState(T state) {
        ArgumentSupport.notNull(state, "state is null");
        return this.map.containsKey(state);
    }

    public T getState() {
        return this.currentStateEntry.getState();
    }

    public boolean isState(T state) {
        if (state == null && this.currentStateEntry != null) {
            return false;
        }
        return this.currentStateEntry != null && state.equals(this.currentStateEntry.getState());
    }

    public void clear() {
        this.map.clear();
    }

    public Optional<StateEntry<T>> getStateWithThrowable() {
        for (Map.Entry<T, StateEntry<T>> mapEntry : this.map.entrySet()) {
            StateEntry<T> stateEntry = mapEntry.getValue();
            if (!stateEntry.hasThrowable()) continue;
            return Optional.of(stateEntry);
        }
        return Optional.empty();
    }

    public Collection<StateEntry<T>> getObservedStates() {
        return new LinkedHashSet<StateEntry<T>>(this.map.values());
    }

    public String toString() {
        return "StateTracker{map=" + this.map + ", lastStateEntry=" + this.currentStateEntry + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateTracker that = (StateTracker)o;
        return Objects.equals(this.map, that.map) && Objects.equals(this.currentStateEntry, that.currentStateEntry);
    }

    public int hashCode() {
        return Objects.hash(this.map, this.currentStateEntry);
    }

    public static class StateEntry<T> {
        private final T state;
        private final Throwable throwable;

        public StateEntry(T state) {
            this.state = state;
            this.throwable = null;
        }

        public StateEntry(T state, Throwable throwable) {
            this.state = state;
            this.throwable = throwable;
        }

        public T getState() {
            return this.state;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean hasThrowable() {
            return this.throwable != null;
        }

        public String toString() {
            return "Entry{state=" + this.state + ", throwable=" + this.throwable + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateEntry stateEntry = (StateEntry)o;
            return Objects.equals(this.state, stateEntry.state) && Objects.equals(this.throwable, stateEntry.throwable);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.throwable);
        }
    }
}

