/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.platform.engine.TestExecutionResult;

public class ThrowableCollector {
    private final List<Throwable> throwables = Collections.synchronizedList(new ArrayList());

    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable t) {
            this.throwables.add(t);
        }
    }

    public void add(Throwable throwable) {
        if (throwable != null) {
            this.throwables.add(throwable);
        }
    }

    public void addAll(List<Throwable> throwables) {
        if (throwables != null) {
            throwables.forEach(throwable -> this.add((Throwable)throwable));
        }
    }

    public void add(ThrowableCollector throwableCollector) {
        this.throwables.addAll(throwableCollector.throwables);
    }

    public boolean isEmpty() {
        return this.throwables.isEmpty();
    }

    public Throwable getThrowable() {
        return !this.throwables.isEmpty() ? this.throwables.get(0) : null;
    }

    public void clear() {
        this.throwables.clear();
    }

    public void assertEmpty() throws Throwable {
        Throwable throwable = this.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
    }

    public TestExecutionResult toTestExecutionResult() {
        Throwable throwable = this.getThrowable();
        if (throwable != null) {
            return TestExecutionResult.failed((Throwable)throwable);
        }
        return TestExecutionResult.successful();
    }

    public static interface Executable {
        public void execute() throws Throwable;
    }
}

