/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.antublue.verifyica.api.Configuration;
import org.antublue.verifyica.engine.exception.EngineConfigurationException;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class DefaultConfiguration
implements Configuration {
    private static final String VERIFYICA_CONFIGURATION_TRACE = "VERIFYICA_CONFIGURATION_TRACE";
    private static final String VERIFYICA_PROPERTIES_FILENAME = "verifyica.properties";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private static final boolean IS_TRACE_ENABLED = "true".equals(System.getenv().get("VERIFYICA_CONFIGURATION_TRACE"));
    private final Map<String, String> map;
    private final ReadWriteLock readWriteLock;

    private DefaultConfiguration() {
        this.map = new TreeMap<String, String>();
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.loadConfiguration();
    }

    private DefaultConfiguration(TreeMap<String, String> map) {
        this.map = map;
        this.readWriteLock = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> put(String key, String value) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        try {
            this.getReadWriteLock().writeLock().lock();
            Optional<String> optional = Optional.ofNullable(this.map.put(key.trim(), value));
            return optional;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public String get(String key) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        try {
            this.getReadWriteLock().readLock().lock();
            String string = this.map.get(key.trim());
            return string;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public Optional<String> getOptional(String key) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        try {
            this.getReadWriteLock().readLock().lock();
            Optional<String> optional = Optional.ofNullable(this.map.get(key.trim()));
            return optional;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> computeIfAbsent(String key, Function<String, String> transformer) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        ArgumentSupport.notNull(transformer, "transformer is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            Optional<String> optional = Optional.ofNullable(this.map.computeIfAbsent(key.trim(), transformer));
            return optional;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public boolean containsKey(String key) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        try {
            this.getReadWriteLock().readLock().lock();
            boolean bl = this.map.containsKey(key.trim());
            return bl;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public String remove(String key) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        try {
            this.getReadWriteLock().writeLock().lock();
            String string = this.map.remove(key.trim());
            return string;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Optional<String> removeOptional(String key) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        try {
            this.getReadWriteLock().writeLock().lock();
            Optional<String> optional = Optional.ofNullable(this.map.remove(key.trim()));
            return optional;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public int size() {
        try {
            this.getReadWriteLock().readLock().lock();
            int n = this.map.size();
            return n;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Configuration clear() {
        try {
            this.getReadWriteLock().writeLock().lock();
            this.map.clear();
            DefaultConfiguration defaultConfiguration = this;
            return defaultConfiguration;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Set<String> keySet() {
        try {
            this.getReadWriteLock().readLock().lock();
            TreeSet<String> treeSet = new TreeSet<String>(this.map.keySet());
            return treeSet;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration merge(Map<String, String> map) {
        ArgumentSupport.notNull(map, "map is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || key.trim().isEmpty() || value == null || value.trim().isEmpty()) continue;
                this.map.put(key.trim(), value.trim());
            }
            DefaultConfiguration defaultConfiguration = this;
            return defaultConfiguration;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Configuration merge(Configuration configuration) {
        ArgumentSupport.notNull(configuration, "configuration is null");
        try {
            configuration.getReadWriteLock().readLock().lock();
            this.getReadWriteLock().writeLock().lock();
            configuration.keySet().forEach(key -> configuration.getOptional(key).ifPresent(value -> this.map.put((String)key, (String)value)));
            DefaultConfiguration defaultConfiguration = this;
            return defaultConfiguration;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
            configuration.getReadWriteLock().readLock().unlock();
        }
    }

    public Configuration replace(Map<String, String> map) {
        ArgumentSupport.notNull(map, "map is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.clear();
            Configuration configuration = this.merge(map);
            return configuration;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Configuration replace(Configuration configuration) {
        ArgumentSupport.notNull(configuration, "configuration is null");
        try {
            configuration.getReadWriteLock().readLock().lock();
            this.getReadWriteLock().writeLock().lock();
            this.clear();
            Configuration configuration2 = this.merge(configuration);
            return configuration2;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
            configuration.getReadWriteLock().readLock().unlock();
        }
    }

    public Configuration duplicate() {
        try {
            this.getReadWriteLock().readLock().lock();
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration(new TreeMap<String, String>(this.map));
            return defaultConfiguration;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public String toString() {
        return "DefaultConfiguration{map=" + this.map + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConfiguration that = (DefaultConfiguration)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    public static DefaultConfiguration getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private void loadConfiguration() {
        block16: {
            if (IS_TRACE_ENABLED) {
                DefaultConfiguration.trace("loadConfiguration()");
            }
            try {
                Optional<File> optional = Optional.ofNullable(System.getProperties().get(VERIFYICA_PROPERTIES_FILENAME)).map(value -> new File(value.toString()).getAbsoluteFile());
                if (!optional.isPresent()) {
                    optional = DefaultConfiguration.find(Paths.get(".", new String[0]), VERIFYICA_PROPERTIES_FILENAME);
                }
                if (optional.isPresent()) {
                    if (IS_TRACE_ENABLED) {
                        DefaultConfiguration.trace("loading [" + optional.get().getAbsolutePath() + "]");
                    }
                    Properties properties = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(optional.get().toPath(), StandardCharsets.UTF_8);){
                        properties.load(reader);
                    }
                    if (IS_TRACE_ENABLED) {
                        DefaultConfiguration.trace("loaded [" + optional.get().getAbsolutePath() + "]");
                    }
                    properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.map.put((String)key, (String)value)));
                    this.map.put(VERIFYICA_PROPERTIES_FILENAME, optional.get().getAbsolutePath());
                    break block16;
                }
                if (IS_TRACE_ENABLED) {
                    DefaultConfiguration.trace("no configuration properties file found");
                }
            }
            catch (IOException e) {
                throw new EngineConfigurationException("Exception loading configuration properties", e);
            }
        }
        if (IS_TRACE_ENABLED) {
            DefaultConfiguration.trace("configuration properties ...");
            this.map.keySet().forEach(key -> DefaultConfiguration.trace("configuration property [" + key + "] = [" + this.map.get(key) + "]"));
        }
    }

    private static Optional<File> find(Path path, String filename) {
        Path currentPath = path.toAbsolutePath().normalize();
        while (true) {
            File file;
            if (IS_TRACE_ENABLED) {
                String currentPathString = currentPath.toString();
                if (!currentPathString.endsWith("/")) {
                    currentPathString = currentPathString + "/";
                }
                if (IS_TRACE_ENABLED) {
                    DefaultConfiguration.trace("searching path [" + currentPathString + "]");
                }
            }
            if ((file = new File(currentPath.toAbsolutePath() + File.separator + filename)).exists() && file.isFile() && file.canRead()) {
                if (IS_TRACE_ENABLED) {
                    DefaultConfiguration.trace("found [" + file.getAbsoluteFile() + "]");
                }
                return Optional.of(file);
            }
            if ((currentPath = currentPath.getParent()) == null) break;
            currentPath = currentPath.toAbsolutePath().normalize();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(String message) {
        if (IS_TRACE_ENABLED) {
            String dateTime;
            SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                dateTime = SIMPLE_DATE_FORMAT.format(new Date());
            }
            System.out.println(dateTime + " | " + Thread.currentThread().getName() + " | TRACE | " + DefaultConfiguration.class.getName() + " | " + message + " ");
        }
    }

    private static class SingletonHolder {
        private static final DefaultConfiguration SINGLETON = new DefaultConfiguration();

        private SingletonHolder() {
        }
    }
}

