/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.configuration;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.antublue.verifyica.api.Configuration;
import org.antublue.verifyica.engine.support.ArgumentSupport;
import org.junit.platform.engine.ConfigurationParameters;

public class DefaultConfigurationParameters
implements ConfigurationParameters {
    private final Configuration configuration;

    public DefaultConfigurationParameters(Configuration configuration) {
        ArgumentSupport.notNull(configuration, "configuration is null");
        this.configuration = configuration;
    }

    public Optional<String> get(String key) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        return this.configuration.getOptional(key.trim());
    }

    public Optional<Boolean> getBoolean(String key) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        return Optional.ofNullable(this.configuration.get(key.trim())).map("true"::equals);
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        ArgumentSupport.notNullOrEmpty(key, "key is null", "key is empty");
        ArgumentSupport.notNull(transformer, "transformer is null");
        String value = this.configuration.get(key.trim());
        return value != null ? Optional.ofNullable(transformer.apply(value)) : Optional.empty();
    }

    public int size() {
        return this.configuration.size();
    }

    public Set<String> keySet() {
        return this.configuration.keySet();
    }
}

