/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.context;

import java.util.Objects;
import org.antublue.verifyica.api.Argument;
import org.antublue.verifyica.api.ArgumentContext;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.Store;
import org.antublue.verifyica.engine.context.DefaultStore;
import org.antublue.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class DefaultArgumentContext
implements ArgumentContext {
    private final ClassContext classContext;
    private final ArgumentTestDescriptor argumentTestDescriptor;
    private final Store store;

    public DefaultArgumentContext(ClassContext classContext, ArgumentTestDescriptor argumentTestDescriptor) {
        this.classContext = classContext;
        this.argumentTestDescriptor = argumentTestDescriptor;
        this.store = new DefaultStore();
    }

    public ClassContext getClassContext() {
        return this.classContext;
    }

    public Argument<?> getTestArgument() {
        return this.getTestArgument(Object.class);
    }

    public <T> Argument<T> getTestArgument(Class<T> type) {
        ArgumentSupport.notNull(type, "type is null;");
        Argument<?> argument = this.argumentTestDescriptor.getTestArgument();
        return Argument.of((String)argument.getName(), type.cast(argument.getPayload()));
    }

    public Store getStore() {
        return this.store;
    }

    public String toString() {
        return "DefaultArgumentContext{classContext=" + this.classContext + ", argumentTestDescriptor=" + (Object)((Object)this.argumentTestDescriptor) + ", store=" + this.store + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultArgumentContext that = (DefaultArgumentContext)o;
        return Objects.equals(this.classContext, that.classContext) && Objects.equals((Object)this.argumentTestDescriptor, (Object)that.argumentTestDescriptor) && Objects.equals(this.store, that.store);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.classContext, this.argumentTestDescriptor, this.store});
    }
}

