/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.context;

import java.util.Objects;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.EngineContext;
import org.antublue.verifyica.api.Store;
import org.antublue.verifyica.engine.context.DefaultStore;
import org.antublue.verifyica.engine.descriptor.ClassTestDescriptor;

public class DefaultClassContext
implements ClassContext {
    private final EngineContext engineContext;
    private final ClassTestDescriptor classTestDescriptor;
    private final Store store;

    public DefaultClassContext(EngineContext engineContext, ClassTestDescriptor classTestDescriptor) {
        this.engineContext = engineContext;
        this.classTestDescriptor = classTestDescriptor;
        this.store = new DefaultStore();
    }

    public EngineContext getEngineContext() {
        return this.engineContext;
    }

    public Store getStore() {
        return this.store;
    }

    public Class<?> getTestClass() {
        return this.classTestDescriptor.getTestClass();
    }

    public <T> Class<T> getTestClass(Class<T> type) {
        return this.getTestClass().asSubclass(type);
    }

    public String getTestClassDisplayName() {
        return this.classTestDescriptor.getDisplayName();
    }

    public Object getTestInstance() {
        throw new IllegalStateException("Not implemented");
    }

    public <T> T getTestInstance(Class<T> type) {
        throw new IllegalStateException("Not implemented");
    }

    public int getTestArgumentParallelism() {
        return this.classTestDescriptor.getTestArgumentParallelism();
    }

    public String toString() {
        return "DefaultClassContext{engineContext=" + this.engineContext + ", classTestDescriptor=" + (Object)((Object)this.classTestDescriptor) + ", store=" + this.store + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultClassContext that = (DefaultClassContext)o;
        return Objects.equals(this.engineContext, that.engineContext) && Objects.equals((Object)this.classTestDescriptor, (Object)that.classTestDescriptor) && Objects.equals(this.store, that.store);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.engineContext, this.classTestDescriptor, this.store});
    }
}

