/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.context;

import java.util.Objects;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.EngineContext;
import org.antublue.verifyica.api.Store;

public class DefaultClassInstanceContext
implements ClassContext {
    private final ClassContext classContext;
    private final Object testInstance;

    public DefaultClassInstanceContext(ClassContext classContext, Object testInstance) {
        this.classContext = classContext;
        this.testInstance = testInstance;
    }

    public EngineContext getEngineContext() {
        return this.classContext.getEngineContext();
    }

    public Store getStore() {
        return this.classContext.getStore();
    }

    public Class<?> getTestClass() {
        return this.classContext.getTestClass();
    }

    public <T> Class<T> getTestClass(Class<T> type) {
        return this.getTestClass().asSubclass(type);
    }

    public String getTestClassDisplayName() {
        return this.classContext.getTestClassDisplayName();
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public <T> T getTestInstance(Class<T> type) {
        return type.cast(this.getTestInstance());
    }

    public int getTestArgumentParallelism() {
        return this.classContext.getTestArgumentParallelism();
    }

    public String toString() {
        return "DefaultClassInstanceContext{classContext=" + this.classContext + ", testInstance=" + this.testInstance + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultClassInstanceContext that = (DefaultClassInstanceContext)o;
        return Objects.equals(this.classContext, that.classContext) && Objects.equals(this.testInstance, that.testInstance);
    }

    public int hashCode() {
        return Objects.hash(this.classContext, this.testInstance);
    }
}

