/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.antublue.verifyica.api.Store;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class DefaultStore
implements Store {
    private final Map<Object, Object> map;
    private final ReadWriteLock readWriteLock;

    public DefaultStore() {
        this(new HashMap<Object, Object>());
    }

    private DefaultStore(Map<Object, Object> map) {
        ArgumentSupport.notNull(map, "map is null");
        this.map = map;
        this.readWriteLock = new ReentrantReadWriteLock(true);
    }

    public void put(Object key, Object value) {
        ArgumentSupport.notNull(key, "key is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.map.put(key, value);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Object get(Object key) {
        ArgumentSupport.notNull(key, "key is null");
        try {
            this.getReadWriteLock().readLock().lock();
            Object object = this.map.get(key);
            return object;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V get(Object key, Class<V> type) {
        ArgumentSupport.notNull(key, "key is null");
        ArgumentSupport.notNull(type, "type is null");
        try {
            this.getReadWriteLock().readLock().lock();
            V v = type.cast(this.map.get(key));
            return v;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public Optional<Object> getOptional(Object key) {
        ArgumentSupport.notNull(key, "key is null");
        try {
            this.getReadWriteLock().readLock().lock();
            Optional<Object> optional = Optional.ofNullable(this.map.get(key));
            return optional;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Optional<V> getOptional(Object key, Class<V> type) {
        ArgumentSupport.notNull(key, "key is null");
        ArgumentSupport.notNull(type, "type is null");
        try {
            this.getReadWriteLock().readLock().lock();
            Optional<V> optional = Optional.ofNullable(type.cast(this.map.get(key)));
            return optional;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public Object getOrDefault(Object key, Object defaultValue) {
        ArgumentSupport.notNull(key, "key is null");
        Object value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public <V> V getOrDefault(Object key, V defaultValue, Class<V> type) {
        ArgumentSupport.notNull(key, "key is null");
        ArgumentSupport.notNull(type, "type is null");
        Object value = this.get(key);
        if (value != null) {
            return (V)value;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object computeIfAbsent(Object key, Function<Object, Object> function) {
        ArgumentSupport.notNull(key, "key is null");
        ArgumentSupport.notNull(function, "function is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            Object value = this.get(key);
            if (value == null) {
                value = function.apply(key);
                if (value == null) {
                    throw new IllegalStateException("Function returned a null value");
                }
                this.put(key, value);
            }
            Object object = value;
            return object;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V computeIfAbsent(Object key, Function<Object, V> function, Class<V> type) {
        ArgumentSupport.notNull(key, "key is null");
        ArgumentSupport.notNull(function, "function is null");
        ArgumentSupport.notNull(type, "type is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            Object value = this.get(key);
            if (value == null) {
                value = function.apply(key);
                if (value == null) {
                    throw new IllegalStateException("Function returned a null value");
                }
                this.put(key, value);
            }
            Object object = value;
            return (V)object;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public boolean containsKey(Object key) {
        ArgumentSupport.notNull(key, "key is null");
        try {
            this.getReadWriteLock().readLock().lock();
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public Object remove(Object key) {
        ArgumentSupport.notNull(key, "key is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            Object object = this.map.remove(key);
            return object;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V remove(Object key, Class<V> type) {
        ArgumentSupport.notNull(key, "key is null");
        ArgumentSupport.notNull(type, "type is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            V v = type.cast(this.map.remove(key));
            return v;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Optional<Object> removeOptional(Object key) {
        ArgumentSupport.notNull(key, "key is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            Optional<Object> optional = Optional.ofNullable(this.map.remove(key));
            return optional;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Optional<V> removeOptional(Object key, Class<V> type) {
        ArgumentSupport.notNull(key, "key is null");
        ArgumentSupport.notNull(type, "type is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            Optional<V> optional = Optional.ofNullable(type.cast(this.map.remove(key)));
            return optional;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public int size() {
        try {
            this.getReadWriteLock().readLock().lock();
            int n = this.map.size();
            return n;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Store clear() {
        try {
            this.getReadWriteLock().writeLock().lock();
            this.map.clear();
            DefaultStore defaultStore = this;
            return defaultStore;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Store replace(Map<Object, Object> map) {
        ArgumentSupport.notNull(map, "map is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.clear();
            this.merge(map);
            DefaultStore defaultStore = this;
            return defaultStore;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Store replace(Store store) {
        ArgumentSupport.notNull(store, "store is null");
        try {
            store.getReadWriteLock().readLock().lock();
            this.getReadWriteLock().writeLock().lock();
            this.clear();
            this.merge(store);
            DefaultStore defaultStore = this;
            return defaultStore;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
            store.getReadWriteLock().readLock().unlock();
        }
    }

    public Store merge(Map<Object, Object> map) {
        ArgumentSupport.notNull(map, "map is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.map.putAll(map);
            DefaultStore defaultStore = this;
            return defaultStore;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public Store merge(Store store) {
        ArgumentSupport.notNull(store, "store is null");
        try {
            store.getReadWriteLock().readLock().lock();
            this.getReadWriteLock().writeLock().lock();
            store.keySet().forEach(key -> this.put(key, store.get(key)));
            DefaultStore defaultStore = this;
            return defaultStore;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
            store.getReadWriteLock().readLock().unlock();
        }
    }

    public Store duplicate() {
        try {
            this.getReadWriteLock().readLock().lock();
            DefaultStore defaultStore = new DefaultStore(new TreeMap<Object, Object>(this.map));
            return defaultStore;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public Set<Object> keySet() {
        try {
            this.getReadWriteLock().readLock().lock();
            HashSet<Object> hashSet = new HashSet<Object>(this.map.keySet());
            return hashSet;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public String toString() {
        return "DefaultStore{map=" + this.map + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultStore that = (DefaultStore)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }
}

