/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.context;

import java.util.Objects;
import org.antublue.verifyica.api.Argument;
import org.antublue.verifyica.api.ArgumentContext;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.Store;
import org.antublue.verifyica.engine.context.ImmutableClassContext;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class ImmutableArgumentContext
implements ArgumentContext {
    private final ArgumentContext argumentContext;
    private final ClassContext classContext;

    private ImmutableArgumentContext(ArgumentContext argumentContext) {
        this.argumentContext = argumentContext;
        this.classContext = ImmutableClassContext.wrap(argumentContext.getClassContext());
    }

    public ClassContext getClassContext() {
        return this.classContext;
    }

    public Argument<?> getTestArgument() {
        return this.getTestArgument(Object.class);
    }

    public <T> Argument<T> getTestArgument(Class<T> type) {
        ArgumentSupport.notNull(type, "type is null");
        return this.argumentContext.getTestArgument(type);
    }

    public Store getStore() {
        return this.argumentContext.getStore();
    }

    public String toString() {
        return "ImmutableArgumentContext{argumentContext=" + this.argumentContext + ", classContext=" + this.classContext + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableArgumentContext that = (ImmutableArgumentContext)o;
        return Objects.equals(this.argumentContext, that.argumentContext) && Objects.equals(this.classContext, that.classContext);
    }

    public int hashCode() {
        return Objects.hash(this.argumentContext, this.classContext);
    }

    public static ArgumentContext wrap(ArgumentContext argumentContext) {
        return new ImmutableArgumentContext(argumentContext);
    }
}

