/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.context;

import java.util.Objects;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.EngineContext;
import org.antublue.verifyica.api.Store;

public class ImmutableClassContext
implements ClassContext {
    private final ClassContext classContext;

    private ImmutableClassContext(ClassContext classContext) {
        this.classContext = classContext;
    }

    public EngineContext getEngineContext() {
        return this.classContext.getEngineContext();
    }

    public Store getStore() {
        return this.classContext.getStore();
    }

    public Class<?> getTestClass() {
        return this.classContext.getTestClass();
    }

    public <T> Class<T> getTestClass(Class<T> type) {
        return this.classContext.getTestClass(type);
    }

    public String getTestClassDisplayName() {
        return this.classContext.getTestClassDisplayName();
    }

    public Object getTestInstance() {
        return this.classContext.getTestInstance();
    }

    public <T> T getTestInstance(Class<T> type) {
        return (T)this.classContext.getTestInstance(type);
    }

    public int getTestArgumentParallelism() {
        return this.classContext.getTestArgumentParallelism();
    }

    public String toString() {
        return "ImmutableClassContext{classContext=" + this.classContext + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableClassContext that = (ImmutableClassContext)o;
        return Objects.equals(this.classContext, that.classContext);
    }

    public int hashCode() {
        return Objects.hashCode(this.classContext);
    }

    public static ClassContext wrap(ClassContext classContext) {
        return new ImmutableClassContext(classContext);
    }
}

