/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.verifyica.api.Argument;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ArgumentTestDescriptor
extends AbstractTestDescriptor {
    private final Class<?> testClass;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;
    private final Argument<?> testArgument;

    public ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument<?> testArgument, List<Method> beforeAllMethods, List<Method> afterAllMethods) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.beforeAllMethods = beforeAllMethods;
        this.afterAllMethods = afterAllMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    public Argument<?> getTestArgument() {
        return this.testArgument;
    }

    public List<Method> getBeforeAllMethods() {
        return this.beforeAllMethods;
    }

    public List<Method> getAfterAllMethods() {
        return this.afterAllMethods;
    }
}

