/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ClassTestDescriptor
extends AbstractTestDescriptor {
    private final int testArgumentParallelism;
    private final Class<?> testClass;
    private final List<Method> prepareMethods;
    private final List<Method> concludeMethods;

    public ClassTestDescriptor(UniqueId uniqueId, String displayName, int testArgumentParallelism, Class<?> testClass, List<Method> prepareMethods, List<Method> concludeMethods) {
        super(uniqueId, displayName);
        this.testArgumentParallelism = testArgumentParallelism;
        this.testClass = testClass;
        this.prepareMethods = prepareMethods;
        this.concludeMethods = concludeMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    public int getTestArgumentParallelism() {
        return this.testArgumentParallelism;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public List<Method> getPrepareMethods() {
        return this.prepareMethods;
    }

    public List<Method> getConcludeMethods() {
        return this.concludeMethods;
    }

    public String toString() {
        return "ClassTestDescriptor{testClass=" + this.testClass + ", parallelism=" + this.testArgumentParallelism + ", prepareMethods=" + this.prepareMethods + ", concludeMethods=" + this.concludeMethods + '}';
    }
}

