/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.descriptor;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import org.antublue.verifyica.api.Context;
import org.antublue.verifyica.engine.common.StopWatch;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public abstract class ExecutableTestDescriptor
extends AbstractTestDescriptor {
    protected static final ToExecutableTestDescriptor TO_EXECUTABLE_TEST_DESCRIPTOR = new ToExecutableTestDescriptor();
    private static final Set<String> pruneRegexPatterns = new LinkedHashSet<String>();
    private final StopWatch stopWatch = new StopWatch();

    protected ExecutableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public abstract Class<?> getTestClass();

    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public abstract void execute(ExecutionRequest var1, Context var2);

    public abstract void skip(ExecutionRequest var1, Context var2);

    static {
        pruneRegexPatterns.add("com.antublue.verifyica.engine..*");
        pruneRegexPatterns.add("com\\.antublue\\.verifyica\\.engine\\.interceptor\\..*");
    }

    public static class ToExecutableTestDescriptor
    implements Function<TestDescriptor, ExecutableTestDescriptor> {
        @Override
        public ExecutableTestDescriptor apply(TestDescriptor testDescriptor) {
            return testDescriptor instanceof ExecutableTestDescriptor ? (ExecutableTestDescriptor)testDescriptor : null;
        }
    }
}

