/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.descriptor.execution;

import org.antublue.verifyica.engine.support.ArgumentSupport;

public class NamedRunnable
implements Runnable {
    private final Runnable runnable;
    private final String threadName;

    public NamedRunnable(Runnable runnable, String threadName) {
        this.runnable = runnable;
        this.threadName = threadName;
    }

    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String originalThreadName = currentThread.getName();
        try {
            currentThread.setName(this.threadName);
            this.runnable.run();
        }
        finally {
            currentThread.setName(originalThreadName);
        }
    }

    public static Runnable wrap(Runnable runnable, String threadName) {
        ArgumentSupport.notNull(runnable, "runnable is null");
        ArgumentSupport.notNullOrEmpty(threadName, "threadName is null", "threadName is empty");
        return new NamedRunnable(runnable, threadName.trim());
    }
}

