/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.descriptor.execution;

import java.lang.reflect.Method;
import java.util.List;
import org.antublue.verifyica.api.Argument;
import org.antublue.verifyica.api.ArgumentContext;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.Store;
import org.antublue.verifyica.engine.common.StateTracker;
import org.antublue.verifyica.engine.context.DefaultArgumentContext;
import org.antublue.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.antublue.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.antublue.verifyica.engine.descriptor.execution.AbstractRunnableTestDescriptor;
import org.antublue.verifyica.engine.descriptor.execution.RunnableTestMethodTestDescriptor;
import org.antublue.verifyica.engine.interceptor.ClassInterceptorRegistry;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class RunnableArgumentTestDescriptor
extends AbstractRunnableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnableArgumentTestDescriptor.class);
    private final ExecutionRequest executionRequest;
    private final ArgumentTestDescriptor argumentTestDescriptor;
    private final List<Method> beforeAllMethods;
    private final List<TestMethodTestDescriptor> testMethodTestDescriptors;
    private final List<Method> afterAllMethods;
    private final ArgumentContext argumentContext;

    public RunnableArgumentTestDescriptor(ExecutionRequest executionRequest, ClassContext classContext, ArgumentTestDescriptor argumentTestDescriptor) {
        this.executionRequest = executionRequest;
        this.argumentTestDescriptor = argumentTestDescriptor;
        this.beforeAllMethods = argumentTestDescriptor.getBeforeAllMethods();
        this.testMethodTestDescriptors = RunnableArgumentTestDescriptor.getTestMethodTestDescriptors(argumentTestDescriptor);
        this.afterAllMethods = argumentTestDescriptor.getAfterAllMethods();
        this.argumentContext = new DefaultArgumentContext(classContext, argumentTestDescriptor);
    }

    @Override
    public void execute() {
        LOGGER.trace("execute() %s", new Object[]{this.argumentTestDescriptor});
        this.executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this.argumentTestDescriptor);
        StateTracker<String> stateTracker = new StateTracker<String>();
        try {
            stateTracker.setState("beforeAll");
            ClassInterceptorRegistry.getInstance().beforeAll(this.argumentContext, this.beforeAllMethods);
            stateTracker.setState("beforeAll.success");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            stateTracker.setState("beforeAll.failure", t);
        }
        if (stateTracker.isState("beforeAll.success")) {
            try {
                stateTracker.setState("execute");
                this.testMethodTestDescriptors.forEach(methodTestDescriptor -> new RunnableTestMethodTestDescriptor(this.executionRequest, this.argumentContext, (TestMethodTestDescriptor)((Object)methodTestDescriptor)).run());
                stateTracker.setState("execute.success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("execute.failure", t);
            }
        }
        if (stateTracker.containsState("beforeAll.failure")) {
            try {
                stateTracker.setState("skip");
                this.testMethodTestDescriptors.forEach(methodTestDescriptor -> new RunnableTestMethodTestDescriptor(this.executionRequest, this.argumentContext, (TestMethodTestDescriptor)((Object)methodTestDescriptor)).skip());
                stateTracker.setState("skip.success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("skip.failure", t);
            }
        }
        try {
            stateTracker.setState("afterAll");
            ClassInterceptorRegistry.getInstance().afterAll(this.argumentContext, this.afterAllMethods);
            stateTracker.setState("afterAll.success");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            stateTracker.setState("afterAll.failure", t);
        }
        Argument testArgument = this.argumentContext.getTestArgument();
        if (testArgument instanceof AutoCloseable) {
            try {
                stateTracker.setState("argumentAutoClose(" + testArgument.getName() + ")");
                ((AutoCloseable)testArgument).close();
                stateTracker.setState("argumentAutoClose(" + testArgument.getName() + ").success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("argumentAutoClose(" + testArgument.getName() + ").failure");
            }
        }
        Store store = this.argumentContext.getStore();
        for (Object key : store.keySet()) {
            Object value = store.get(key);
            if (!(value instanceof AutoCloseable)) continue;
            try {
                stateTracker.setState("storeAutoClose(" + key + ")");
                ((AutoCloseable)value).close();
                stateTracker.setState("storeAutoClose(" + key + ").success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("storeAutoClose(" + key + ").failure");
            }
        }
        store.clear();
        LOGGER.trace("state tracker %s [%s]", new Object[]{this.argumentTestDescriptor, stateTracker});
        TestExecutionResult testExecutionResult = stateTracker.getStateWithThrowable().map(stateEntry -> TestExecutionResult.failed((Throwable)stateEntry.getThrowable())).orElse(TestExecutionResult.successful());
        this.executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this.argumentTestDescriptor, testExecutionResult);
    }

    @Override
    public void skip() {
        LOGGER.trace("skip() %s", new Object[]{this.argumentTestDescriptor});
        this.executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this.argumentTestDescriptor);
        this.testMethodTestDescriptors.forEach(methodTestDescriptor -> new RunnableTestMethodTestDescriptor(this.executionRequest, this.argumentContext, (TestMethodTestDescriptor)((Object)methodTestDescriptor)).skip());
        this.executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this.argumentTestDescriptor, TestExecutionResult.aborted(null));
    }
}

