/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.descriptor.execution;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.EngineContext;
import org.antublue.verifyica.api.Store;
import org.antublue.verifyica.engine.common.StateTracker;
import org.antublue.verifyica.engine.configuration.DefaultConfiguration;
import org.antublue.verifyica.engine.context.DefaultClassContext;
import org.antublue.verifyica.engine.context.DefaultClassInstanceContext;
import org.antublue.verifyica.engine.context.ImmutableClassContext;
import org.antublue.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.antublue.verifyica.engine.descriptor.ClassTestDescriptor;
import org.antublue.verifyica.engine.descriptor.execution.AbstractRunnableTestDescriptor;
import org.antublue.verifyica.engine.descriptor.execution.NamedRunnable;
import org.antublue.verifyica.engine.descriptor.execution.RunnableArgumentTestDescriptor;
import org.antublue.verifyica.engine.exception.EngineException;
import org.antublue.verifyica.engine.interceptor.ClassInterceptorRegistry;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.antublue.verifyica.engine.support.ExecutorServiceSupport;
import org.antublue.verifyica.engine.support.HashSupport;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class RunnableClassTestDescriptor
extends AbstractRunnableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnableClassTestDescriptor.class);
    private static final ExecutorService EXECUTOR_SERVICE = ExecutorServiceSupport.createExecutorService(RunnableClassTestDescriptor.getEngineArgumentParallelism());
    private final ExecutionRequest executionRequest;
    private final ClassTestDescriptor classTestDescriptor;
    private final Class<?> testClass;
    private final List<Method> prepareMethods;
    private final List<ArgumentTestDescriptor> argumentTestDescriptors;
    private final List<Method> concludeMethods;
    private final ClassContext classContext;
    private DefaultClassInstanceContext classInstanceContext;

    public RunnableClassTestDescriptor(ExecutionRequest executionRequest, EngineContext engineContext, ClassTestDescriptor classTestDescriptor) {
        this.executionRequest = executionRequest;
        this.classTestDescriptor = classTestDescriptor;
        this.testClass = classTestDescriptor.getTestClass();
        this.prepareMethods = classTestDescriptor.getPrepareMethods();
        this.argumentTestDescriptors = RunnableClassTestDescriptor.getArgumentTestDescriptors(classTestDescriptor);
        this.concludeMethods = classTestDescriptor.getConcludeMethods();
        this.classContext = new DefaultClassContext(engineContext, classTestDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        LOGGER.trace("execute() %s", new Object[]{this.classTestDescriptor});
        this.executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this.classTestDescriptor);
        StateTracker<String> stateTracker = new StateTracker<String>();
        try {
            stateTracker.setState("instantiate");
            Throwable throwable = null;
            Object testInstance = null;
            try {
                ClassInterceptorRegistry.getInstance().beforeInstantiate(this.classContext.getEngineContext(), this.testClass);
                testInstance = this.testClass.getDeclaredConstructor(null).newInstance(null);
                this.classInstanceContext = new DefaultClassInstanceContext(this.classContext, testInstance);
            }
            catch (Throwable t) {
                throwable = t;
            }
            ClassInterceptorRegistry.getInstance().afterInstantiate(this.classContext.getEngineContext(), this.testClass, testInstance, throwable);
            stateTracker.setState("instantiate.success");
        }
        catch (Throwable t) {
            stateTracker.setState("instantiate.failure", t);
        }
        if (stateTracker.isState("instantiate.success")) {
            try {
                stateTracker.setState("prepare");
                ClassInterceptorRegistry.getInstance().prepare(ImmutableClassContext.wrap(this.classInstanceContext), this.prepareMethods);
                stateTracker.setState("prepare.success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("prepare.failure", t);
            }
        }
        if (stateTracker.containsState("prepare.success")) {
            try {
                stateTracker.setState("execute");
                ExecutorService executorService = ExecutorServiceSupport.createSemaphoreExecutorService(EXECUTOR_SERVICE, this.classTestDescriptor.getTestArgumentParallelism());
                ArrayList futures = new ArrayList();
                this.argumentTestDescriptors.forEach(argumentTestDescriptor -> futures.add(executorService.submit(NamedRunnable.wrap(new RunnableArgumentTestDescriptor(this.executionRequest, this.classInstanceContext, (ArgumentTestDescriptor)((Object)argumentTestDescriptor)), Thread.currentThread().getName() + "/" + HashSupport.alphanumeric(4)))));
                ExecutorServiceSupport.waitForAll(futures);
                stateTracker.setState("execute.success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("execute.failure", t);
            }
        }
        if (stateTracker.containsState("prepare.failure")) {
            try {
                stateTracker.setState("skip");
                this.argumentTestDescriptors.forEach(argumentTestDescriptor -> new RunnableArgumentTestDescriptor(this.executionRequest, this.classInstanceContext, (ArgumentTestDescriptor)((Object)argumentTestDescriptor)).skip());
                this.executionRequest.getEngineExecutionListener().executionSkipped((TestDescriptor)this.classTestDescriptor, "Skipped");
                stateTracker.setState("skip.success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("skip.failure", t);
            }
        }
        if (stateTracker.containsState("prepare")) {
            try {
                stateTracker.setState("conclude");
                ClassInterceptorRegistry.getInstance().conclude(ImmutableClassContext.wrap(this.classInstanceContext), this.concludeMethods);
                stateTracker.setState("conclude.success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("conclude.failure", t);
            }
        }
        Object testInstance = null;
        if (this.classInstanceContext != null) {
            testInstance = this.classInstanceContext.getTestInstance();
        }
        if (testInstance instanceof AutoCloseable) {
            try {
                stateTracker.setState("classAutoClose(" + this.testClass.getName() + ")");
                ((AutoCloseable)testInstance).close();
                stateTracker.setState("classAutoClose(" + this.testClass.getName() + ").success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("classAutoClose(" + this.testClass.getName() + ").failure");
            }
        }
        Store store = this.classContext.getStore();
        for (Object key : store.keySet()) {
            Object value = store.get(key);
            if (!(value instanceof AutoCloseable)) continue;
            try {
                stateTracker.setState("storeAutoClose(" + key + ")");
                ((AutoCloseable)value).close();
                stateTracker.setState("storeAutoClose(" + key + ").success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("storeAutoClose(" + key + ").failure");
            }
        }
        store.clear();
        try {
            stateTracker.setState("destroy");
            try {
                ClassInterceptorRegistry.getInstance().onDestroy(this.classInstanceContext);
            }
            finally {
                testInstance = null;
            }
            stateTracker.setState("destroy.success");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            stateTracker.setState("destroy.failure", t);
        }
        if (testInstance instanceof AutoCloseable) {
            try {
                stateTracker.setState("argumentAutoClose(" + this.testClass.getName() + ")");
                ((AutoCloseable)testInstance).close();
                stateTracker.setState("argumentAutoClose" + this.testClass.getName() + ").success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("argumentAutoClose" + this.testClass.getName() + ").failure");
            }
        }
        LOGGER.trace("state tracker %s [%s]", new Object[]{this.classTestDescriptor, stateTracker});
        TestExecutionResult testExecutionResult = stateTracker.getStateWithThrowable().map(stateEntry -> TestExecutionResult.failed((Throwable)stateEntry.getThrowable())).orElse(TestExecutionResult.successful());
        this.executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this.classTestDescriptor, testExecutionResult);
    }

    @Override
    public void skip() {
        throw new IllegalStateException("Not implemented");
    }

    private static int getEngineArgumentParallelism() {
        LOGGER.trace("getEngineArgumentParallelism()");
        int engineClassParallelism = RunnableClassTestDescriptor.getEngineClassParallelism();
        int engineArgumentParallelism = DefaultConfiguration.getInstance().getOptional("verifyica.engine.argument.parallelism").map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 1) {
                    throw new EngineException(String.format("Invalid %s value [%d]", "verifyica.engine.argument.parallelism", intValue));
                }
                return intValue;
            }
            catch (NumberFormatException e) {
                throw new EngineException(String.format("Invalid %s value [%s]", "verifyica.engine.argument.parallelism", value), e);
            }
        }).orElse(Runtime.getRuntime().availableProcessors());
        if (engineArgumentParallelism < engineClassParallelism) {
            LOGGER.warn("[%s] is less than [%s], setting [%s] to [%d]", "verifyica.engine.argument.parallelism", "verifyica.engine.class.parallelism", "verifyica.engine.argument.parallelism", engineClassParallelism);
            engineArgumentParallelism = engineClassParallelism;
        }
        LOGGER.trace("engineArgumentParallelism [%s]", engineArgumentParallelism);
        return engineArgumentParallelism;
    }

    private static int getEngineClassParallelism() {
        LOGGER.trace("getEngineClassParallelism()");
        int engineClassParallelism = DefaultConfiguration.getInstance().getOptional("verifyica.engine.class.parallelism").map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 1) {
                    throw new EngineException(String.format("Invalid %s value [%d]", "verifyica.engine.class.parallelism", intValue));
                }
                return intValue;
            }
            catch (NumberFormatException e) {
                throw new EngineException(String.format("Invalid %s value [%s]", "verifyica.engine.class.parallelism", value), e);
            }
        }).orElse(Runtime.getRuntime().availableProcessors());
        LOGGER.trace("engineClassParallelism [%s]", engineClassParallelism);
        return engineClassParallelism;
    }
}

