/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.descriptor.execution;

import java.lang.reflect.Method;
import java.util.List;
import org.antublue.verifyica.api.ArgumentContext;
import org.antublue.verifyica.engine.common.StateTracker;
import org.antublue.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.antublue.verifyica.engine.descriptor.execution.AbstractRunnableTestDescriptor;
import org.antublue.verifyica.engine.interceptor.ClassInterceptorRegistry;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class RunnableTestMethodTestDescriptor
extends AbstractRunnableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnableTestMethodTestDescriptor.class);
    private final ExecutionRequest executionRequest;
    private final ArgumentContext argumentContext;
    private final TestMethodTestDescriptor testMethodTestDescriptor;
    private final List<Method> beforeEachMethods;
    private final Method testMethod;
    private final List<Method> afterEachMethods;

    public RunnableTestMethodTestDescriptor(ExecutionRequest executionRequest, ArgumentContext argumentContext, TestMethodTestDescriptor testMethodTestDescriptor) {
        this.executionRequest = executionRequest;
        this.argumentContext = argumentContext;
        this.testMethodTestDescriptor = testMethodTestDescriptor;
        this.beforeEachMethods = testMethodTestDescriptor.getBeforeEachMethods();
        this.testMethod = testMethodTestDescriptor.getTestMethod();
        this.afterEachMethods = testMethodTestDescriptor.getAfterEachMethods();
    }

    @Override
    public void execute() {
        LOGGER.trace("execute() %s", new Object[]{this.testMethodTestDescriptor});
        this.executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this.testMethodTestDescriptor);
        StateTracker<String> stateTracker = new StateTracker<String>();
        try {
            stateTracker.setState("beforeEach");
            ClassInterceptorRegistry.getInstance().beforeEach(this.argumentContext, this.beforeEachMethods);
            stateTracker.setState("beforeEach.success");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            stateTracker.setState("beforeEach.failure", t);
        }
        if (stateTracker.containsState("beforeEach.success")) {
            try {
                stateTracker.setState("test");
                ClassInterceptorRegistry.getInstance().test(this.argumentContext, this.testMethod);
                stateTracker.setState("test.success");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                stateTracker.setState("test.failure", t);
            }
        }
        try {
            stateTracker.setState("afterEach");
            ClassInterceptorRegistry.getInstance().afterEach(this.argumentContext, this.afterEachMethods);
            stateTracker.setState("afterEach.success");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            stateTracker.setState("afterEach.failure", t);
        }
        LOGGER.trace("state tracker [%s]", stateTracker);
        TestExecutionResult testExecutionResult = stateTracker.getStateWithThrowable().map(stateEntry -> TestExecutionResult.failed((Throwable)stateEntry.getThrowable())).orElse(TestExecutionResult.successful());
        this.executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this.testMethodTestDescriptor, testExecutionResult);
    }

    @Override
    public void skip() {
        LOGGER.trace("skip() %s", new Object[]{this.testMethodTestDescriptor});
        this.executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this.testMethodTestDescriptor);
        this.executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this.testMethodTestDescriptor, TestExecutionResult.aborted(null));
    }
}

