/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.discovery;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.antublue.verifyica.api.Argument;
import org.antublue.verifyica.api.interceptor.engine.ClassDefinition;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;

public class DefaultClassDefinition
implements ClassDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClassDefinition.class);
    private final Class<?> testClass;
    private final Set<Method> testMethods;
    private final List<Argument<?>> testArguments;
    private int testArgumentParallelism;

    public DefaultClassDefinition(Class<?> testClass, List<Method> testMethods, List<Argument<?>> testArguments, int testArgumentParallelism) {
        this.testClass = testClass;
        this.testMethods = new LinkedHashSet<Method>(testMethods);
        this.testArguments = testArguments;
        this.testArgumentParallelism = testArgumentParallelism;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Set<Method> getTestMethods() {
        return this.testMethods;
    }

    public List<Argument<?>> getTestArguments() {
        return this.testArguments;
    }

    public int getTestArgumentParallelism() {
        return this.testArgumentParallelism;
    }

    public void setTestArgumentParallelism(int testArgumentParallelism) {
        if (testArgumentParallelism < 1) {
            LOGGER.warn("Test class [%s] test argument parallelism [%d] less than [1], defaulting to [1]", this.testClass.getName(), testArgumentParallelism);
        }
        this.testArgumentParallelism = Math.max(testArgumentParallelism, 1);
    }

    public String toString() {
        return "DefaultClassDefinition{testClass=" + this.testClass + ", testMethods=" + this.testMethods + ", testArguments=" + this.testArguments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultClassDefinition that = (DefaultClassDefinition)o;
        return Objects.equals(this.testClass, that.testClass) && Objects.equals(this.testMethods, that.testMethods) && Objects.equals(this.testArguments, that.testArguments);
    }

    public int hashCode() {
        return Objects.hash(this.testClass, this.testMethods, this.testArguments);
    }
}

