/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.discovery;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.antublue.verifyica.api.Argument;
import org.antublue.verifyica.api.Verifyica;
import org.antublue.verifyica.api.interceptor.ClassInterceptor;
import org.antublue.verifyica.api.interceptor.engine.ClassDefinition;
import org.antublue.verifyica.api.interceptor.engine.EngineInterceptorContext;
import org.antublue.verifyica.engine.common.StopWatch;
import org.antublue.verifyica.engine.context.DefaultEngineContext;
import org.antublue.verifyica.engine.context.DefaultEngineInterceptorContext;
import org.antublue.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.antublue.verifyica.engine.descriptor.ClassTestDescriptor;
import org.antublue.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.antublue.verifyica.engine.discovery.DefaultClassDefinition;
import org.antublue.verifyica.engine.discovery.Predicates;
import org.antublue.verifyica.engine.exception.EngineException;
import org.antublue.verifyica.engine.exception.TestClassException;
import org.antublue.verifyica.engine.exception.UncheckedClassNotFoundException;
import org.antublue.verifyica.engine.interceptor.ClassInterceptorRegistry;
import org.antublue.verifyica.engine.interceptor.internal.engine.EngineInterceptorRegistry;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.antublue.verifyica.engine.support.ClassPathSupport;
import org.antublue.verifyica.engine.support.DisplayNameSupport;
import org.antublue.verifyica.engine.support.HierarchyTraversalMode;
import org.antublue.verifyica.engine.support.MethodSupport;
import org.antublue.verifyica.engine.support.OrderSupport;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class EngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineDiscoveryRequestResolver.class);

    private static Comparator<Object> getClassComparator() {
        return Comparator.comparing(clazz -> OrderSupport.getOrder((Class)clazz)).thenComparing(clazz -> DisplayNameSupport.getDisplayName((Class)clazz));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolveSelectors(EngineDiscoveryRequest engineDiscoveryRequest, EngineDescriptor engineDescriptor) {
        LOGGER.trace("resolveSelectors()");
        StopWatch stopWatch = new StopWatch();
        TreeMap testClassMethodMap = new TreeMap(EngineDiscoveryRequestResolver.getClassComparator());
        TreeMap testClassArgumentMap = new TreeMap(EngineDiscoveryRequestResolver.getClassComparator());
        TreeMap testClassArgumentIndexMap = new TreeMap(EngineDiscoveryRequestResolver.getClassComparator());
        try {
            EngineDiscoveryRequestResolver.resolveClasspathRootSelectors(engineDiscoveryRequest, testClassMethodMap);
            EngineDiscoveryRequestResolver.resolvePackageSelectors(engineDiscoveryRequest, testClassMethodMap);
            EngineDiscoveryRequestResolver.resolveClassSelectors(engineDiscoveryRequest, testClassMethodMap);
            EngineDiscoveryRequestResolver.resolveMethodSelectors(engineDiscoveryRequest, testClassMethodMap);
            EngineDiscoveryRequestResolver.resolveUniqueIdSelectors(engineDiscoveryRequest, testClassMethodMap, testClassArgumentIndexMap);
            EngineDiscoveryRequestResolver.resolveTestArguments(testClassMethodMap, testClassArgumentMap);
            ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>();
            testClassMethodMap.keySet().forEach(testClass -> {
                List testArguments = (List)testClassArgumentMap.get(testClass);
                List testMethods = (List)testClassMethodMap.get(testClass);
                int testArgumentParallelism = EngineDiscoveryRequestResolver.getTestArgumentParallelism(testClass);
                OrderSupport.orderMethods(testMethods);
                classDefinitions.add(new DefaultClassDefinition((Class<?>)testClass, testMethods, testArguments, testArgumentParallelism));
            });
            EngineDiscoveryRequestResolver.afterTestDiscovery(classDefinitions);
            EngineDiscoveryRequestResolver.prune(classDefinitions);
            EngineDiscoveryRequestResolver.loadClassInterceptors(classDefinitions);
            EngineDiscoveryRequestResolver.buildEngineDescriptor(engineDescriptor, classDefinitions);
        }
        catch (EngineException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new EngineException(t);
                }
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                LOGGER.trace("resolveSelectors() [%d] ms", stopWatch.elapsedTime().toMillis());
                throw throwable;
            }
        }
        stopWatch.stop();
        LOGGER.trace("resolveSelectors() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static void resolveClasspathRootSelectors(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, List<Method>> classMethodMap) {
        LOGGER.trace("resolveClasspathRootSelectors()");
        StopWatch stopWatch = new StopWatch();
        engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class).forEach(classpathRootSelector -> {
            List<Class<?>> testClasses = ClassPathSupport.findClasses(classpathRootSelector.getClasspathRoot(), Predicates.TEST_CLASS);
            List classNameFilters = engineDiscoveryRequest.getFiltersByType(ClassNameFilter.class);
            Predicate classNamePredicate = Filter.composeFilters((Collection)classNameFilters).toPredicate();
            List packageNameFilters = engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class);
            Predicate packageNamePredicate = Filter.composeFilters((Collection)packageNameFilters).toPredicate();
            testClasses.forEach(testClass -> {
                if (classNamePredicate.test(testClass.getName()) && packageNamePredicate.test(testClass.getPackage().getName())) {
                    classMethodMap.computeIfAbsent((Class<?>)testClass, method -> new ArrayList()).addAll(MethodSupport.findMethods(testClass, Predicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP));
                }
            });
        });
        LOGGER.trace("resolveClasspathRootSelectors() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static void resolvePackageSelectors(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, List<Method>> classMethodMap) {
        LOGGER.trace("resolvePackageSelectors()");
        StopWatch stopWatch = new StopWatch();
        engineDiscoveryRequest.getSelectorsByType(PackageSelector.class).forEach(packageSelector -> {
            String packageName = packageSelector.getPackageName();
            LOGGER.trace("packageName [%s]", packageName);
            List<Class<?>> testClasses = ClassPathSupport.findClasses(packageName, Predicates.TEST_CLASS);
            testClasses.forEach(testClass -> classMethodMap.computeIfAbsent((Class<?>)testClass, method -> new ArrayList()).addAll(MethodSupport.findMethods(testClass, Predicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP)));
        });
        LOGGER.trace("resolvePackageSelectors() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static void resolveClassSelectors(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, List<Method>> classMethodMap) {
        LOGGER.trace("resolveClassSelectors()");
        StopWatch stopWatch = new StopWatch();
        engineDiscoveryRequest.getSelectorsByType(ClassSelector.class).forEach(classSelector -> {
            Class testClass = classSelector.getJavaClass();
            if (Predicates.TEST_CLASS.test(testClass)) {
                classMethodMap.computeIfAbsent(testClass, method -> new ArrayList()).addAll(MethodSupport.findMethods(testClass, Predicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP));
            }
        });
        LOGGER.trace("resolveClassSelectors() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static void resolveMethodSelectors(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, List<Method>> classMethodMap) {
        LOGGER.trace("resolveMethodSelectors()");
        StopWatch stopWatch = new StopWatch();
        engineDiscoveryRequest.getSelectorsByType(MethodSelector.class).forEach(methodSelector -> {
            Class testClass = methodSelector.getJavaClass();
            Method testMethod = methodSelector.getJavaMethod();
            if (Predicates.TEST_CLASS.test(testClass) && Predicates.TEST_METHOD.test(testMethod)) {
                classMethodMap.computeIfAbsent(testClass, method -> new ArrayList()).add(testMethod);
            }
        });
        LOGGER.trace("resolveMethodSelectors() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static void resolveUniqueIdSelectors(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, List<Method>> classMethodMap, Map<Class<?>, Set<Integer>> argumentIndexMap) {
        LOGGER.trace("resolveUniqueIdSelectors()");
        StopWatch stopWatch = new StopWatch();
        engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class).forEach(uniqueIdSelector -> {
            UniqueId uniqueId = uniqueIdSelector.getUniqueId();
            List segments = uniqueId.getSegments();
            LOGGER.trace("uniqueId [%s]", uniqueId);
            if (segments.size() == 3) {
                UniqueId.Segment classSegment = (UniqueId.Segment)segments.get(1);
                UniqueId.Segment argumentSegment = (UniqueId.Segment)segments.get(2);
                Class<?> testClass = null;
                try {
                    testClass = Thread.currentThread().getContextClassLoader().loadClass(classSegment.getValue());
                }
                catch (ClassNotFoundException e) {
                    UncheckedClassNotFoundException.propagate(e);
                }
                classMethodMap.computeIfAbsent(testClass, method -> new ArrayList()).addAll(MethodSupport.findMethods(testClass, Predicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP));
                argumentIndexMap.computeIfAbsent(testClass, clazz -> new LinkedHashSet()).add(Integer.parseInt(argumentSegment.getValue()));
            } else {
                segments.forEach(segment -> {
                    String segmentType = segment.getType();
                    if (segmentType.equals(ClassTestDescriptor.class.getName())) {
                        String javaClassName = segment.getValue();
                        Class<?> testClass = null;
                        try {
                            testClass = Thread.currentThread().getContextClassLoader().loadClass(javaClassName);
                        }
                        catch (ClassNotFoundException e) {
                            UncheckedClassNotFoundException.propagate(e);
                        }
                        classMethodMap.computeIfAbsent(testClass, method -> new ArrayList()).addAll(MethodSupport.findMethods(testClass, Predicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP));
                    }
                });
            }
        });
        LOGGER.trace("resolveUniqueIdSelectors() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static void resolveTestArguments(Map<Class<?>, List<Method>> testClassMethodMap, Map<Class<?>, List<Argument<?>>> testClassArgumentMap) throws Throwable {
        LOGGER.trace("resolveTestArguments()");
        StopWatch stopWatch = new StopWatch();
        for (Class<?> testClass : testClassMethodMap.keySet()) {
            List<Argument<?>> testArguments = EngineDiscoveryRequestResolver.getTestArguments(testClass);
            testClassArgumentMap.put(testClass, testArguments);
        }
        LOGGER.trace("resolveTestArguments() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static List<Argument<?>> getTestArguments(Class<?> testClass) throws Throwable {
        LOGGER.trace("getTestArguments() testClass [%s]", testClass.getName());
        StopWatch stopWatch = new StopWatch();
        ArrayList testArguments = new ArrayList();
        Object object = EngineDiscoveryRequestResolver.getArgumentSupplierMethod(testClass).invoke(null, (Object[])null);
        if (object == null) {
            return testArguments;
        }
        if (object instanceof Argument) {
            testArguments.add((Argument)object);
            return testArguments;
        }
        if (object instanceof Stream || object instanceof Iterable) {
            Iterator iterator;
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                iterator = stream.iterator();
            } else {
                Iterable iterable = (Iterable)object;
                iterator = iterable.iterator();
            }
            long index = 0L;
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof Argument) {
                    testArguments.add((Argument)o);
                } else {
                    testArguments.add(Argument.of((String)("argument[" + index + "]"), o));
                }
                ++index;
            }
        } else {
            testArguments.add(Argument.of((String)"argument", (Object)object));
        }
        LOGGER.trace("getTestArguments() [%d] ms", stopWatch.elapsedTime().toMillis());
        return testArguments;
    }

    private static Method getArgumentSupplierMethod(Class<?> testClass) {
        LOGGER.trace("getArgumentSupplierMethod() testClass [%s]", testClass.getName());
        List<Method> methods = MethodSupport.findMethods(testClass, Predicates.ARGUMENT_SUPPLIER_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        return methods.get(0);
    }

    private static void afterTestDiscovery(List<ClassDefinition> classDefinitions) throws Throwable {
        LOGGER.trace("afterTestDiscovery()");
        DefaultEngineInterceptorContext defaultEngineInterceptorContext = new DefaultEngineInterceptorContext(DefaultEngineContext.getInstance());
        EngineInterceptorRegistry.getInstance().onTestDiscovery((EngineInterceptorContext)defaultEngineInterceptorContext, classDefinitions);
        for (ClassDefinition classDefinition : classDefinitions) {
            EngineInterceptorRegistry.getInstance().onTestDiscovery((EngineInterceptorContext)defaultEngineInterceptorContext, classDefinition);
        }
    }

    private static void prune(List<ClassDefinition> classDefinitions) {
        LOGGER.trace("prune()");
        classDefinitions.removeIf(classDefinition -> classDefinition.getTestArguments().isEmpty() || classDefinition.getTestMethods().isEmpty());
    }

    private static void loadClassInterceptors(List<ClassDefinition> classDefinitions) throws Throwable {
        LOGGER.trace("loadClassInterceptors()");
        for (ClassDefinition classDefinition : classDefinitions) {
            Class testClass = classDefinition.getTestClass();
            List<Method> classInterceptorSupplierMethods = MethodSupport.findMethods(testClass, Predicates.CLASS_INTERCEPTOR_SUPPLIER, HierarchyTraversalMode.BOTTOM_UP);
            for (Method classInterceptorMethod : classInterceptorSupplierMethods) {
                Iterator iterator;
                Object object = classInterceptorMethod.invoke(null, new Object[0]);
                if (object instanceof ClassInterceptor) {
                    ClassInterceptorRegistry.getInstance().register(testClass, (ClassInterceptor)object);
                    continue;
                }
                if (!(object instanceof Stream) && !(object instanceof Iterable)) continue;
                if (object instanceof Stream) {
                    Stream stream = (Stream)object;
                    iterator = stream.iterator();
                } else {
                    Iterable iterable = (Iterable)object;
                    iterator = iterable.iterator();
                }
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (o instanceof ClassInterceptor) {
                        ClassInterceptorRegistry.getInstance().register(testClass, (ClassInterceptor)o);
                        continue;
                    }
                    throw new TestClassException(String.format("Invalid argument type [%s] supplied by test class [%s] @Verifyica.ClassInterceptorSupplier method", o.getClass().getName(), testClass.getName()));
                }
            }
        }
    }

    private static void buildEngineDescriptor(EngineDescriptor engineDescriptor, List<ClassDefinition> classDefinitions) throws Throwable {
        LOGGER.trace("buildEngineDescriptor()");
        StopWatch stopWatch = new StopWatch();
        for (ClassDefinition classDefinition : classDefinitions) {
            Class testClass = classDefinition.getTestClass();
            UniqueId classTestDescriptorUniqueId = engineDescriptor.getUniqueId().append("class", testClass.getName());
            ClassTestDescriptor classTestDescriptor = new ClassTestDescriptor(classTestDescriptorUniqueId, DisplayNameSupport.getDisplayName(testClass), classDefinition.getTestArgumentParallelism(), testClass, MethodSupport.findMethods(testClass, Predicates.PREPARE_METHOD, HierarchyTraversalMode.TOP_DOWN), MethodSupport.findMethods(testClass, Predicates.CONCLUDE_METHOD, HierarchyTraversalMode.BOTTOM_UP));
            engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            int argumentIndex = 0;
            for (Argument testArgument : classDefinition.getTestArguments()) {
                UniqueId argumentTestDescriptorUniqueId = classTestDescriptorUniqueId.append("argument", String.valueOf(argumentIndex));
                ArgumentTestDescriptor argumentTestDescriptor = new ArgumentTestDescriptor(argumentTestDescriptorUniqueId, testArgument.getName(), testClass, testArgument, MethodSupport.findMethods(testClass, Predicates.BEFORE_ALL_METHOD, HierarchyTraversalMode.TOP_DOWN), MethodSupport.findMethods(testClass, Predicates.AFTER_ALL_METHOD, HierarchyTraversalMode.BOTTOM_UP));
                classTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
                for (Method testMethod : classDefinition.getTestMethods()) {
                    UniqueId testMethodDescriptorUniqueId = argumentTestDescriptorUniqueId.append("test", testMethod.getName());
                    TestMethodTestDescriptor testMethodTestDescriptor = new TestMethodTestDescriptor(testMethodDescriptorUniqueId, DisplayNameSupport.getDisplayName(testMethod), MethodSupport.findMethods(testClass, Predicates.BEFORE_EACH_METHOD, HierarchyTraversalMode.TOP_DOWN), testMethod, MethodSupport.findMethods(testClass, Predicates.AFTER_EACH_METHOD, HierarchyTraversalMode.BOTTOM_UP));
                    argumentTestDescriptor.addChild((TestDescriptor)testMethodTestDescriptor);
                }
                ++argumentIndex;
            }
        }
        LOGGER.trace("buildEngineDescriptor() [%d] ms", stopWatch.elapsedTime().toMillis());
    }

    private static int getTestArgumentParallelism(Class<?> testClass) {
        LOGGER.trace("getTestArgumentParallelism() testClass [%s]", testClass.getName());
        Method argumentSupplierMethod = EngineDiscoveryRequestResolver.getArgumentSupplierMethod(testClass);
        Verifyica.ArgumentSupplier annotation = argumentSupplierMethod.getAnnotation(Verifyica.ArgumentSupplier.class);
        int parallelism = Math.max(annotation.parallelism(), 1);
        LOGGER.trace("testClass [%s] parallelism [%d]", testClass.getName(), parallelism);
        return parallelism;
    }
}

