/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.antublue.verifyica.api.ArgumentContext;
import org.antublue.verifyica.api.ClassContext;
import org.antublue.verifyica.api.EngineContext;
import org.antublue.verifyica.api.interceptor.ClassInterceptor;
import org.antublue.verifyica.api.interceptor.ClassInterceptorContext;
import org.antublue.verifyica.api.interceptor.engine.EngineInterceptorContext;
import org.antublue.verifyica.engine.common.ThrowableCollector;
import org.antublue.verifyica.engine.context.DefaultArgumentInterceptorContext;
import org.antublue.verifyica.engine.context.DefaultClassInterceptorContext;
import org.antublue.verifyica.engine.context.DefaultEngineInterceptorContext;
import org.antublue.verifyica.engine.context.ImmutableArgumentContext;
import org.antublue.verifyica.engine.discovery.Predicates;
import org.antublue.verifyica.engine.exception.EngineException;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.antublue.verifyica.engine.support.ArgumentSupport;
import org.antublue.verifyica.engine.support.ClassPathSupport;
import org.antublue.verifyica.engine.support.ObjectSupport;
import org.antublue.verifyica.engine.support.OrderSupport;

public class ClassInterceptorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInterceptorRegistry.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final List<ClassInterceptor> classInterceptors = new ArrayList<ClassInterceptor>();
    private final Map<Class<?>, List<ClassInterceptor>> mappedClassInterceptors = new LinkedHashMap();
    private boolean initialized;

    private ClassInterceptorRegistry() {
        this.loadClassInterceptors();
    }

    public ClassInterceptorRegistry register(Class<?> testClass, ClassInterceptor classInterceptor) {
        ArgumentSupport.notNull(testClass, "testClass is null");
        ArgumentSupport.notNull(classInterceptor, "classInterceptor is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.mappedClassInterceptors.computeIfAbsent(testClass, c -> new ArrayList()).add(classInterceptor);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
        return this;
    }

    public ClassInterceptorRegistry remove(Class<?> testClass, ClassInterceptor classInterceptor) {
        ArgumentSupport.notNull(testClass, "testClass is null");
        ArgumentSupport.notNull(classInterceptor, "classInterceptor is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.mappedClassInterceptors.get(testClass).remove(classInterceptor);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Class<?> testClass) {
        ArgumentSupport.notNull(testClass, "testClass is null");
        try {
            this.getReadWriteLock().readLock().lock();
            List<ClassInterceptor> classInterceptors = this.mappedClassInterceptors.get(testClass);
            int n = classInterceptors != null ? classInterceptors.size() : 0;
            return n;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public ClassInterceptorRegistry clear(Class<?> testClass) {
        ArgumentSupport.notNull(testClass, "testClass is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.mappedClassInterceptors.remove(testClass);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
        return this;
    }

    public void beforeInstantiate(EngineContext engineContext, Class<?> testClass) throws Throwable {
        DefaultEngineInterceptorContext engineInterceptorContext = new DefaultEngineInterceptorContext(engineContext);
        for (ClassInterceptor classInterceptor : this.getClassInterceptors(testClass)) {
            classInterceptor.preInstantiate((EngineInterceptorContext)engineInterceptorContext, testClass);
        }
    }

    public void afterInstantiate(EngineContext engineContext, Class<?> testClass, Object testInstance, Throwable throwable) throws Throwable {
        DefaultEngineInterceptorContext engineInterceptorContext = new DefaultEngineInterceptorContext(engineContext);
        List<ClassInterceptor> classInterceptorsReversed = this.getClassInterceptorsReversed(testClass);
        if (!classInterceptorsReversed.isEmpty()) {
            for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                classInterceptor.postInstantiate((EngineInterceptorContext)engineInterceptorContext, testClass, testInstance, throwable);
            }
        } else if (throwable != null) {
            throw throwable;
        }
    }

    public void prepare(ClassContext classContext, List<Method> prepareMethods) throws Throwable {
        List<ClassInterceptor> classInterceptorsReversed;
        Class testClass = classContext.getTestClass();
        DefaultClassInterceptorContext argumentInterceptorContext = new DefaultClassInterceptorContext(classContext);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        if (!classInterceptors.isEmpty()) {
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptors) {
                    classInterceptor.prePrepare(argumentInterceptorContext);
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                try {
                    for (Method prepareMethod : prepareMethods) {
                        prepareMethod.invoke(null, classContext);
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        if (!(classInterceptorsReversed = this.getClassInterceptorsReversed(testClass)).isEmpty()) {
            Throwable throwable = throwableCollector.getThrowable();
            throwableCollector.clear();
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                    classInterceptor.postPrepare(argumentInterceptorContext, throwable);
                }
            });
        }
        throwableCollector.assertEmpty();
    }

    public void beforeAll(ArgumentContext argumentContext, List<Method> beforeAllMethods) throws Throwable {
        List<ClassInterceptor> classInterceptorsReversed;
        ClassContext classContext = argumentContext.getClassContext();
        Class testClass = classContext.getTestClass();
        Object testInstance = classContext.getTestInstance();
        DefaultArgumentInterceptorContext argumentInterceptorContext = new DefaultArgumentInterceptorContext(argumentContext);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        if (!classInterceptors.isEmpty()) {
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptors) {
                    classInterceptor.preBeforeAll(argumentInterceptorContext);
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                try {
                    for (Method beforeAllMethod : beforeAllMethods) {
                        beforeAllMethod.invoke(testInstance, argumentContext);
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        if (!(classInterceptorsReversed = this.getClassInterceptorsReversed(testClass)).isEmpty()) {
            Throwable throwable = throwableCollector.getThrowable();
            throwableCollector.clear();
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                    classInterceptor.postBeforeAll(argumentInterceptorContext, throwable);
                }
            });
        }
        throwableCollector.assertEmpty();
    }

    public void beforeEach(ArgumentContext argumentContext, List<Method> beforeEachMethods) throws Throwable {
        List<ClassInterceptor> classInterceptorsReversed;
        ClassContext classContext = argumentContext.getClassContext();
        Class testClass = classContext.getTestClass();
        Object testInstance = classContext.getTestInstance();
        DefaultArgumentInterceptorContext argumentInterceptorContext = new DefaultArgumentInterceptorContext(argumentContext);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        if (!classInterceptors.isEmpty()) {
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptors) {
                    classInterceptor.preBeforeEach(argumentInterceptorContext);
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                try {
                    for (Method beforEachMethod : beforeEachMethods) {
                        beforEachMethod.invoke(testInstance, argumentContext);
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        if (!(classInterceptorsReversed = this.getClassInterceptorsReversed(testClass)).isEmpty()) {
            Throwable throwable = throwableCollector.getThrowable();
            throwableCollector.clear();
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                    classInterceptor.postBeforeEach(argumentInterceptorContext, throwable);
                }
            });
        }
        throwableCollector.assertEmpty();
    }

    public void test(ArgumentContext argumentContext, Method testMethod) throws Throwable {
        List<ClassInterceptor> classInterceptorsReversed;
        ClassContext classContext = argumentContext.getClassContext();
        Class testClass = classContext.getTestClass();
        Object testInstance = classContext.getTestInstance();
        DefaultArgumentInterceptorContext argumentInterceptorContext = new DefaultArgumentInterceptorContext(argumentContext);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        if (!classInterceptors.isEmpty()) {
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptors) {
                    classInterceptor.preTest(argumentInterceptorContext, testMethod);
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                try {
                    testMethod.invoke(testInstance, ImmutableArgumentContext.wrap(argumentContext));
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        if (!(classInterceptorsReversed = this.getClassInterceptorsReversed(testClass)).isEmpty()) {
            Throwable throwable = throwableCollector.getThrowable();
            throwableCollector.clear();
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                    classInterceptor.postTest(argumentInterceptorContext, testMethod, throwable);
                }
            });
        }
        throwableCollector.assertEmpty();
    }

    public void afterEach(ArgumentContext argumentContext, List<Method> afterEachMethods) throws Throwable {
        List<ClassInterceptor> classInterceptorsReversed;
        ClassContext classContext = argumentContext.getClassContext();
        Class testClass = classContext.getTestClass();
        Object testInstance = classContext.getTestInstance();
        DefaultArgumentInterceptorContext argumentInterceptorContext = new DefaultArgumentInterceptorContext(argumentContext);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        if (!classInterceptors.isEmpty()) {
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptors) {
                    classInterceptor.preAfterEach(argumentInterceptorContext);
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                try {
                    for (Method afterEachMethod : afterEachMethods) {
                        afterEachMethod.invoke(testInstance, argumentContext);
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        if (!(classInterceptorsReversed = this.getClassInterceptorsReversed(testClass)).isEmpty()) {
            Throwable throwable = throwableCollector.getThrowable();
            throwableCollector.clear();
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                    classInterceptor.postAfterEach(argumentInterceptorContext, throwable);
                }
            });
        }
        throwableCollector.assertEmpty();
    }

    public void afterAll(ArgumentContext argumentContext, List<Method> afterAllMethods) throws Throwable {
        List<ClassInterceptor> classInterceptorsReversed;
        ClassContext classContext = argumentContext.getClassContext();
        Class testClass = classContext.getTestClass();
        Object testInstance = classContext.getTestInstance();
        DefaultArgumentInterceptorContext argumentInterceptorContext = new DefaultArgumentInterceptorContext(argumentContext);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        if (!classInterceptors.isEmpty()) {
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : this.getClassInterceptors(testClass)) {
                    classInterceptor.preAfterAll(argumentInterceptorContext);
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                try {
                    for (Method afterAllMethod : afterAllMethods) {
                        afterAllMethod.invoke(testInstance, argumentContext);
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        if (!(classInterceptorsReversed = this.getClassInterceptorsReversed(testClass)).isEmpty()) {
            Throwable throwable = throwableCollector.getThrowable();
            throwableCollector.clear();
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                    classInterceptor.postAfterAll(argumentInterceptorContext, throwable);
                }
            });
        }
        throwableCollector.assertEmpty();
    }

    public void conclude(ClassContext classContext, List<Method> concludeMethods) throws Throwable {
        List<ClassInterceptor> classInterceptorsReversed;
        Class testClass = classContext.getTestClass();
        DefaultClassInterceptorContext defaultClassInterceptorContext = new DefaultClassInterceptorContext(classContext);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        if (!classInterceptors.isEmpty()) {
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : this.getClassInterceptors(testClass)) {
                    classInterceptor.preConclude(defaultClassInterceptorContext);
                }
            });
        }
        if (throwableCollector.isEmpty()) {
            throwableCollector.execute(() -> {
                try {
                    for (Method concludeMethod : concludeMethods) {
                        concludeMethod.invoke(null, classContext);
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
        }
        if (!(classInterceptorsReversed = this.getClassInterceptorsReversed(testClass)).isEmpty()) {
            Throwable throwable = throwableCollector.getThrowable();
            throwableCollector.clear();
            throwableCollector.execute(() -> {
                for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                    classInterceptor.postConclude(defaultClassInterceptorContext, throwable);
                }
            });
        }
        throwableCollector.assertEmpty();
    }

    public void onDestroy(ClassContext classContext) throws Throwable {
        Class testClass = classContext.getTestClass();
        DefaultClassInterceptorContext classInterceptorContext = new DefaultClassInterceptorContext(classContext);
        for (ClassInterceptor classInterceptor : this.getClassInterceptorsReversed(testClass)) {
            classInterceptor.onDestroy((ClassInterceptorContext)classInterceptorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClassInterceptor> getClassInterceptors(Class<?> testClass) {
        try {
            this.getReadWriteLock().writeLock().lock();
            ArrayList<ClassInterceptor> classInterceptors = new ArrayList<ClassInterceptor>();
            if (this.classInterceptors != null) {
                classInterceptors.addAll(this.classInterceptors);
            }
            classInterceptors.addAll(this.mappedClassInterceptors.computeIfAbsent(testClass, o -> new ArrayList()));
            ArrayList<ClassInterceptor> arrayList = classInterceptors;
            return arrayList;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    private List<ClassInterceptor> getClassInterceptorsReversed(Class<?> testClass) {
        List<ClassInterceptor> classInterceptors = this.getClassInterceptors(testClass);
        Collections.reverse(classInterceptors);
        return classInterceptors;
    }

    private ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassInterceptors() {
        try {
            this.getReadWriteLock().writeLock().lock();
            if (!this.initialized) {
                LOGGER.trace("loadClassInterceptors()");
                ArrayList autowiredClassInterceptors = new ArrayList(ClassPathSupport.findClasses(Predicates.AUTOWIRED_CLASS_INTERCEPTOR_CLASS));
                OrderSupport.orderClasses(autowiredClassInterceptors);
                LOGGER.trace("autowired class interceptor count [%d]", autowiredClassInterceptors.size());
                for (Class clazz : autowiredClassInterceptors) {
                    try {
                        LOGGER.trace("loading autowired class interceptor [%s]", clazz.getName());
                        Object object = ObjectSupport.createObject(clazz);
                        this.classInterceptors.add((ClassInterceptor)object);
                        LOGGER.trace("autowired class interceptor [%s] loaded", clazz.getName());
                    }
                    catch (EngineException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new EngineException(t);
                    }
                }
                this.initialized = true;
            }
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public static ClassInterceptorRegistry getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private static class SingletonHolder {
        private static final ClassInterceptorRegistry SINGLETON = new ClassInterceptorRegistry();

        private SingletonHolder() {
        }
    }
}

