/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.interceptor.internal.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antublue.verifyica.api.interceptor.engine.ClassDefinition;
import org.antublue.verifyica.api.interceptor.engine.EngineInterceptor;
import org.antublue.verifyica.api.interceptor.engine.EngineInterceptorContext;
import org.antublue.verifyica.engine.context.DefaultEngineContext;
import org.antublue.verifyica.engine.discovery.Predicates;
import org.antublue.verifyica.engine.exception.EngineException;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.EngineFiltersInterceptor;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.antublue.verifyica.engine.support.ArgumentSupport;
import org.antublue.verifyica.engine.support.ClassPathSupport;
import org.antublue.verifyica.engine.support.ObjectSupport;
import org.antublue.verifyica.engine.support.OrderSupport;

public class EngineInterceptorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineInterceptorRegistry.class);
    private static final DefaultEngineContext DEFAULT_ENGINE_CONTEXT = DefaultEngineContext.getInstance();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final List<EngineInterceptor> engineInterceptors = new ArrayList<EngineInterceptor>();
    private boolean initialized;

    private EngineInterceptorRegistry() {
        this.engineInterceptors.add(new EngineFiltersInterceptor());
        this.loadEngineInterceptors();
    }

    public EngineInterceptorRegistry register(EngineInterceptor engineInterceptor) {
        ArgumentSupport.notNull(engineInterceptor, "engineInterceptor is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.engineInterceptors.add(engineInterceptor);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
        return this;
    }

    public EngineInterceptorRegistry remove(EngineInterceptor engineInterceptor) {
        ArgumentSupport.notNull(engineInterceptor, "testClass is null");
        try {
            this.getReadWriteLock().writeLock().lock();
            this.engineInterceptors.remove(engineInterceptor);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
        return this;
    }

    public int size() {
        try {
            this.getReadWriteLock().readLock().lock();
            int n = this.engineInterceptors.size();
            return n;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    public void onInitialize(EngineInterceptorContext engineInterceptorContext) throws Throwable {
        ArgumentSupport.notNull(engineInterceptorContext, "engineInterceptorContext is null");
        for (EngineInterceptor engineInterceptor : this.getEngineInterceptors()) {
            LOGGER.trace("engine interceptor [%s] onInitialize()", engineInterceptor.getClass().getName());
            engineInterceptor.onInitialize(engineInterceptorContext);
            LOGGER.trace("engine interceptor [%s] onInitialize() success", engineInterceptor.getClass().getName());
        }
    }

    public void onTestDiscovery(EngineInterceptorContext engineInterceptorContext, List<ClassDefinition> classDefinitions) throws Throwable {
        ArgumentSupport.notNull(engineInterceptorContext, "engineInterceptorContext is null");
        ArgumentSupport.notNull(classDefinitions, "classDefinitions is null");
        for (EngineInterceptor engineInterceptor : this.getEngineInterceptors()) {
            LOGGER.trace("engine interceptor [%s] onTestDiscovery()", engineInterceptor.getClass().getName());
            engineInterceptor.onTestDiscovery(engineInterceptorContext, classDefinitions);
            LOGGER.trace("engine interceptor [%s] onTestDiscovery() success", engineInterceptor.getClass().getName());
        }
    }

    public void onTestDiscovery(EngineInterceptorContext engineInterceptorContext, ClassDefinition classDefinition) throws Throwable {
        ArgumentSupport.notNull(engineInterceptorContext, "engineInterceptorContext is null");
        ArgumentSupport.notNull(classDefinition, "classDefinition is null");
        for (EngineInterceptor engineInterceptor : this.getEngineInterceptors()) {
            LOGGER.trace("engine interceptor [%s] onTestDiscovery() classDefinition testClass [%s]", engineInterceptor.getClass().getName(), classDefinition.getTestClass().getName());
            engineInterceptor.onTestDiscovery(engineInterceptorContext, classDefinition);
            LOGGER.trace("engine interceptor [%s] onTestDiscovery() classDefinition testClass [%s] success", engineInterceptor.getClass().getName(), classDefinition.getTestClass().getName());
        }
    }

    public void beforeExecute(EngineInterceptorContext engineInterceptorContext) throws Throwable {
        ArgumentSupport.notNull(engineInterceptorContext, "engineInterceptorContext is null");
        for (EngineInterceptor engineInterceptor : this.getEngineInterceptors()) {
            LOGGER.trace("engine interceptor [%s] beforeExecute()", engineInterceptor.getClass().getName());
            engineInterceptor.preExecute(engineInterceptorContext);
            LOGGER.trace("engine interceptor [%s] beforeExecute() success", engineInterceptor.getClass().getName());
        }
    }

    public void afterExecute(EngineInterceptorContext engineInterceptorContext) throws Throwable {
        ArgumentSupport.notNull(engineInterceptorContext, "engineInterceptorContext is null");
        for (EngineInterceptor engineInterceptor : this.getEngineInterceptorsReverse()) {
            LOGGER.trace("engine interceptor [%s] beforeDestroy()", engineInterceptor.getClass().getName());
            engineInterceptor.postExecute(engineInterceptorContext);
        }
    }

    private List<EngineInterceptor> getEngineInterceptors() {
        try {
            this.getReadWriteLock().readLock().lock();
            ArrayList<EngineInterceptor> arrayList = new ArrayList<EngineInterceptor>(this.engineInterceptors);
            return arrayList;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    private List<EngineInterceptor> getEngineInterceptorsReverse() {
        try {
            this.getReadWriteLock().readLock().lock();
            ArrayList<EngineInterceptor> list = new ArrayList<EngineInterceptor>(this.engineInterceptors);
            Collections.reverse(list);
            ArrayList<EngineInterceptor> arrayList = list;
            return arrayList;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    private ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEngineInterceptors() {
        try {
            this.getReadWriteLock().writeLock().lock();
            if (!this.initialized) {
                LOGGER.trace("loading engine interceptors");
                ArrayList autowiredEngineInterceptors = new ArrayList(ClassPathSupport.findClasses(Predicates.AUTOWIRED_ENGINE_INTERCEPTOR_CLASS));
                EngineInterceptorRegistry.filter(autowiredEngineInterceptors);
                OrderSupport.orderClasses(autowiredEngineInterceptors);
                LOGGER.trace("autowired engine interceptor count [%d]", autowiredEngineInterceptors.size());
                for (Class clazz : autowiredEngineInterceptors) {
                    try {
                        LOGGER.trace("loading autowired engine interceptor [%s]", clazz.getName());
                        Object object = ObjectSupport.createObject(clazz);
                        this.engineInterceptors.add((EngineInterceptor)object);
                        LOGGER.trace("autowired engine interceptor [%s] loaded", clazz.getName());
                    }
                    catch (EngineException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new EngineException(t);
                    }
                }
                this.initialized = true;
            }
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public static EngineInterceptorRegistry getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private static void filter(List<Class<?>> classes) {
        DEFAULT_ENGINE_CONTEXT.getConfiguration().getOptional("verifyica.engine.interceptors.include.regex").ifPresent(regex -> {
            LOGGER.trace("%s [%s]", "verifyica.engine.interceptors.include.regex", regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher("");
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                matcher.reset(clazz.getName());
                if (matcher.find()) continue;
                LOGGER.trace("removing engine interceptor [%s]", clazz.getName());
                iterator.remove();
            }
        });
        DEFAULT_ENGINE_CONTEXT.getConfiguration().getOptional("verifyica.engine.interceptors.exclude.regex").ifPresent(regex -> {
            LOGGER.trace("%s [%s]", "verifyica.engine.interceptors.exclude.regex", regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher("");
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                LOGGER.trace("removing engine interceptor [%s]", clazz.getName());
                iterator.remove();
            }
        });
    }

    private static class SingletonHolder {
        private static final EngineInterceptorRegistry SINGLETON = new EngineInterceptorRegistry();

        private SingletonHolder() {
        }
    }
}

