/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.interceptor.internal.engine.filter;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.antublue.verifyica.api.interceptor.engine.ClassDefinition;
import org.antublue.verifyica.api.interceptor.engine.EngineInterceptor;
import org.antublue.verifyica.api.interceptor.engine.EngineInterceptorContext;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.Filter;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.FilterFactory;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;

public class EngineFiltersInterceptor
implements EngineInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineFiltersInterceptor.class);

    public void onTestDiscovery(EngineInterceptorContext engineInterceptorContext, List<ClassDefinition> classDefinitions) {
        LOGGER.trace("onTestDiscovery()");
        EngineFiltersInterceptor.applyFilters(classDefinitions);
    }

    private static void applyFilters(List<ClassDefinition> classDefinitions) {
        LOGGER.trace("applyFilters()");
        List<Filter> filters = FilterFactory.getInstance().loadFilters();
        LinkedHashMap workingClassMethodMap = new LinkedHashMap();
        classDefinitions.forEach(classDefinition -> {
            Class testClass = classDefinition.getTestClass();
            classDefinition.getTestMethods().forEach(testMethod -> workingClassMethodMap.computeIfAbsent(testClass, m -> new LinkedHashMap()).put(testMethod.getName(), testMethod));
        });
        classDefinitions.forEach(classDefinition -> classDefinition.getTestMethods().forEach(testMethod -> {
            for (Filter filter : filters) {
                Class testClass = classDefinition.getTestClass();
                switch (filter.getType()) {
                    case INCLUDE_CLASS: 
                    case INCLUDE_TAGGED_CLASS: {
                        if (!filter.matches(testClass, (Method)testMethod)) break;
                        workingClassMethodMap.computeIfAbsent(testClass, m -> new LinkedHashMap()).put(testMethod.getName(), testMethod);
                        break;
                    }
                    case EXCLUDE_CLASS: 
                    case EXCLUDE_TAGGED_CLASS: {
                        if (!filter.matches(testClass, (Method)testMethod)) break;
                        workingClassMethodMap.computeIfAbsent(testClass, m -> new LinkedHashMap()).remove(testMethod.getName());
                        break;
                    }
                }
            }
        }));
        workingClassMethodMap.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        Iterator<ClassDefinition> classDefinitionsIterator = classDefinitions.iterator();
        while (classDefinitionsIterator.hasNext()) {
            ClassDefinition classDefinition2 = classDefinitionsIterator.next();
            Class testClass = classDefinition2.getTestClass();
            if (!workingClassMethodMap.containsKey(testClass)) {
                classDefinitionsIterator.remove();
                continue;
            }
            classDefinition2.getTestMethods().clear();
            classDefinition2.getTestMethods().addAll(new LinkedHashSet(((Map)workingClassMethodMap.get(testClass)).values()));
        }
    }
}

