/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.interceptor.internal.engine.filter;

import 6bc6660d778dec84d62bc72b295ffd7b.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antublue.verifyica.engine.context.DefaultEngineContext;
import org.antublue.verifyica.engine.exception.EngineConfigurationException;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.ExcludeClassFilter;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.ExcludeTaggedClassFilter;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.Filter;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.IncludeClassFilter;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.IncludeTaggedClassFilter;

public class FilterFactory {
    private static final Map<String, Filter.Type> filterTypeMap = new HashMap<String, Filter.Type>();

    private FilterFactory() {
    }

    public List<Filter> loadFilters() {
        try {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            String filtersFilename = DefaultEngineContext.getInstance().getConfiguration().getOptional("verifyica.engine.filter.definitions.filename").orElse(null);
            if (filtersFilename != null && !filtersFilename.trim().isEmpty()) {
                List objects = (List)new Yaml().load(FilterFactory.loadContents(new File(filtersFilename)));
                block9: for (Object object : objects) {
                    Map filterMap = (Map)object;
                    String type = (String)filterMap.get("type");
                    boolean enabled = Boolean.TRUE.equals(filterMap.get("enabled"));
                    if (!enabled) continue;
                    Filter.Type decodedType = filterTypeMap.getOrDefault(type, Filter.Type.UNKNOWN);
                    switch (decodedType) {
                        case INCLUDE_CLASS: {
                            String classRegex = (String)filterMap.get("classRegex");
                            String methodRegex = (String)filterMap.get("methodRegex");
                            filters.add(IncludeClassFilter.create(classRegex, methodRegex));
                            continue block9;
                        }
                        case EXCLUDE_CLASS: {
                            String classRegex = (String)filterMap.get("classRegex");
                            String methodRegex = (String)filterMap.get("methodRegex");
                            filters.add(ExcludeClassFilter.create(classRegex, methodRegex));
                            continue block9;
                        }
                        case INCLUDE_TAGGED_CLASS: {
                            String classTagRegex = (String)filterMap.get("classTagRegex");
                            filters.add(IncludeTaggedClassFilter.create(classTagRegex));
                            continue block9;
                        }
                        case EXCLUDE_TAGGED_CLASS: {
                            String classTagRegex = (String)filterMap.get("classTagRegex");
                            filters.add(ExcludeTaggedClassFilter.create(classTagRegex));
                        }
                    }
                    throw new EngineConfigurationException("Invalid filter type");
                }
            }
            return filters;
        }
        catch (EngineConfigurationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EngineConfigurationException("Invalid filter", t);
        }
    }

    public static FilterFactory getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private static String loadContents(File file) throws IOException {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static {
        filterTypeMap.put("IncludeClass", Filter.Type.INCLUDE_CLASS);
        filterTypeMap.put("ExcludeClass", Filter.Type.EXCLUDE_CLASS);
        filterTypeMap.put("IncludeTaggedClass", Filter.Type.INCLUDE_TAGGED_CLASS);
        filterTypeMap.put("ExcludeTaggedClass", Filter.Type.EXCLUDE_TAGGED_CLASS);
    }

    private static class SingletonHolder {
        private static final FilterFactory SINGLETON = new FilterFactory();

        private SingletonHolder() {
        }
    }
}

