/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.interceptor.internal.engine.filter;

import java.lang.reflect.Method;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.AbstractFilter;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.Filter;

public class IncludeClassFilter
extends AbstractFilter {
    private IncludeClassFilter(String classNameRegex, String methodNameRegex) {
        super(classNameRegex, methodNameRegex);
    }

    @Override
    public Filter.Type getType() {
        return Filter.Type.INCLUDE_CLASS;
    }

    @Override
    public boolean matches(Class<?> testClass, Method testMethod) {
        return this.getClassNamePattern().matcher(testClass.getName()).find() && this.getMethodNamePattern().matcher(testMethod.getName()).find();
    }

    public static IncludeClassFilter create(String classRegex, String methodRegex) {
        return new IncludeClassFilter(classRegex, methodRegex);
    }
}

