/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.interceptor.internal.engine.filter;

import java.lang.reflect.Method;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.AbstractFilter;
import org.antublue.verifyica.engine.interceptor.internal.engine.filter.Filter;
import org.antublue.verifyica.engine.support.TagSupport;

public class IncludeTaggedClassFilter
extends AbstractFilter {
    private IncludeTaggedClassFilter(String classNameRegex, String methodNameRegex) {
        super(classNameRegex, methodNameRegex);
    }

    @Override
    public Filter.Type getType() {
        return Filter.Type.INCLUDE_TAGGED_CLASS;
    }

    @Override
    public boolean matches(Class<?> testClass, Method testMethod) {
        for (String tag : TagSupport.getTags(testClass)) {
            if (!this.getClassNamePattern().matcher(tag).find()) continue;
            return true;
        }
        return false;
    }

    public static IncludeTaggedClassFilter create(String classRegex) {
        return new IncludeTaggedClassFilter(classRegex, "");
    }
}

