/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.listener;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.antublue.verifyica.api.Argument;
import org.antublue.verifyica.api.Configuration;
import org.antublue.verifyica.engine.common.AnsiColor;
import org.antublue.verifyica.engine.common.AnsiColorStringBuilder;
import org.antublue.verifyica.engine.common.StopWatch;
import org.antublue.verifyica.engine.context.DefaultEngineContext;
import org.antublue.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.antublue.verifyica.engine.descriptor.ClassTestDescriptor;
import org.antublue.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.antublue.verifyica.engine.support.DisplayNameSupport;
import org.antublue.verifyica.engine.support.HumanReadableTimeSupport;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class StatusEngineExecutionListener
implements EngineExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusEngineExecutionListener.class);
    private static final String INFO = new AnsiColorStringBuilder().color(AnsiColor.TEXT_WHITE).append("[").color(AnsiColor.TEXT_BLUE_BOLD).append("INFO").color(AnsiColor.TEXT_WHITE).append("]").color(AnsiColor.TEXT_RESET).toString();
    private final boolean consoleLogTiming;
    private final String consoleLogTimingUnits;
    private final boolean consoleLogMessagesStarted;
    private final String consoleTestMessage;
    private final boolean consoleLogMessagesSkipped;
    private final String consoleSkipMessage;
    private final boolean consoleLogMessagesFinished;
    private final String consolePassMessage;
    private final String consoleFailMessage;
    private final Map<TestDescriptor, StopWatch> stopWatchMap;

    public StatusEngineExecutionListener() {
        Configuration configuration = DefaultEngineContext.getInstance().getConfiguration();
        this.consoleLogTiming = Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.timing")).map(Boolean::parseBoolean).orElse(true);
        LOGGER.trace("configuration property [%s] = [%b]", "verifyica.maven.plugin.log.timing", this.consoleLogTiming);
        this.consoleLogTimingUnits = Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.units")).orElse("milliseconds");
        LOGGER.trace("configuration property [%s] = [%s]", "verifyica.maven.plugin.log.units", this.consoleLogTimingUnits);
        this.consoleLogMessagesStarted = Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.messages.started")).map(Boolean::parseBoolean).orElse(true);
        LOGGER.trace("configuration property [%s] = [%b]", "verifyica.maven.plugin.log.messages.started", this.consoleLogMessagesStarted);
        this.consoleLogMessagesFinished = Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.messages.finished")).map(Boolean::parseBoolean).orElse(true);
        LOGGER.trace("configuration property [%s] = [%b]", "verifyica.maven.plugin.log.messages.finished", this.consoleLogMessagesFinished);
        this.consoleLogMessagesSkipped = Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.skip.messages")).map(Boolean::parseBoolean).orElse(true);
        LOGGER.trace("configuration property [%s] = [%b]", "verifyica.maven.plugin.log.skip.messages", this.consoleLogMessagesSkipped);
        this.consoleTestMessage = new AnsiColorStringBuilder().append(AnsiColor.TEXT_WHITE_BRIGHT).append(Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.test.message")).orElse("TEST")).color(AnsiColor.TEXT_RESET).toString();
        this.consolePassMessage = new AnsiColorStringBuilder().color(AnsiColor.TEXT_GREEN_BOLD_BRIGHT).append(Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.pass.message")).orElse("PASS")).color(AnsiColor.TEXT_RESET).toString();
        this.consoleSkipMessage = new AnsiColorStringBuilder().color(AnsiColor.TEXT_YELLOW_BOLD_BRIGHT).append(Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.skip.message")).orElse("SKIP")).color(AnsiColor.TEXT_RESET).toString();
        this.consoleFailMessage = new AnsiColorStringBuilder().color(AnsiColor.TEXT_RED_BOLD_BRIGHT).append(Optional.ofNullable(configuration.get("verifyica.maven.plugin.log.fail.message")).orElse("FAIL")).color(AnsiColor.TEXT_RESET).toString();
        this.stopWatchMap = new ConcurrentHashMap<TestDescriptor, StopWatch>();
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        if (this.consoleLogMessagesStarted && StatusEngineExecutionListener.shouldProcessDescriptor(testDescriptor)) {
            this.stopWatchMap.put(testDescriptor, new StopWatch());
            try {
                Class<?> testClass = StatusEngineExecutionListener.getTestClass(testDescriptor);
                String testClassDisplayName = DisplayNameSupport.getDisplayName(testClass);
                String testMethodDisplayName = null;
                if (testDescriptor instanceof TestMethodTestDescriptor) {
                    Method testMethod = StatusEngineExecutionListener.getTestMethod(testDescriptor);
                    testMethodDisplayName = DisplayNameSupport.getDisplayName(testMethod) + "()";
                }
                String testArgumentDisplayName = null;
                if (testDescriptor instanceof TestMethodTestDescriptor || testDescriptor instanceof ArgumentTestDescriptor) {
                    Argument<?> testArgument = StatusEngineExecutionListener.getTestArgument(testDescriptor);
                    testArgumentDisplayName = testArgument.getName();
                }
                AnsiColorStringBuilder ansiColorStringBuilder = new AnsiColorStringBuilder().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append(this.consoleTestMessage).color(AnsiColor.TEXT_RESET);
                if (testArgumentDisplayName != null) {
                    ansiColorStringBuilder.append(" | ").append(testArgumentDisplayName);
                }
                ansiColorStringBuilder.append(" | ").append(testClassDisplayName);
                if (testMethodDisplayName != null) {
                    ansiColorStringBuilder.append(" | ").append(testMethodDisplayName);
                }
                ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
                System.out.println(ansiColorStringBuilder);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (this.consoleLogMessagesSkipped && StatusEngineExecutionListener.shouldProcessDescriptor(testDescriptor)) {
            Duration elapsedTime = this.stopWatchMap.remove(testDescriptor).stop().elapsedTime();
            try {
                Class<?> testClass = StatusEngineExecutionListener.getTestClass(testDescriptor);
                String testClassDisplayName = DisplayNameSupport.getDisplayName(testClass);
                String testMethodDisplayName = null;
                if (testDescriptor instanceof TestMethodTestDescriptor) {
                    Method testMethod = StatusEngineExecutionListener.getTestMethod(testDescriptor);
                    testMethodDisplayName = DisplayNameSupport.getDisplayName(testMethod) + "()";
                }
                String testArgumentDisplayName = null;
                if (testDescriptor instanceof TestMethodTestDescriptor || testDescriptor instanceof ArgumentTestDescriptor) {
                    Argument<?> testArgument = StatusEngineExecutionListener.getTestArgument(testDescriptor);
                    testArgumentDisplayName = testArgument.getName();
                }
                AnsiColorStringBuilder ansiColorStringBuilder = new AnsiColorStringBuilder().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append(AnsiColor.TEXT_WHITE_BRIGHT);
                ansiColorStringBuilder.append(this.consoleSkipMessage).color(AnsiColor.TEXT_RESET);
                if (testArgumentDisplayName != null) {
                    ansiColorStringBuilder.append(" | ").append(testArgumentDisplayName);
                }
                ansiColorStringBuilder.append(" | ").append(testClassDisplayName);
                if (testMethodDisplayName != null) {
                    ansiColorStringBuilder.append(" | ").append(testMethodDisplayName);
                }
                if (this.consoleLogTiming && elapsedTime != null) {
                    ansiColorStringBuilder.append(" ").append(HumanReadableTimeSupport.toTimingUnit(elapsedTime.toNanos(), this.consoleLogTimingUnits));
                }
                ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
                System.out.println(ansiColorStringBuilder);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        if (this.consoleLogMessagesFinished && StatusEngineExecutionListener.shouldProcessDescriptor(testDescriptor)) {
            Duration elapsedTime = this.stopWatchMap.remove(testDescriptor).stop().elapsedTime();
            try {
                Class<?> testClass = StatusEngineExecutionListener.getTestClass(testDescriptor);
                String testClassDisplayName = DisplayNameSupport.getDisplayName(testClass);
                String testMethodDisplayName = null;
                if (testDescriptor instanceof TestMethodTestDescriptor) {
                    Method testMethod = StatusEngineExecutionListener.getTestMethod(testDescriptor);
                    testMethodDisplayName = DisplayNameSupport.getDisplayName(testMethod) + "()";
                }
                String testArgumentDisplayName = null;
                if (testDescriptor instanceof TestMethodTestDescriptor || testDescriptor instanceof ArgumentTestDescriptor) {
                    Argument<?> testArgument = StatusEngineExecutionListener.getTestArgument(testDescriptor);
                    testArgumentDisplayName = testArgument.getName();
                }
                AnsiColorStringBuilder ansiColorStringBuilder = new AnsiColorStringBuilder().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append(AnsiColor.TEXT_WHITE_BRIGHT);
                TestExecutionResult.Status status = testExecutionResult.getStatus();
                switch (status) {
                    case SUCCESSFUL: {
                        ansiColorStringBuilder.append(this.consolePassMessage);
                        break;
                    }
                    case FAILED: {
                        ansiColorStringBuilder.append(this.consoleFailMessage);
                        break;
                    }
                    case ABORTED: {
                        ansiColorStringBuilder.append(this.consoleSkipMessage);
                        break;
                    }
                    default: {
                        ansiColorStringBuilder.append(AnsiColor.TEXT_CYAN_BOLD.wrap("????"));
                    }
                }
                ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
                if (testArgumentDisplayName != null) {
                    ansiColorStringBuilder.append(" | ").append(testArgumentDisplayName);
                }
                ansiColorStringBuilder.append(" | ").append(testClassDisplayName);
                if (testMethodDisplayName != null) {
                    ansiColorStringBuilder.append(" | ").append(testMethodDisplayName);
                }
                if (this.consoleLogTiming && elapsedTime != null) {
                    ansiColorStringBuilder.append(" ").append(HumanReadableTimeSupport.toTimingUnit(elapsedTime.toNanos(), this.consoleLogTimingUnits));
                }
                ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
                System.out.println(ansiColorStringBuilder);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    private static Class<?> getTestClass(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof TestMethodTestDescriptor) {
            return ((ClassTestDescriptor)((Object)((TestDescriptor)testDescriptor.getParent().get()).getParent().get())).getTestClass();
        }
        if (testDescriptor instanceof ArgumentTestDescriptor) {
            return ((ClassTestDescriptor)((Object)testDescriptor.getParent().get())).getTestClass();
        }
        return ((ClassTestDescriptor)testDescriptor).getTestClass();
    }

    private static Argument<?> getTestArgument(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof TestMethodTestDescriptor) {
            return ((ArgumentTestDescriptor)((Object)testDescriptor.getParent().get())).getTestArgument();
        }
        return ((ArgumentTestDescriptor)testDescriptor).getTestArgument();
    }

    private static Method getTestMethod(TestDescriptor testDescriptor) {
        return ((TestMethodTestDescriptor)testDescriptor).getTestMethod();
    }

    private static boolean shouldProcessDescriptor(TestDescriptor testDescriptor) {
        return testDescriptor instanceof ClassTestDescriptor || testDescriptor instanceof ArgumentTestDescriptor || testDescriptor instanceof TestMethodTestDescriptor;
    }
}

