/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.listener;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.antublue.verifyica.engine.VerifyicaEngine;
import org.antublue.verifyica.engine.common.AnsiColor;
import org.antublue.verifyica.engine.common.AnsiColorStringBuilder;
import org.antublue.verifyica.engine.common.StopWatch;
import org.antublue.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.antublue.verifyica.engine.descriptor.ClassTestDescriptor;
import org.antublue.verifyica.engine.descriptor.StatusEngineDescriptor;
import org.antublue.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.antublue.verifyica.engine.support.HumanReadableTimeSupport;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public class SummaryEngineExecutionListener
implements EngineExecutionListener {
    private static final String BANNER = new AnsiColorStringBuilder().color(AnsiColor.TEXT_WHITE_BRIGHT).append("Verifyica ").append(VerifyicaEngine.staticGetVersion()).color(AnsiColor.TEXT_RESET).toString();
    private static final String SUMMARY_BANNER = BANNER + AnsiColor.TEXT_WHITE_BRIGHT.wrap(" Summary");
    private static final String SEPARATOR = AnsiColor.TEXT_WHITE_BRIGHT.wrap("------------------------------------------------------------------------");
    private static final String INFO = new AnsiColorStringBuilder().color(AnsiColor.TEXT_WHITE).append("[").color(AnsiColor.TEXT_BLUE_BOLD).append("INFO").color(AnsiColor.TEXT_WHITE).append("]").color(AnsiColor.TEXT_RESET).append(" ").toString();
    private static final Map<String, String> counterKeyToMessageDisplayStringMap = new HashMap<String, String>();
    private boolean hasTests;
    private boolean hasFailures;
    private final Map<ClassTestDescriptor, TestExecutionResult> classTestDescriptorTestExecutionResultMap = new ConcurrentHashMap<ClassTestDescriptor, TestExecutionResult>();
    private final Map<ClassTestDescriptor, String> classTestDescriptorSkippedMap = new ConcurrentHashMap<ClassTestDescriptor, String>();
    private final Map<ArgumentTestDescriptor, TestExecutionResult> argumentTestDescriptorTestExecutionResultMap = new ConcurrentHashMap<ArgumentTestDescriptor, TestExecutionResult>();
    private final Map<ArgumentTestDescriptor, String> argumentTestDescriptorSkippedMap = new ConcurrentHashMap<ArgumentTestDescriptor, String>();
    private final Map<TestMethodTestDescriptor, TestExecutionResult> methodTestDescriptorTestExecutionResultMap = new ConcurrentHashMap<TestMethodTestDescriptor, TestExecutionResult>();
    private final Map<TestMethodTestDescriptor, String> methodTestDescriptorSkippedMap = new ConcurrentHashMap<TestMethodTestDescriptor, String>();
    private final Map<String, AtomicLong> counterMap = new ConcurrentHashMap<String, AtomicLong>();
    private final StopWatch stopWatch = new StopWatch();

    public SummaryEngineExecutionListener() {
        SummaryEngineExecutionListener.println(INFO + SEPARATOR);
        SummaryEngineExecutionListener.println(INFO + BANNER);
        SummaryEngineExecutionListener.println(INFO + SEPARATOR);
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor.isRoot()) {
            this.stopWatch.reset();
        }
        if (!testDescriptor.isRoot()) {
            this.hasTests = true;
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (testDescriptor instanceof ClassTestDescriptor) {
            this.classTestDescriptorSkippedMap.put((ClassTestDescriptor)testDescriptor, reason);
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            this.argumentTestDescriptorSkippedMap.put((ArgumentTestDescriptor)testDescriptor, reason);
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            this.methodTestDescriptorSkippedMap.put((TestMethodTestDescriptor)testDescriptor, reason);
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        if (testDescriptor instanceof ClassTestDescriptor) {
            this.classTestDescriptorTestExecutionResultMap.put((ClassTestDescriptor)testDescriptor, testExecutionResult);
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            this.argumentTestDescriptorTestExecutionResultMap.put((ArgumentTestDescriptor)testDescriptor, testExecutionResult);
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            this.methodTestDescriptorTestExecutionResultMap.put((TestMethodTestDescriptor)testDescriptor, testExecutionResult);
        }
        if (!testDescriptor.isRoot() && testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
            this.hasFailures = true;
        }
        if (testDescriptor instanceof StatusEngineDescriptor) {
            if (this.hasFailures) {
                ((StatusEngineDescriptor)testDescriptor).setHasFailures();
            }
            this.summary();
        }
    }

    private void summary() {
        try {
            String[] keys;
            String key;
            TestExecutionResult.Status status;
            TestExecutionResult testExecutionResult;
            int i;
            this.stopWatch.stop();
            for (i = 0; i < this.classTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.class.count";
                this.counterMap.computeIfAbsent(string, o -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", o -> new AtomicLong()).incrementAndGet();
            }
            for (i = 0; i < this.argumentTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.argument.count";
                this.counterMap.computeIfAbsent(string, o -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", o -> new AtomicLong()).incrementAndGet();
            }
            for (i = 0; i < this.methodTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.method.count";
                this.counterMap.computeIfAbsent(string, o -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", o -> new AtomicLong()).incrementAndGet();
            }
            for (Map.Entry<ClassTestDescriptor, TestExecutionResult> entry : this.classTestDescriptorTestExecutionResultMap.entrySet()) {
                testExecutionResult = entry.getValue();
                status = testExecutionResult.getStatus();
                key = "test.class.count";
                this.counterMap.computeIfAbsent(key, o -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".aborted", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            for (Map.Entry<AbstractTestDescriptor, TestExecutionResult> entry : this.argumentTestDescriptorTestExecutionResultMap.entrySet()) {
                testExecutionResult = entry.getValue();
                status = testExecutionResult.getStatus();
                key = "test.argument.count";
                this.counterMap.computeIfAbsent(key, o -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".aborted", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            for (Map.Entry<AbstractTestDescriptor, TestExecutionResult> entry : this.methodTestDescriptorTestExecutionResultMap.entrySet()) {
                testExecutionResult = entry.getValue();
                status = testExecutionResult.getStatus();
                key = "test.method.count";
                this.counterMap.computeIfAbsent(key, o -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".aborted", o -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            if (this.hasTests) {
                SummaryEngineExecutionListener.println(INFO + SEPARATOR);
                SummaryEngineExecutionListener.println(INFO + SUMMARY_BANNER);
                SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            }
            int countPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".count")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int n = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".successful")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int failedPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".failed")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int abortedPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".aborted")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int skipPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".skipped")).map(Map.Entry::getValue).collect(Collectors.toList()));
            for (String key3 : keys = new String[]{"test.class", "test.argument", "test.method"}) {
                String[] subKeys;
                StringBuilder stringBuilder = new StringBuilder();
                key3 = key3 + ".count";
                stringBuilder.append(INFO + AnsiColor.TEXT_WHITE_BRIGHT.wrap(counterKeyToMessageDisplayStringMap.get(key3)) + " : " + AnsiColor.TEXT_WHITE_BRIGHT.wrap(SummaryEngineExecutionListener.pad(this.counterMap.computeIfAbsent(key3, o -> new AtomicLong()).get(), countPad)));
                for (String subKey : subKeys = new String[]{key3 + ".successful", key3 + ".failed", key3 + ".aborted", key3 + ".skipped"}) {
                    String countDisplayString;
                    String messageDisplayString = counterKeyToMessageDisplayStringMap.get(subKey);
                    long count = this.counterMap.computeIfAbsent(subKey, o -> new AtomicLong()).get();
                    if (subKey.endsWith(".successful")) {
                        messageDisplayString = AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(count, n));
                    } else if (subKey.endsWith(".failed")) {
                        messageDisplayString = AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(count, failedPad));
                    } else if (subKey.endsWith(".aborted")) {
                        messageDisplayString = AnsiColor.TEXT_YELLOW_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_YELLOW_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(count, abortedPad));
                    } else {
                        messageDisplayString = AnsiColor.TEXT_WHITE_BOLD.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_WHITE_BOLD.wrap(SummaryEngineExecutionListener.pad(count, skipPad));
                    }
                    stringBuilder.append(", " + messageDisplayString + " : " + countDisplayString);
                }
                SummaryEngineExecutionListener.println(stringBuilder.toString());
            }
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            String message = this.hasFailures ? AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap("TESTS FAILED") : AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap("TESTS PASSED");
            SummaryEngineExecutionListener.println(INFO + message);
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            Duration elapsedTime = this.stopWatch.elapsedTime();
            SummaryEngineExecutionListener.println(new AnsiColorStringBuilder().append(INFO).color(AnsiColor.TEXT_WHITE_BRIGHT).append("Total time  : ").append(HumanReadableTimeSupport.toHumanReadable(elapsedTime.toNanos(), HumanReadableTimeSupport.Format.SHORT)).append(" (").append((double)elapsedTime.toNanos() / 1000000.0).append(" ms)").color(AnsiColor.TEXT_RESET));
            SummaryEngineExecutionListener.println(new AnsiColorStringBuilder().append(INFO).color(AnsiColor.TEXT_WHITE_BRIGHT).append("Finished at : ").append(HumanReadableTimeSupport.now()).color(AnsiColor.TEXT_RESET));
            if (!this.hasFailures) {
                SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private static void println(Object object) {
        System.out.println(object);
    }

    private static int getPad(List<AtomicLong> atomicLongs) {
        int pad = 0;
        for (AtomicLong atomicLong : atomicLongs) {
            pad = Math.max(pad, String.valueOf(atomicLong.get()).length());
        }
        return pad;
    }

    private static String pad(long value, long width) {
        String string = String.valueOf(value);
        StringBuilder stringBuilder = new StringBuilder();
        while ((long)(stringBuilder.length() + string.length()) < width) {
            stringBuilder.append(" ");
        }
        return stringBuilder.append(string).toString();
    }

    static {
        counterKeyToMessageDisplayStringMap.put("test.class.count", "TEST CLASSES  ");
        counterKeyToMessageDisplayStringMap.put("test.class.count.successful", "PASSED");
        counterKeyToMessageDisplayStringMap.put("test.class.count.failed", "FAILED");
        counterKeyToMessageDisplayStringMap.put("test.class.count.aborted", "ABORTED");
        counterKeyToMessageDisplayStringMap.put("test.class.count.skipped", "SKIPPED");
        counterKeyToMessageDisplayStringMap.put("test.argument.count", "TEST ARGUMENTS");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.successful", "PASSED");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.failed", "FAILED");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.aborted", "ABORTED");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.skipped", "SKIPPED");
        counterKeyToMessageDisplayStringMap.put("test.method.count", "TEST METHODS  ");
        counterKeyToMessageDisplayStringMap.put("test.method.count.successful", "PASSED");
        counterKeyToMessageDisplayStringMap.put("test.method.count.failed", "FAILED");
        counterKeyToMessageDisplayStringMap.put("test.method.count.aborted", "ABORTED");
        counterKeyToMessageDisplayStringMap.put("test.method.count.skipped", "SKIPPED");
    }
}

