/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.logger;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antublue.verifyica.api.Configuration;
import org.antublue.verifyica.engine.configuration.DefaultConfiguration;
import org.antublue.verifyica.engine.logger.Level;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class Logger {
    private static final Configuration CONFIGURATION = DefaultConfiguration.getInstance();
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private final String name;
    private Level level;

    Logger(String name) {
        this.name = name;
        this.level = Level.INFO;
        String loggerLevel = CONFIGURATION.getOptional("verifyica.engine.logger.level").orElse(Level.INFO.toString());
        String regex = CONFIGURATION.getOptional("verifyica.engine.logger.regex").orElse(".*");
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(name);
            if (matcher.find()) {
                this.level = Level.decode(loggerLevel);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isTraceEnabled() {
        return this.level.toInt() >= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.level.toInt() >= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.level.toInt() >= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.level.toInt() >= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.level.toInt() >= Level.ERROR.toInt();
    }

    public void setLevel(Level level) {
        ArgumentSupport.notNull(this.name, "level is null");
        this.level = level;
    }

    public boolean isEnabled(Level level) {
        ArgumentSupport.notNull(this.name, "level is null");
        return this.level.toInt() >= level.toInt();
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.log(System.out, Level.TRACE, "%s", message);
        }
    }

    public void trace(String format, Object ... objects) {
        ArgumentSupport.notNullOrEmpty(format, "format is null", "format is empty");
        if (this.isTraceEnabled()) {
            this.log(System.out, Level.TRACE, format, objects);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log(System.out, Level.DEBUG, "%s", message);
        }
    }

    public void debug(String format, Object ... objects) {
        ArgumentSupport.notNullOrEmpty(format, "format is null", "format is empty");
        if (this.isDebugEnabled()) {
            this.log(System.out, Level.DEBUG, format, objects);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.log(System.out, Level.INFO, "%s", message);
        }
    }

    public void info(String format, Object ... objects) {
        ArgumentSupport.notNullOrEmpty(format, "format is null", "format is empty");
        if (this.isInfoEnabled()) {
            this.log(System.out, Level.INFO, format, objects);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.log(System.out, Level.WARN, "%s", message);
        }
    }

    public void warn(String format, Object ... objects) {
        ArgumentSupport.notNullOrEmpty(format, "format is null", "format is empty");
        if (this.isWarnEnabled()) {
            this.log(System.out, Level.WARN, format, objects);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.log(System.err, Level.ERROR, "%s", message);
        }
    }

    public void error(String format, Object ... objects) {
        ArgumentSupport.notNullOrEmpty(format, "format is null", "format is empty");
        if (this.isErrorEnabled()) {
            this.log(System.err, Level.ERROR, format, objects);
        }
    }

    public void flush() {
        System.err.flush();
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(PrintStream printStream, Level level, String format, Object ... objects) {
        String dateTime;
        SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            dateTime = SIMPLE_DATE_FORMAT.format(new Date());
        }
        printStream.println(new StringBuilder(80).append(dateTime).append(" | ").append(Thread.currentThread().getName()).append(" | ").append(level.toString()).append(" | ").append(this.name).append(" | ").append(String.format(format, objects)));
    }
}

