/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.support;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.antublue.verifyica.engine.support.ArgumentSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class ClassPathSupport {
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static List<URI> URIS;

    private ClassPathSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URI> getClasspathURIs() {
        try {
            LOCK.lock();
            if (URIS == null) {
                String[] paths;
                LinkedHashSet<URI> uriSet = new LinkedHashSet<URI>();
                String classpath = System.getProperty("java.class.path");
                for (String path : paths = classpath.split(File.pathSeparator)) {
                    uriSet.add(new File(path).toURI());
                }
                URIS = new ArrayList<URI>(uriSet);
            }
            List<URI> list = URIS;
            return list;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static List<Class<?>> findClasses(Predicate<Class<?>> predicate) {
        ArgumentSupport.notNull(predicate, "predicate is null");
        LinkedHashSet set = new LinkedHashSet();
        ClassPathSupport.getClasspathURIs().forEach(uri -> set.addAll(ReflectionSupport.findAllClassesInClasspathRoot((URI)uri, (Predicate)predicate, name -> true)));
        return new ArrayList(set);
    }

    public static List<Class<?>> findClasses(URI uri, Predicate<Class<?>> predicate) {
        ArgumentSupport.notNull(uri, "uri is null");
        ArgumentSupport.notNull(predicate, "predicate is null");
        return new ArrayList(ReflectionSupport.findAllClassesInClasspathRoot((URI)uri, predicate, className -> true));
    }

    public static List<Class<?>> findClasses(String packageName, Predicate<Class<?>> predicate) {
        ArgumentSupport.notNullOrEmpty(packageName, "packageName is null", "packageName is empty");
        ArgumentSupport.notNull(predicate, "predicate is null");
        return new ArrayList(ReflectionSupport.findAllClassesInPackage((String)packageName.trim(), predicate, className -> true));
    }

    public static List<URL> findResources(String regex) throws IOException {
        ArgumentSupport.notNullOrEmpty(regex, "regex is null", "regex is empty");
        Pattern pattern = Pattern.compile(regex.trim());
        ArrayList<URL> resourceUrls = new ArrayList<URL>();
        for (URI uri : ClassPathSupport.getClasspathURIs()) {
            Path path = Paths.get(uri);
            if (Files.isDirectory(path, new LinkOption[0])) {
                ClassPathSupport.scanDirectory(pattern, path, resourceUrls);
                continue;
            }
            if (!path.toString().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
            ClassPathSupport.scanJarFile(pattern, path, resourceUrls);
        }
        return resourceUrls;
    }

    private static void scanDirectory(Pattern pattern, Path directoryPath, List<URL> resourceUrls) throws IOException {
        Files.walkFileTree(directoryPath, new PathSimpleFileVisitor(pattern, resourceUrls));
    }

    private static void scanJarFile(Pattern pattern, Path jarPath, List<URL> resourceUrls) throws IOException {
        try (JarFile jarFile = new JarFile(jarPath.toFile().getPath());){
            Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
            while (jarEntryEnumeration.hasMoreElements()) {
                JarEntry jarEntry = jarEntryEnumeration.nextElement();
                if (jarEntry.isDirectory() || !pattern.matcher(jarEntry.getName()).matches()) continue;
                resourceUrls.add(new URL("jar:" + jarPath.toUri() + "!/" + jarEntry.getName()));
            }
        }
    }

    private static class PathSimpleFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Pattern pattern;
        private final List<URL> foundUrls;

        public PathSimpleFileVisitor(Pattern pattern, List<URL> foundUrls) {
            this.pattern = pattern;
            this.foundUrls = foundUrls;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            if (basicFileAttributes.isRegularFile() && this.pattern.matcher(path.getFileName().toString()).matches()) {
                this.foundUrls.add(path.toUri().toURL());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException ioException) {
            return FileVisitResult.CONTINUE;
        }
    }
}

