/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.support;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ExecutorTool;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.SemaphoreExecutor;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadTool;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.antublue.verifyica.engine.exception.EngineException;
import org.antublue.verifyica.engine.logger.Logger;
import org.antublue.verifyica.engine.logger.LoggerFactory;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class ExecutorServiceSupport {
    private ExecutorServiceSupport() {
    }

    public static ExecutorService createExecutorService(int threads) {
        ArgumentSupport.isTrue(threads > 0, "threads is less than 1");
        ExecutorService executorService = ThreadTool.hasVirtualThreads() ? new SemaphoreExecutor(ExecutorTool.newVirtualThreadPerTaskExecutor(), new Semaphore(threads, true)) : new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threads * 10), new BlockingRejectedExecutionHandler());
        return executorService;
    }

    public static ExecutorService createSemaphoreExecutorService(ExecutorService executorService, int permits) {
        ArgumentSupport.notNull(executorService, "executorService is null");
        ArgumentSupport.isTrue(permits > 0, "permits is less than 1");
        return ExecutorServiceSupport.createSemaphoreExecutorService(executorService, new Semaphore(permits, true));
    }

    public static ExecutorService createSemaphoreExecutorService(ExecutorService executorService, Semaphore semaphore) {
        ArgumentSupport.notNull(executorService, "executorService is null");
        ArgumentSupport.notNull(semaphore, "semaphore is null");
        return new SemaphoreExecutor(executorService, semaphore);
    }

    public static void waitForAll(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (Throwable t) {
                throw new EngineException("Exception waiting on future", t);
            }
        }
    }

    private static class BlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(BlockingRejectedExecutionHandler.class);

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            ArgumentSupport.notNull(runnable, "runnable is null");
            ArgumentSupport.notNull(executor, "executor is null");
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(runnable);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Runnable discarded!!!");
                }
            }
        }
    }
}

