/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.support;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.antublue.verifyica.engine.support.ArgumentSupport;
import org.antublue.verifyica.engine.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class FieldSupport {
    private FieldSupport() {
    }

    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode hierarchyTraversalMode) {
        ArgumentSupport.notNull(clazz, "clazz is null");
        ArgumentSupport.notNull(predicate, "predicate is null");
        ArgumentSupport.notNull((Object)hierarchyTraversalMode, "hierarchyTraversalMode is null");
        return new ArrayList<Field>(ReflectionSupport.findFields(clazz, predicate, (org.junit.platform.commons.support.HierarchyTraversalMode)HierarchyTraversalMode.decode(hierarchyTraversalMode)));
    }

    public static void setField(Object object, Field field, Object value) throws Throwable {
        ArgumentSupport.notNull(field, "field is null");
        if (value == null) {
            Class<?> fieldType = field.getType();
            if (fieldType.equals(Boolean.TYPE)) {
                field.set(object, false);
            } else if (fieldType.equals(Byte.TYPE)) {
                field.set(object, (byte)0);
            } else if (fieldType.equals(Character.TYPE)) {
                field.set(object, Character.valueOf('\u0000'));
            } else if (fieldType.equals(Short.TYPE)) {
                field.set(object, (short)0);
            } else if (fieldType.equals(Integer.TYPE)) {
                field.set(object, 0);
            } else if (fieldType.equals(Long.TYPE)) {
                field.set(object, 0L);
            } else if (fieldType.equals(Float.TYPE)) {
                field.set(object, Float.valueOf(0.0f));
            } else if (fieldType.equals(Double.TYPE)) {
                field.set(object, 0.0);
            } else {
                field.set(object, null);
            }
        } else if (field.getType().equals(String.class)) {
            field.set(object, value.toString());
        } else {
            field.set(object, value);
        }
    }
}

