/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class ObjectSupport {
    private ObjectSupport() {
    }

    public static <T> T createObject(Class<?> clazz) throws Throwable {
        ArgumentSupport.notNull(clazz, "clazz is null");
        return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static String toString(Method ... methods) {
        if (methods == null) {
            throw new IllegalArgumentException("methods is null");
        }
        return ObjectSupport.toString(Arrays.stream(methods).collect(Collectors.toList()));
    }

    public static String toString(List<Method> methods) {
        ArgumentSupport.notNull(methods, "methods is null");
        StringBuilder stringBuilder = new StringBuilder();
        if (methods != null) {
            Iterator<Method> iterator = methods.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().getName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }
}

